/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.telnetHandler;

import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.exchange.ExchangeChannel;
import com.alibaba.dubbo.remoting.exchange.ExchangeServer;
import com.alibaba.dubbo.remoting.telnet.support.Help;
import com.frameworkx.annotation.Activate;
import java.util.Collection;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.common.extension.utils.StringUtils;
import net.jahhan.extension.protocol.DubboProtocol;
import net.jahhan.spi.TelnetHandler;

@Activate
@Extension(value="ps")
@Singleton
@Help(parameter="[-l] [port]", summary="Print server ports and connections.", detail="Print server ports and connections.")
public class PortTelnetHandler
implements TelnetHandler {
    public String telnet(Channel channel, String message) {
        StringBuilder buf = new StringBuilder();
        String port = null;
        boolean detail = false;
        if (message.length() > 0) {
            String[] parts = message.split("\\s+");
            for (String part : parts) {
                if ("-l".equals(part)) {
                    detail = true;
                    continue;
                }
                if (!StringUtils.isInteger((String)part)) {
                    return "Illegal port " + part + ", must be integer.";
                }
                port = part;
            }
        }
        if (port == null || port.length() == 0) {
            for (ExchangeServer server : DubboProtocol.getDubboProtocol().getServers()) {
                if (buf.length() > 0) {
                    buf.append("\r\n");
                }
                if (detail) {
                    buf.append(server.getUrl().getProtocol() + "://" + server.getUrl().getAddress());
                    continue;
                }
                buf.append(server.getUrl().getPort());
            }
        } else {
            ExchangeServer server;
            int p = Integer.parseInt(port);
            server = null;
            for (ExchangeServer s : DubboProtocol.getDubboProtocol().getServers()) {
                if (p != s.getUrl().getPort()) continue;
                server = s;
                break;
            }
            if (server != null) {
                Collection channels = server.getExchangeChannels();
                for (ExchangeChannel c : channels) {
                    if (buf.length() > 0) {
                        buf.append("\r\n");
                    }
                    if (detail) {
                        buf.append(c.getRemoteAddress() + " -> " + c.getLocalAddress());
                        continue;
                    }
                    buf.append(c.getRemoteAddress());
                }
            } else {
                buf.append("No such port " + port);
            }
        }
        return buf.toString();
    }
}

