/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.statusChecker;

import com.alibaba.dubbo.common.Constants;
import com.frameworkx.annotation.Activate;
import com.frameworkx.common.extension.utils.ExtensionExtendUtil;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.extension.statusChecker.Status;
import net.jahhan.spi.DataStore;
import net.jahhan.spi.StatusChecker;

@Activate
@Extension(value="threadpool")
@Singleton
public class ThreadPoolStatusChecker
implements StatusChecker {
    public Status check() {
        DataStore dataStore = (DataStore)ExtensionExtendUtil.getExtension(DataStore.class);
        Map executors = dataStore.get(Constants.EXECUTOR_SERVICE_COMPONENT_KEY);
        StringBuilder msg = new StringBuilder();
        Status.Level level = Status.Level.OK;
        for (Map.Entry entry : executors.entrySet()) {
            String port = (String)entry.getKey();
            ExecutorService executor = (ExecutorService)entry.getValue();
            if (executor == null || !(executor instanceof ThreadPoolExecutor)) continue;
            ThreadPoolExecutor tp = (ThreadPoolExecutor)executor;
            boolean ok = tp.getActiveCount() < tp.getMaximumPoolSize() - 1;
            Status.Level lvl = Status.Level.OK;
            if (!ok) {
                level = Status.Level.WARN;
                lvl = Status.Level.WARN;
            }
            if (msg.length() > 0) {
                msg.append(";");
            }
            msg.append("Pool status:" + lvl + ", max:" + tp.getMaximumPoolSize() + ", core:" + tp.getCorePoolSize() + ", largest:" + tp.getLargestPoolSize() + ", active:" + tp.getActiveCount() + ", task:" + tp.getTaskCount() + ", service port: " + port);
        }
        return msg.length() == 0 ? new Status(Status.Level.UNKNOWN) : new Status(level, msg.toString());
    }
}

