/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.dubbo;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.AtomicPositiveInteger;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.TimeoutException;
import com.alibaba.dubbo.remoting.exchange.ExchangeClient;
import com.alibaba.dubbo.remoting.exchange.ResponseFuture;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.protocol.AbstractInvoker;
import com.alibaba.dubbo.rpc.protocol.dubbo.FutureAdapter;
import com.alibaba.dubbo.rpc.support.RpcUtils;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import net.jahhan.exception.JahhanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboInvoker<T>
extends AbstractInvoker<T> {
    private static final Logger log = LoggerFactory.getLogger(DubboInvoker.class);
    private final ExchangeClient[] clients;
    private final AtomicPositiveInteger index = new AtomicPositiveInteger();
    private final String version;
    private final ReentrantLock destroyLock = new ReentrantLock();
    private final Set<Invoker<?>> invokers;

    public DubboInvoker(Class<T> serviceType, URL url, ExchangeClient[] clients) {
        this(serviceType, url, clients, null);
    }

    public DubboInvoker(Class<T> serviceType, URL url, ExchangeClient[] clients, Set<Invoker<?>> invokers) {
        super(serviceType, url, new String[]{"interface", "group", "token", "timeout"});
        this.clients = clients;
        this.version = url.getParameter("version", "0.0.0");
        this.invokers = invokers;
    }

    protected Result doInvoke(Invocation invocation) throws Throwable {
        RpcInvocation inv = (RpcInvocation)invocation;
        String methodName = RpcUtils.getMethodName((Invocation)invocation);
        inv.setAttachment("path", this.getUrl().getPath());
        inv.setAttachment("version", this.version);
        ExchangeClient currentClient = this.clients.length == 1 ? this.clients[0] : this.clients[this.index.getAndIncrement() % this.clients.length];
        try {
            boolean isAsync = RpcUtils.isAsync((URL)this.getUrl(), (Invocation)invocation);
            boolean isOneway = RpcUtils.isOneway((URL)this.getUrl(), (Invocation)invocation);
            int timeout = this.getUrl().getMethodParameter(methodName, "timeout", 1000);
            if (isOneway) {
                boolean isSent = this.getUrl().getMethodParameter(methodName, "sent", false);
                currentClient.send((Object)inv, isSent);
                RpcContext.getContext().setFuture(null);
                return new RpcResult();
            }
            if (isAsync) {
                ResponseFuture future = currentClient.request((Object)inv, timeout);
                RpcContext.getContext().setFuture(new FutureAdapter(future));
                return new RpcResult();
            }
            RpcContext.getContext().setFuture(null);
            return (Result)currentClient.request((Object)inv, timeout).get();
        }
        catch (TimeoutException e) {
            throw new JahhanException(952, "Invoke remote method timeout. method: " + invocation.getMethodName() + ", provider: " + this.getUrl() + ", cause: " + e.getMessage(), (Throwable)e);
        }
        catch (RemotingException e) {
            throw new JahhanException(951, "Failed to invoke remote method: " + invocation.getMethodName() + ", provider: " + this.getUrl() + ", cause: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        for (ExchangeClient client : this.clients) {
            if (!client.isConnected() || client.hasAttribute("channel.readonly")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (super.isDestroyed()) {
            return;
        }
        this.destroyLock.lock();
        try {
            if (super.isDestroyed()) {
                return;
            }
            super.destroy();
            if (this.invokers != null) {
                this.invokers.remove((Object)this);
            }
            for (ExchangeClient client : this.clients) {
                try {
                    client.close(DubboInvoker.getShutdownTimeout());
                }
                catch (Throwable t) {
                    log.warn(t.getMessage(), t);
                }
            }
        }
        finally {
            this.destroyLock.unlock();
        }
    }

    protected static int getShutdownTimeout() {
        int timeout = 10000;
        String value = ConfigUtils.getProperty((String)"dubbo.service.shutdown.wait");
        if (value != null && value.length() > 0) {
            try {
                timeout = Integer.parseInt(value);
            }
            catch (Exception exception) {}
        } else {
            value = ConfigUtils.getProperty((String)"dubbo.service.shutdown.wait.seconds");
            if (value != null && value.length() > 0) {
                try {
                    timeout = Integer.parseInt(value) * 1000;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return timeout;
    }
}

