/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.filter;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.monitor.Monitor;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.support.RpcUtils;
import com.frameworkx.annotation.Activate;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.Filter;
import net.jahhan.spi.MonitorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider", "consumer"})
@Extension(value="monitor")
@Singleton
public class MonitorFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MonitorFilter.class);
    private final ConcurrentMap<String, AtomicInteger> concurrents = new ConcurrentHashMap<String, AtomicInteger>();
    private MonitorFactory monitorFactory;

    public void setMonitorFactory(MonitorFactory monitorFactory) {
        this.monitorFactory = monitorFactory;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws JahhanException {
        if (invoker.getUrl().hasParameter("monitor")) {
            RpcContext context = RpcContext.getContext();
            long start = System.currentTimeMillis();
            this.getConcurrent(invoker, invocation).incrementAndGet();
            try {
                Result result = invoker.invoke(invocation);
                this.collect(invoker, invocation, result, context, start, false);
                Result result2 = result;
                return result2;
            }
            catch (JahhanException e) {
                this.collect(invoker, invocation, null, context, start, true);
                throw e;
            }
            finally {
                this.getConcurrent(invoker, invocation).decrementAndGet();
            }
        }
        return invoker.invoke(invocation);
    }

    private void collect(Invoker<?> invoker, Invocation invocation, Result result, RpcContext context, long start, boolean error) {
        try {
            String remoteValue;
            String remoteKey;
            int localPort;
            long elapsed = System.currentTimeMillis() - start;
            int concurrent = this.getConcurrent(invoker, invocation).get();
            String application = invoker.getUrl().getParameter("application");
            String service = invoker.getInterface().getName();
            String method = RpcUtils.getMethodName((Invocation)invocation);
            URL url = invoker.getUrl().getUrlParameter("monitor");
            Monitor monitor = this.monitorFactory.getMonitor(url);
            if ("consumer".equals(invoker.getUrl().getParameter("side"))) {
                context = RpcContext.getContext();
                localPort = 0;
                remoteKey = "provider";
                remoteValue = invoker.getUrl().getAddress();
            } else {
                localPort = invoker.getUrl().getPort();
                remoteKey = "consumer";
                remoteValue = context.getRemoteHost();
            }
            String input = "";
            String output = "";
            if (invocation.getAttachment("input") != null) {
                input = invocation.getAttachment("input");
            }
            if (result != null && result.getAttachment("output") != null) {
                output = result.getAttachment("output");
            }
            monitor.collect(new URL("count", NetUtils.getLocalHost(), localPort, service + "/" + method, new String[]{"application", application, "interface", service, "method", method, remoteKey, remoteValue, error ? "failure" : "success", "1", "elapsed", String.valueOf(elapsed), "concurrent", String.valueOf(concurrent), "input", input, "output", output}));
        }
        catch (Throwable t) {
            log.error("Failed to monitor count service " + invoker.getUrl() + ", cause: " + t.getMessage(), t);
        }
    }

    private AtomicInteger getConcurrent(Invoker<?> invoker, Invocation invocation) {
        String key = invoker.getInterface().getName() + "." + invocation.getMethodName();
        AtomicInteger concurrent = (AtomicInteger)this.concurrents.get(key);
        if (concurrent == null) {
            this.concurrents.putIfAbsent(key, new AtomicInteger());
            concurrent = (AtomicInteger)this.concurrents.get(key);
        }
        return concurrent;
    }
}

