/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.listener.common;

import com.google.inject.Injector;
import com.google.inject.servlet.GuiceServletContextListener;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.servlet.ServletContextEvent;
import javax.servlet.annotation.WebListener;
import net.jahhan.common.extension.utils.NamedThreadFactory;
import net.jahhan.common.extension.utils.PropertiesUtil;
import net.jahhan.context.Node;
import net.jahhan.init.InitMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ApplicationContextListener
extends GuiceServletContextListener {
    protected static InitMethod initMethod;
    public static Injector injector;

    public void contextInitialized(ServletContextEvent sce) {
        Node node = Node.getInstance();
        String threadNum = PropertiesUtil.get("base", "syncServlet.thread");
        ExecutorService executor = Executors.newFixedThreadPool(null == threadNum || threadNum.equals("") ? Runtime.getRuntime().availableProcessors() + 1 : Integer.valueOf(threadNum), new NamedThreadFactory("asyncHttp", false));
        sce.getServletContext().setAttribute("executor", (Object)executor);
        if (!InitMethod.init) {
            long startTime = System.currentTimeMillis();
            this.appInfoInit();
            Map<String, Integer> ports = node.getPorts();
            node.addServletContext(ports.get("http"), sce.getServletContext());
            initMethod = new InitMethod(true);
            super.contextInitialized(sce);
            this.init();
            Logger log = LoggerFactory.getLogger((String)"message.start.info");
            log.debug("start cost:{}ms", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    protected void init() {
        initMethod.init();
    }

    protected Injector getInjector() {
        injector = initMethod.getInjector(null);
        return injector;
    }

    private void appInfoInit() {
        Iterator<MBeanServer> iterator;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String name = runtimeMXBean.getName();
        Integer pid = Integer.parseInt(name.substring(0, name.indexOf(64)));
        System.setProperty("pid", pid.toString());
        Node node = Node.getInstance();
        node.setPid(pid);
        MBeanServer mBeanServer = null;
        ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(null);
        if (mBeanServers.size() > 0 && (iterator = mBeanServers.iterator()).hasNext()) {
            MBeanServer _mBeanServer;
            mBeanServer = _mBeanServer = iterator.next();
        }
        Set<ObjectName> objectNames = null;
        try {
            objectNames = mBeanServer.queryNames(new ObjectName("*:type=Connector,*"), null);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        if (objectNames == null || objectNames.size() <= 0) {
            throw new IllegalStateException("\u6ca1\u6709\u53d1\u73b0JVM\u4e2d\u5173\u8054\u7684MBeanServer : " + mBeanServer.getDefaultDomain() + " \u4e2d\u7684\u5bf9\u8c61\u540d\u79f0.");
        }
        for (ObjectName objectName : objectNames) {
            try {
                String protocol = (String)mBeanServer.getAttribute(objectName, "protocol");
                if (!protocol.equals("HTTP/1.1")) continue;
                int port = (Integer)mBeanServer.getAttribute(objectName, "port");
                Map<String, Integer> ports = node.getPorts();
                ports.put("http", port);
                System.setProperty("port", String.valueOf(port));
                break;
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstanceNotFoundException e) {
                e.printStackTrace();
            }
            catch (MBeanException e) {
                e.printStackTrace();
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)sce.getServletContext().getAttribute("executor");
        executor.shutdown();
    }
}

