/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.init;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.jahhan.common.extension.constant.BaseConfiguration;
import net.jahhan.common.extension.constant.InjectType;
import net.jahhan.common.extension.utils.ClassScaner;
import net.jahhan.common.extension.utils.LogUtil;
import net.jahhan.common.extension.utils.PackageUtil;
import net.jahhan.common.extension.utils.PropertiesUtil;
import net.jahhan.context.BaseContext;
import net.jahhan.exception.JahhanException;
import net.jahhan.init.BootstrapInit;
import net.jahhan.init.InitAnnocation;
import net.jahhan.init.ModuleHolder;
import net.jahhan.init.WorkHandler;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.guice.injector.InjectorHolder;

public class InitMethod {
    public static boolean init = false;
    private static boolean isWeb = true;
    private Injector injector;

    public InitMethod(boolean isWeb) {
        init = true;
        InitMethod.isWeb = isWeb;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public void init() {
        TreeMap<Integer, BootstrapInit> workHandlerMap = new TreeMap<Integer, BootstrapInit>();
        HashSet<BootstrapInit> lazyWorkHandlerSet = new HashSet<BootstrapInit>();
        try {
            String[] packages = PackageUtil.packages("init.initer");
            List<String> classNameList = new ClassScaner().parse(packages);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (String className : classNameList) {
                Class<?> clazz = classLoader.loadClass(className);
                if (!clazz.isAnnotationPresent(InitAnnocation.class) || !BootstrapInit.class.isAssignableFrom(clazz)) continue;
                InitAnnocation serviceContextListener = clazz.getAnnotation(InitAnnocation.class);
                boolean isLazy = serviceContextListener.isLazy();
                boolean initOverWait = serviceContextListener.initOverWait();
                if (!isWeb && serviceContextListener.onlyWeb()) continue;
                final BootstrapInit workHandler = (BootstrapInit)this.injector.getInstance(clazz);
                if (!initOverWait) {
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                workHandler.execute();
                            }
                            catch (Exception e) {
                                LogUtil.error(e.getMessage(), e);
                            }
                        }
                    };
                    thread.start();
                    continue;
                }
                if (isLazy) {
                    lazyWorkHandlerSet.add(workHandler);
                    continue;
                }
                if (workHandlerMap.containsKey(serviceContextListener.initSequence())) {
                    JahhanException.throwException(998, "\u542f\u52a8\u5668\u5305\u542b\u76f8\u540c\u542f\u52a8\u5e8f\u5217\uff01");
                }
                workHandlerMap.put(serviceContextListener.initSequence(), workHandler);
            }
            Iterator workHandlerIt = workHandlerMap.keySet().iterator();
            while (workHandlerIt.hasNext()) {
                WorkHandler workHandler = (WorkHandler)workHandlerMap.get(workHandlerIt.next());
                workHandler.execute();
            }
            Iterator lazyWorkHandlerIt = lazyWorkHandlerSet.iterator();
            ExecutorService service = Executors.newFixedThreadPool(20);
            while (lazyWorkHandlerIt.hasNext()) {
                final WorkHandler workHandler = (WorkHandler)lazyWorkHandlerIt.next();
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            workHandler.execute();
                        }
                        catch (Exception e) {
                            LogUtil.error(e.getMessage(), e);
                        }
                    }
                };
                service.execute(thread);
            }
            service.shutdown();
            service.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            LogUtil.error(e.getMessage(), e);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException inex) {
                LogUtil.error(inex.getMessage(), inex);
            }
            System.exit(-1);
        }
    }

    public static ModuleHolder orderModule() {
        TreeMap moduleMap = new TreeMap();
        HashSet lazyModuleSet = new HashSet();
        try {
            String[] packages = PackageUtil.packages("init.module");
            List<String> classNameList = new ClassScaner().parse(packages);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            boolean isLazy = true;
            for (String className : classNameList) {
                Class<?> clazz = classLoader.loadClass(className);
                if (!clazz.isAnnotationPresent(InitAnnocation.class) || !Module.class.isAssignableFrom(clazz)) continue;
                InitAnnocation serviceContextListener = clazz.getAnnotation(InitAnnocation.class);
                isLazy = serviceContextListener.isLazy();
                if (!isWeb && serviceContextListener.onlyWeb()) continue;
                if (isLazy) {
                    lazyModuleSet.add(clazz);
                    continue;
                }
                if (moduleMap.containsKey(serviceContextListener.initSequence())) {
                    JahhanException.throwException(998, "module\u5305\u542b\u76f8\u540c\u542f\u52a8\u5e8f\u5217\uff01");
                }
                moduleMap.put(serviceContextListener.initSequence(), clazz);
            }
        }
        catch (Throwable e) {
            LogUtil.error(e.getMessage(), e);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException inex) {
                LogUtil.error(inex.getMessage(), inex);
            }
            System.exit(-1);
        }
        ModuleHolder moduleHolder = new ModuleHolder();
        moduleHolder.setLazyModuleSet(lazyModuleSet);
        moduleHolder.setModuleMap(moduleMap);
        return moduleHolder;
    }

    public Injector getInjector(String[] args) {
        ModuleHolder orderModule = InitMethod.orderModule();
        Map<Integer, Class<?>> moduleMap = orderModule.getModuleMap();
        Set<Class<?>> lazyModuleSet = orderModule.getLazyModuleSet();
        try {
            String applicationClasses;
            Collection<Class<?>> values;
            ArrayList<Module> moduleList = new ArrayList<Module>();
            Iterator<Integer> workHandlerIt = moduleMap.keySet().iterator();
            while (workHandlerIt.hasNext()) {
                Class<?> moduleClass = moduleMap.get(workHandlerIt.next());
                Module module = (Module)moduleClass.newInstance();
                moduleList.add(module);
            }
            if (BaseConfiguration.INJECT_TYPE.equals((Object)InjectType.guice)) {
                for (Class<?> moduleClass : lazyModuleSet) {
                    Module module = (Module)moduleClass.newInstance();
                    moduleList.add(module);
                }
                this.injector = Guice.createInjector((Module[])moduleList.toArray(new Module[moduleList.size()]));
            } else if (BaseConfiguration.INJECT_TYPE.equals((Object)InjectType.spring)) {
                Class[] array;
                values = moduleMap.values();
                applicationClasses = PropertiesUtil.get("base", "applicationClasses");
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{applicationClasses})) {
                    String[] split = applicationClasses.split(",");
                    array = values.toArray(new Class[values.size() + split.length]);
                    for (int i = 0; i < split.length; ++i) {
                        array[values.size() + i] = Class.forName(split[i]);
                    }
                } else {
                    array = values.toArray(new Class[values.size()]);
                }
                AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(array);
                InjectorHolder instance = InjectorHolder.getInstance();
                instance.setContext((ConfigurableApplicationContext)context);
                this.injector = instance.getInjector();
            } else if (BaseConfiguration.INJECT_TYPE.equals((Object)InjectType.springboot)) {
                Object[] array;
                values = moduleMap.values();
                applicationClasses = PropertiesUtil.get("base", "applicationClasses");
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{applicationClasses})) {
                    String[] split = applicationClasses.split(",");
                    array = values.toArray(new Class[values.size() + split.length]);
                    for (int i = 0; i < split.length; ++i) {
                        array[values.size() + i] = Class.forName(split[i]);
                    }
                } else {
                    array = values.toArray(new Class[values.size()]);
                }
                SpringApplicationBuilder builder = new SpringApplicationBuilder(array);
                ConfigurableApplicationContext context = builder.run(args);
                InjectorHolder instance = InjectorHolder.getInstance();
                instance.setContext(context);
                this.injector = instance.getInjector();
            }
            this.injector.getInstance(BaseContext.class);
        }
        catch (Throwable e) {
            LogUtil.error(e.getMessage(), e);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException inex) {
                LogUtil.error(inex.getMessage(), inex);
            }
            System.exit(-1);
        }
        return this.injector;
    }
}

