/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.exception;

import java.util.Date;
import net.jahhan.common.extension.constant.BaseConfiguration;
import net.jahhan.common.extension.utils.LocalIpUtils;
import net.jahhan.context.BaseVariable;
import net.jahhan.exception.ExceptionMessage;

public class JahhanException
extends RuntimeException {
    private static final long serialVersionUID = -3297153548445915405L;
    protected ExceptionMessage exceptionMessage = new ExceptionMessage();
    private static int defaultHttpStatus = 500;

    public JahhanException(int httpStatus, int code, String msg, ExceptionMessage cause) {
        super(msg);
        this.exceptionMessage.setHttpStatus(httpStatus);
        this.exceptionMessage.setCode(code);
        this.exceptionMessage.setMessage(msg);
        this.exceptionMessage.setService(BaseConfiguration.SERVICE);
        BaseVariable baseVariable = BaseVariable.getBaseVariable();
        if (null != baseVariable) {
            this.exceptionMessage.setRequestId(baseVariable.getRequestId());
            this.exceptionMessage.setChainId(baseVariable.getChainId());
        }
        this.exceptionMessage.setHost(LocalIpUtils.getFirstIp());
        this.exceptionMessage.setThreadId(Thread.currentThread().getId());
        this.exceptionMessage.setThreadName(Thread.currentThread().getName());
        this.exceptionMessage.setTime(new Date());
        this.exceptionMessage.setCause(cause);
    }

    public JahhanException(int code, String msg, ExceptionMessage cause) {
        this(defaultHttpStatus, code, msg, cause);
        this.exceptionMessage.setHttpStatus(cause.getHttpStatus());
    }

    public JahhanException(int httpStatus, int code, String msg) {
        this(httpStatus, code, msg, (ExceptionMessage)null);
    }

    public JahhanException(int code, String msg) {
        this(defaultHttpStatus, code, msg);
    }

    public JahhanException(String msg) {
        this(defaultHttpStatus, 999, msg);
    }

    public JahhanException(int httpStatus, int code, String msg, Throwable exception) {
        super(msg, exception);
        if (null != exception) {
            ExceptionMessage cause = new ExceptionMessage();
            cause.setMessage(exception.getMessage());
            this.exceptionMessage.setCause(cause);
        }
        this.exceptionMessage.setHttpStatus(httpStatus);
        this.exceptionMessage.setCode(code);
        this.exceptionMessage.setMessage(msg);
        this.exceptionMessage.setService(BaseConfiguration.SERVICE);
        BaseVariable baseVariable = BaseVariable.getBaseVariable();
        if (null != baseVariable) {
            this.exceptionMessage.setRequestId(baseVariable.getRequestId());
            this.exceptionMessage.setChainId(baseVariable.getChainId());
        }
        this.exceptionMessage.setHost(LocalIpUtils.getFirstIp());
        this.exceptionMessage.setThreadId(Thread.currentThread().getId());
        this.exceptionMessage.setThreadName(Thread.currentThread().getName());
        this.exceptionMessage.setTime(new Date());
    }

    public JahhanException(int code, String msg, Throwable exception) {
        this(defaultHttpStatus, code, msg, exception);
    }

    public JahhanException(String msg, Throwable exception) {
        this(defaultHttpStatus, 999, msg, exception);
    }

    public JahhanException(Throwable exception) {
        this(defaultHttpStatus, 999, exception.getMessage(), exception.getCause());
    }

    public JahhanException(int code, Throwable exception) {
        this(defaultHttpStatus, code, exception.getMessage(), exception.getCause());
    }

    public static void throwException(int code, String msg, ExceptionMessage cause) {
        throw new JahhanException(code, msg, cause);
    }

    public static void throwException(int code, String msg) {
        throw new JahhanException(code, msg);
    }

    public static void throwException(int code, String msg, Throwable exception) {
        throw new JahhanException(code, msg, exception);
    }

    public static void throwException(int httpStatus, int code, String msg, ExceptionMessage cause) {
        throw new JahhanException(httpStatus, code, msg, cause);
    }

    public static void throwException(int httpStatus, int code, String msg) {
        throw new JahhanException(httpStatus, code, msg);
    }

    public static void throwException(int httpStatus, int code, String msg, Throwable exception) {
        throw new JahhanException(httpStatus, code, msg, exception);
    }

    public int getCode() {
        return this.exceptionMessage.getCode();
    }

    public void setCode(int code) {
        this.exceptionMessage.setCode(code);
    }

    @Override
    public String getMessage() {
        return this.exceptionMessage.getMessage();
    }

    public boolean isBiz() {
        return this.exceptionMessage.getCode() == 953;
    }

    public boolean isForbidded() {
        return this.exceptionMessage.getCode() == 954;
    }

    public boolean isTimeout() {
        return this.exceptionMessage.getCode() == 952;
    }

    public boolean isNetwork() {
        return this.exceptionMessage.getCode() == 951;
    }

    public boolean isSerialization() {
        return this.exceptionMessage.getCode() == 955;
    }

    public ExceptionMessage getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(ExceptionMessage exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    @Override
    public String toString() {
        return "JahhanException(exceptionMessage=" + this.getExceptionMessage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JahhanException)) {
            return false;
        }
        JahhanException other = (JahhanException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExceptionMessage this$exceptionMessage = this.getExceptionMessage();
        ExceptionMessage other$exceptionMessage = other.getExceptionMessage();
        return !(this$exceptionMessage == null ? other$exceptionMessage != null : !((Object)this$exceptionMessage).equals(other$exceptionMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JahhanException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExceptionMessage $exceptionMessage = this.getExceptionMessage();
        result = result * 59 + ($exceptionMessage == null ? 43 : ((Object)$exceptionMessage).hashCode());
        return result;
    }
}

