/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.context;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class Node {
    private String nodeId;
    private String host;
    private String registHost;
    private Map<String, Integer> ports = new HashMap<String, Integer>();
    private Map<String, Integer> registPorts = new HashMap<String, Integer>();
    private Integer pid = 0;
    private final Map<Integer, ServletContext> contextMap = new ConcurrentHashMap<Integer, ServletContext>();
    private static Node instance = null;

    private Node() {
        System.setProperty("nodeId", UUID.randomUUID().toString());
        this.nodeId = System.getProperty("nodeId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Node getInstance() {
        if (instance != null) return instance;
        Class<Node> clazz = Node.class;
        synchronized (Node.class) {
            if (instance != null) return instance;
            instance = new Node();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addServletContext(int port, ServletContext servletContext) {
        this.contextMap.put(port, servletContext);
    }

    public void removeServletContext(int port) {
        this.contextMap.remove(port);
    }

    public ServletContext getServletContext(int port) {
        return this.contextMap.get(port);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getHost() {
        return this.host;
    }

    public String getRegistHost() {
        return this.registHost;
    }

    public Map<String, Integer> getPorts() {
        return this.ports;
    }

    public Map<String, Integer> getRegistPorts() {
        return this.registPorts;
    }

    public Integer getPid() {
        return this.pid;
    }

    public Map<Integer, ServletContext> getContextMap() {
        return this.contextMap;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setRegistHost(String registHost) {
        this.registHost = registHost;
    }

    public void setPorts(Map<String, Integer> ports) {
        this.ports = ports;
    }

    public void setRegistPorts(Map<String, Integer> registPorts) {
        this.registPorts = registPorts;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$registHost = this.getRegistHost();
        String other$registHost = other.getRegistHost();
        if (this$registHost == null ? other$registHost != null : !this$registHost.equals(other$registHost)) {
            return false;
        }
        Map<String, Integer> this$ports = this.getPorts();
        Map<String, Integer> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        Map<String, Integer> this$registPorts = this.getRegistPorts();
        Map<String, Integer> other$registPorts = other.getRegistPorts();
        if (this$registPorts == null ? other$registPorts != null : !((Object)this$registPorts).equals(other$registPorts)) {
            return false;
        }
        Integer this$pid = this.getPid();
        Integer other$pid = other.getPid();
        if (this$pid == null ? other$pid != null : !((Object)this$pid).equals(other$pid)) {
            return false;
        }
        Map<Integer, ServletContext> this$contextMap = this.getContextMap();
        Map<Integer, ServletContext> other$contextMap = other.getContextMap();
        return !(this$contextMap == null ? other$contextMap != null : !((Object)this$contextMap).equals(other$contextMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Node;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $registHost = this.getRegistHost();
        result = result * 59 + ($registHost == null ? 43 : $registHost.hashCode());
        Map<String, Integer> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        Map<String, Integer> $registPorts = this.getRegistPorts();
        result = result * 59 + ($registPorts == null ? 43 : ((Object)$registPorts).hashCode());
        Integer $pid = this.getPid();
        result = result * 59 + ($pid == null ? 43 : ((Object)$pid).hashCode());
        Map<Integer, ServletContext> $contextMap = this.getContextMap();
        result = result * 59 + ($contextMap == null ? 43 : ((Object)$contextMap).hashCode());
        return result;
    }

    public String toString() {
        return "Node(nodeId=" + this.getNodeId() + ", host=" + this.getHost() + ", registHost=" + this.getRegistHost() + ", ports=" + this.getPorts() + ", registPorts=" + this.getRegistPorts() + ", pid=" + this.getPid() + ", contextMap=" + this.getContextMap() + ")";
    }
}

