/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.common.extension.utils;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import net.jahhan.common.extension.utils.LogUtil;
import net.jahhan.common.extension.utils.properties.PropertiesInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger log;

    public static Properties getProperties(String fileSortName) {
        return PropertiesInit.get(fileSortName, new Properties());
    }

    public static String get(String fileSortName, String key) {
        Properties properties = PropertiesUtil.getProperties(fileSortName);
        if (null != properties) {
            return properties.getProperty(key);
        }
        return null;
    }

    private static Properties load(String fileName) {
        Properties props;
        block28: {
            props = new Properties();
            try (InputStream is = PropertiesUtil.class.getClassLoader().getResourceAsStream(fileName);){
                if (is == null) break block28;
                try (InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
                    props.load(reader);
                }
                catch (Exception e) {
                    LogUtil.error("error when load props " + fileName, e);
                }
            }
            catch (Exception e) {
                LogUtil.error("error when load props " + fileName, e);
            }
        }
        return props;
    }

    static {
        File[] tempList;
        log = LoggerFactory.getLogger(PropertiesUtil.class);
        ClassLoader classLoader = PropertiesUtil.class.getClassLoader();
        URL url = classLoader.getResource("./");
        String resourcePath = null;
        String osName = System.getProperty("os.name");
        log.debug("file url\uff1a" + url);
        if (null != url) {
            resourcePath = url.getPath();
            if (null == osName || !osName.contains("Windows")) {
                String[] split = resourcePath.split(":");
                resourcePath = split[0];
            }
        } else {
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            url = threadClassLoader.getResource("/");
            log.debug("file url2\uff1a" + url);
            if (null != url) {
                resourcePath = url.getPath();
                if (null == osName || !osName.contains("Windows")) {
                    String[] split = resourcePath.split(":");
                    resourcePath = split[0];
                }
            } else {
                String envClassPath = System.getProperty("java.class.path");
                String[] classPath = envClassPath.split(";");
                if (classPath.length <= 1) {
                    classPath = envClassPath.split(":");
                }
                if (classPath.length > 1) {
                    String[] stringArray = classPath;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String path = stringArray[i];
                        if (path.endsWith("classes")) {
                            resourcePath = path;
                            break;
                        }
                        if (!path.contains("apache-jmeter") || !path.contains("ext")) continue;
                        File file = new File(path);
                        resourcePath = file.getParent();
                    }
                }
                if (null == resourcePath) {
                    resourcePath = classPath[0];
                }
            }
        }
        File file = new File(resourcePath);
        for (File f : tempList = file.listFiles()) {
            String fileName = f.getName();
            if (!f.isFile() || !fileName.endsWith(".properties")) continue;
            String fileSortName = fileName.replace(".properties", "");
            Properties properties = PropertiesUtil.load(f.getName());
            if (fileSortName.equals("system")) {
                Properties sysProperties = properties;
                for (String string : sysProperties.keySet()) {
                    System.setProperty(string, sysProperties.getProperty(string));
                }
                PropertiesInit.reset("system", System.getProperties());
            } else {
                PropertiesInit.reset(fileSortName, properties);
            }
            log.debug("\u52a0\u8f7d\u6587\u4ef6\uff1a" + fileName);
        }
    }
}

