/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.com.alibaba.dubbo.common.serialize.support.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.TimeZone;
import net.jahhan.common.extension.utils.ExtensionUtil;
import net.jahhan.spi.common.JacksonObjectMapperProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jackson {
    private static Logger logger = LoggerFactory.getLogger(Jackson.class);
    private static ObjectMapper objectMapper;

    private static JacksonObjectMapperProvider getJacksonProvider() {
        return ExtensionUtil.getExtension(JacksonObjectMapperProvider.class);
    }

    public static ObjectMapper getObjectMapper() {
        JacksonObjectMapperProvider jacksonObjectMapperProvider;
        if (objectMapper == null && (jacksonObjectMapperProvider = Jackson.getJacksonProvider()) != null) {
            objectMapper = jacksonObjectMapperProvider.getObjectMapper();
        }
        if (objectMapper == null) {
            logger.warn("load objectMapper failed, use default config.");
            Jackson.buildDefaultObjectMapper();
        }
        return objectMapper;
    }

    private static synchronized void buildDefaultObjectMapper() {
        objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setTimeZone(TimeZone.getDefault());
    }
}

