/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.cache.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jahhan.com.alibaba.dubbo.common.serialize.ObjectInput;
import net.jahhan.com.alibaba.dubbo.common.serialize.ObjectOutput;
import net.jahhan.common.extension.utils.LogUtil;
import net.jahhan.context.BaseContext;
import net.jahhan.spi.common.Serialization;

public class SerializerUtil {
    private static Serialization serializer = (Serialization)BaseContext.CTX.getInjector().getInstance(Serialization.class);

    public static <T> T deserialize(byte[] bytes, Class<T> clazz) {
        Object readObject = null;
        try {
            ObjectInput deserialize = serializer.deserialize((InputStream)new ByteArrayInputStream(bytes));
            readObject = deserialize.readObject(clazz);
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return (T)readObject;
    }

    public static byte[] serializeFrom(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutput objectOutput = serializer.serialize((OutputStream)byteArrayOutputStream);
            objectOutput.writeObject(object);
            objectOutput.flushBuffer();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

