/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.cache.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.jahhan.common.extension.utils.LogUtil;
import org.apache.commons.lang3.StringUtils;

public class DateTimeUtils {
    private static final String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};

    public static long getTimesMorning() {
        return DateTimeUtils.getTimesMorning(System.currentTimeMillis());
    }

    public static long getTimesMorning(long timeMillis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMillis);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static String getFormatTime(Timestamp datetime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String st = sdf.format(datetime);
        return st.substring(st.length() - 8);
    }

    public static long getTimes(int hour, int second, int minute, int millsecond) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(11, hour);
        cal.set(13, second);
        cal.set(12, minute);
        cal.set(14, millsecond);
        return cal.getTimeInMillis();
    }

    public static long getTimesNight() {
        return DateTimeUtils.getTimesNight(System.currentTimeMillis());
    }

    public static long getTimesNight(long timeMillis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMillis);
        cal.set(11, 24);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long getTimesMonthNight() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 24);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static Timestamp str2Timestamp(String yyyymmddhhmmss) {
        Timestamp ts = Timestamp.valueOf(yyyymmddhhmmss);
        return ts;
    }

    public static String timestamp2Str(Timestamp datetime) {
        String st = "";
        if (datetime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            st = sdf.format(datetime);
        }
        if (st.contains(".")) {
            st = st.substring(0, st.lastIndexOf("."));
        }
        return st;
    }

    public static String time2Str(long time, String format) {
        Date datetime = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(datetime);
    }

    public static String timestampStr2Str(String timesStampSr) {
        if (timesStampSr != null && !timesStampSr.isEmpty() && timesStampSr.contains(".")) {
            timesStampSr = timesStampSr.substring(0, timesStampSr.lastIndexOf("."));
        }
        return timesStampSr;
    }

    public static Timestamp long2Timestamp(long time) {
        return new Timestamp(time);
    }

    public static long getTimeStampSeconds(Timestamp datetime) {
        long millionSeconds = datetime.getTime();
        return millionSeconds / 1000L;
    }

    public static long getTimeMillis(String time) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
            SimpleDateFormat dayFormat = new SimpleDateFormat("yy-MM-dd");
            Date curDate = dateFormat.parse(dayFormat.format(new Date()) + " " + time);
            return curDate.getTime();
        }
        catch (ParseException e) {
            LogUtil.error((String)"\u89e3\u6790\u65e5\u671f\u51fa\u73b0\u95ee\u9898", (Throwable)e);
            return 0L;
        }
    }

    public static int getDateSeconds(String dateStr) {
        int dateSeconds = 0;
        try {
            SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = dayFormat.parse(dateStr);
            dateSeconds = (int)(date.getTime() / 1000L);
        }
        catch (ParseException ex) {
            LogUtil.error((String)"\u89e3\u6790\u65e5\u671f\u51fa\u73b0\u95ee\u9898", (Throwable)ex);
        }
        return dateSeconds;
    }

    public static long getDateMillionSeconds(String dateStr) {
        long dateSeconds = 0L;
        try {
            SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = dayFormat.parse(dateStr);
            dateSeconds = date.getTime();
        }
        catch (ParseException ex) {
            LogUtil.error((String)"\u89e3\u6790\u65e5\u671f\u51fa\u73b0\u95ee\u9898", (Throwable)ex);
        }
        return dateSeconds;
    }

    public static String getWeekName(String dateStr) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(DateTimeUtils.getDateMillionSeconds(dateStr));
        int dayOfWeek = calendar.get(7) - 1;
        if (dayOfWeek < 0) {
            dayOfWeek = 0;
        }
        return weekDays[dayOfWeek];
    }

    public static int getWeekIndex(String dateStr) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(DateTimeUtils.getDateMillionSeconds(dateStr));
        int dayOfWeek = calendar.get(7) - 1;
        if (dayOfWeek < 0) {
            dayOfWeek = 0;
        }
        return dayOfWeek;
    }

    public static int getCurrentWeekIndex() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int dayOfWeek = calendar.get(7);
        switch (dayOfWeek) {
            case 1: {
                return 7;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return 0;
    }

    public static boolean isToday(Timestamp timestamp) {
        long days;
        long now;
        long times;
        long diff;
        boolean isToday = false;
        if (timestamp != null && (diff = (times = DateTimeUtils.getTimes(23, 59, 59, 0)) - (now = timestamp.getTime())) > 0L && (days = diff / 86400000L) == 0L) {
            isToday = true;
        }
        return isToday;
    }

    public static int getDay(Date timestamp) {
        String st = "";
        if (timestamp != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            st = sdf.format(timestamp);
        }
        return Integer.parseInt(st);
    }

    public static String getDayStr(Date timestamp) {
        String st = "";
        if (timestamp != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            st = sdf.format(timestamp);
        }
        return st;
    }

    public static int getLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String st = sdf.format(date);
        return Integer.parseInt(st);
    }

    public static Timestamp getLastDayInTimestamp() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        long time = calendar.getTimeInMillis();
        Timestamp timestamp = new Timestamp(time);
        return timestamp;
    }

    public static Timestamp getDayInTimestamp(int day, long addTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, day);
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        long time = calendar.getTimeInMillis();
        Timestamp timestamp = new Timestamp(time + addTime);
        return timestamp;
    }

    public static long getTimestampDiff(Timestamp firstTimestatmp, Timestamp secondTimestamp) {
        long firstTime = firstTimestatmp.getTime();
        long secondTime = secondTimestamp.getTime();
        return firstTime - secondTime;
    }

    public static int getDateToInteger(String dateStr) {
        int result = 0;
        if (dateStr != null && !dateStr.isEmpty()) {
            result = Integer.parseInt(dateStr.replace("-", "").trim());
        }
        return result;
    }

    public static String convertDateFormat(Integer dateInteger, String format) {
        String result = "";
        if (dateInteger != null && dateInteger != 0 && format != null && !format.isEmpty()) {
            try {
                SimpleDateFormat dayFormat = new SimpleDateFormat("yyyyMMdd");
                Date date = dayFormat.parse(String.valueOf(dateInteger));
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                result = sdf.format(date);
            }
            catch (ParseException ex) {
                LogUtil.error((String)"\u89e3\u6790\u65e5\u671f\u51fa\u73b0\u95ee\u9898", (Throwable)ex);
            }
        }
        return result;
    }

    public static int getDateInSecondes(Integer birthday) {
        int dateSeconds = 0;
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyyMMdd");
        Date date = new Date();
        try {
            if (birthday > 0) {
                date = dayFormat.parse(String.valueOf(birthday));
                dateSeconds = (int)(date.getTime() / 1000L);
            }
        }
        catch (ParseException ex) {
            LogUtil.error((String)"\u89e3\u6790\u65e5\u671f\u51fa\u73b0\u95ee\u9898", (Throwable)ex);
        }
        return dateSeconds;
    }

    public static String getWeek(long currentTime, int daysOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(5, daysOfWeek);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        return dateFormat.format(timestamp);
    }

    public static String getMonth(long currentTime, int month) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(2, month);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        return dateFormat.format(timestamp);
    }

    public static String getDate(long currentTime, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentTime);
        cal.add(5, days);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        return dateFormat.format(timestamp);
    }

    public static String getyyyy_mm_ddDate(long currentTime, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentTime);
        cal.add(5, days);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        return dateFormat.format(timestamp);
    }

    public static String getyyyymmddDate(long currentTime, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentTime);
        cal.add(5, days);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        return dateFormat.format(timestamp);
    }

    public static String getHour(long currentTime, int hours) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(11, hours);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        return dateFormat.format(timestamp);
    }

    public static Timestamp getHourTimestamp(long currentTime, int hours) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(11, hours);
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        return timestamp;
    }

    public static String getyyyy_mm_ddsssDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        return dateFormat.format(timestamp);
    }

    public static String getNowyyyy_mm_dd() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        return dateFormat.format(timestamp);
    }

    public static String getBeforeThirtyDays() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -30);
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String st = sdf.format(date);
        return st;
    }

    public static long getLeaveTimestampDiff(Timestamp sendTimestatmp, int days) {
        Date curDate = null;
        long LeaveLongTime = 0L;
        long LeaveMillisecond = 0L;
        try {
            String sendStrTime = DateTimeUtils.timestamp2Str(sendTimestatmp);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
            curDate = dateFormat.parse(sendStrTime);
            long sendLongTime = curDate.getTime();
            String confirmdata = DateTimeUtils.getDate(sendLongTime, days);
            Date dt = new Date();
            System.out.println(dt.toString());
            long lSysTime = dt.getTime();
            curDate = dateFormat.parse(confirmdata);
            LeaveLongTime = curDate.getTime() - lSysTime;
            LeaveMillisecond = LeaveLongTime / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return LeaveMillisecond;
    }

    public static long getLeaveAckTimestampDiff(Timestamp AckTimestatmp) {
        Date ackDate = null;
        long LeaveLongTime = 0L;
        long LeaveMillisecond = 0L;
        try {
            String ackStrTime = DateTimeUtils.timestamp2Str(AckTimestatmp);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
            ackDate = dateFormat.parse(ackStrTime);
            long ackLongTime = ackDate.getTime();
            Date dt = new Date();
            long lSysTime = dt.getTime();
            LeaveLongTime = ackLongTime - lSysTime;
            LeaveMillisecond = LeaveLongTime / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return LeaveMillisecond;
    }

    public static Timestamp getLeaveTimeBysendTime(Timestamp sendTimestatmp, int days) {
        Date curDate = null;
        Timestamp confirmdataTimestamp = null;
        try {
            String sendStrTime = DateTimeUtils.timestamp2Str(sendTimestatmp);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
            curDate = dateFormat.parse(sendStrTime);
            long sendLongTime = curDate.getTime();
            String confirmdata = DateTimeUtils.getDate(sendLongTime, days);
            confirmdataTimestamp = Timestamp.valueOf(confirmdata);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return confirmdataTimestamp;
    }

    public static Timestamp getProcessDays(int days) {
        Date nowdt = new Date();
        long nowLongTime = nowdt.getTime();
        Timestamp confirmdataTimestamp = null;
        String confirmdata = DateTimeUtils.getDate(nowLongTime, days);
        confirmdataTimestamp = Timestamp.valueOf(confirmdata);
        return confirmdataTimestamp;
    }

    public static void main(String[] args) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        System.out.print(dateFormat.format(timestamp));
    }

    public static String timestamp2StrDate(Timestamp datetime) {
        String st = "";
        if (datetime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            st = sdf.format(datetime);
        }
        if (st.contains(".")) {
            st = st.substring(0, st.lastIndexOf("."));
        }
        return st;
    }

    public static String timestamp2StrMonth(Timestamp datetime) {
        String st = "";
        if (datetime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            st = sdf.format(datetime);
        }
        if (st.contains(".")) {
            st = st.substring(0, st.lastIndexOf("."));
        }
        return st;
    }

    public static long timeComparison(Timestamp timestatmp) {
        Date ackDate = null;
        long LeaveLongTime = 0L;
        try {
            String timeStrTime = DateTimeUtils.timestamp2Str(timestatmp);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
            ackDate = dateFormat.parse(timeStrTime);
            long ackLongTime = ackDate.getTime();
            Date dt = new Date();
            long lSysTime = dt.getTime();
            LeaveLongTime = ackLongTime - lSysTime;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return LeaveLongTime;
    }

    public static String addDate(int num) {
        String str = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar nowdate = Calendar.getInstance();
        nowdate.add(5, num);
        str = sdf.format(nowdate.getTime());
        return str;
    }

    public static Timestamp curTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static long getTimelong(String dateStr) {
        long dateSeconds = 0L;
        try {
            SimpleDateFormat dayFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
            Date date = dayFormat.parse(dateStr);
            dateSeconds = date.getTime();
        }
        catch (ParseException ex) {
            LogUtil.error((String)"\u89e3\u6790\u65e5\u671f\u51fa\u73b0\u95ee\u9898", (Throwable)ex);
        }
        return dateSeconds;
    }

    public static String getcurrent_yyyy_mm_dd() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        return dateFormat.format(timestamp);
    }

    public static String[] getAddExpectedTime(String expectedTime) throws Exception {
        String time = expectedTime;
        String[] array = new String[2];
        int s = 16;
        if (s != time.lastIndexOf("-")) {
            throw new Exception("\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u67e5\u770b\u683c\u5f0f\u662f\u5426\u5982\uff1ayyyy-MM-dd HH:mm-HH:mm\u3002");
        }
        array[0] = time.substring(0, time.lastIndexOf("-")) + ":00";
        String top = time.substring(0, 11);
        array[1] = top + time.substring(time.lastIndexOf("-") + 1, time.length()) + ":00";
        return array;
    }

    public static String getExpectedTime(String begin, String end) throws Exception {
        if (StringUtils.isEmpty((CharSequence)begin)) {
            throw new Exception("\u9884\u8ba1\u9001\u8fbe\u7684\u5f00\u59cb\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002");
        }
        String beginTime = begin.substring(0, begin.lastIndexOf(":"));
        if (StringUtils.isEmpty((CharSequence)end)) {
            throw new Exception("\u9884\u8ba1\u9001\u8fbe\u7684\u7ed3\u675f\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002");
        }
        String endTime = end.substring(11, end.length());
        endTime = endTime.substring(0, endTime.lastIndexOf(":"));
        return beginTime + "-" + endTime;
    }

    public static String getHHMM(String time) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm");
            Date d = df.parse(time);
            return df.format(d);
        }
        catch (ParseException e) {
            LogUtil.error((String)"\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\u3002");
            return "";
        }
    }
}

