/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.cache.repository.common;

import java.util.EventObject;
import net.jahhan.cache.repository.common.AbstractSimpleRepository;
import net.jahhan.cache.util.Counter;
import net.jahhan.cache.util.SerializerUtil;
import net.jahhan.jdbc.event.DBEvent;
import net.jahhan.jdbc.event.EventOperate;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSmpTTLCountRepository
extends AbstractSimpleRepository {
    protected Counter counter = new Counter(500);

    public boolean accept(EventObject event) {
        return DBEvent.class.isInstance(event);
    }

    @Override
    public void set(String id, Object object) {
        String key = this.getKey(id);
        this.cache.setEx(key.getBytes(), this.getExistSecond(), SerializerUtil.serializeFrom(object));
    }

    public void expire(String id) {
        String key = this.getKey(id);
        this.cache.expire(key, this.getExistSecond());
    }

    public Counter getCounter() {
        return this.counter;
    }

    public <T> T get(String id, Class<T> clazz) {
        if (this.counter.isCacheRefresh()) {
            return null;
        }
        byte[] bytes = super.getBytes(String.valueOf(id));
        if (bytes != null) {
            this.counter.incCached();
            return SerializerUtil.deserialize(bytes, clazz);
        }
        return null;
    }

    protected void onListen(EventObject event, Class<?> checkClass) {
        DBEvent ev = (DBEvent)event;
        String id = ev.getId();
        String op = ev.getOperate();
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        if (op.equals("G")) {
            if (!checkClass.isInstance(event.getSource())) {
                return;
            }
            Object cache = this.get(id, checkClass);
            if (null == cache) {
                this.set(id, event.getSource());
            }
            this.expire(id);
        } else if (op.equals("I") || op.equals("U")) {
            if (!checkClass.isInstance(event.getSource())) {
                return;
            }
            this.set(id, event.getSource());
        } else if (op.equals("P")) {
            this.merge(id, ev.getSource(), checkClass);
        } else if (EventOperate.isModify((String)op)) {
            this.del(id);
        }
    }
}

