/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.cache.repository.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.jahhan.cache.util.SerializerUtil;
import net.jahhan.common.extension.constant.BaseConfiguration;
import net.jahhan.common.extension.utils.BeanTools;
import net.jahhan.spi.DBCache;

public abstract class AbstractSimpleRepository {
    @Inject
    protected DBCache cache;

    public int getExistSecond() {
        return BaseConfiguration.GLOBAL_EXPIRE_SECOND;
    }

    protected abstract String getKey(String var1);

    protected abstract String getType();

    public String get(String id) {
        String key = this.getKey(id);
        return this.cache.get(key);
    }

    public byte[] getBytes(String id) {
        String key = this.getKey(id);
        return this.cache.getBinary(key.getBytes());
    }

    public void set(String id, Object object) {
        String key = this.getKey(id);
        this.cache.setByte(key.getBytes(), SerializerUtil.serializeFrom(object));
    }

    public void del(String id) {
        String key = this.getKey(id);
        this.cache.del(key);
    }

    protected String[] getKeys(String[] ids) {
        String[] keys = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            keys[i] = this.getKey(ids[i]);
        }
        return keys;
    }

    public void delMulti(String[] ids) {
        if (ids == null || ids.length == 0) {
            return;
        }
        this.cache.del(ids);
    }

    public List<String> getMultiValue(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] keys = this.getKeys(ids.toArray(new String[ids.size()]));
        return this.cache.mget(keys);
    }

    public List<byte[]> getMultiByteValue(Collection<byte[]> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<byte[]>();
        }
        String[] idsString = new String[ids.size()];
        int i = 0;
        for (byte[] idByte : ids) {
            idsString[i] = new String(idByte);
            ++i;
        }
        String[] keys = this.getKeys(idsString);
        byte[][] keysB = new byte[ids.size()][];
        for (int j = 0; j < ids.size(); ++j) {
            keysB[j] = keys[j].getBytes();
        }
        return this.cache.mgetByte(keysB);
    }

    public <T> List<T> getMultiValue(Collection<String> ids, Class<T> clazz) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList();
        }
        String[] keys = this.getKeys(ids.toArray(new String[ids.size()]));
        byte[][] keysB = new byte[ids.size()][];
        for (int i = 0; i < ids.size(); ++i) {
            keysB[i] = keys[i].getBytes();
        }
        List<byte[]> multi = this.cache.mgetByte(keysB);
        ArrayList<T> result = new ArrayList<T>();
        for (byte[] b : multi) {
            T object = SerializerUtil.deserialize(b, clazz);
            result.add(object);
        }
        return result;
    }

    public List<String> getMultiValue(String[] ids) {
        if (ids == null || ids.length == 0) {
            return new ArrayList<String>();
        }
        String[] keys = this.getKeys(ids);
        return this.cache.mget(keys);
    }

    public void pexpiredAt(String id, long time) {
        String key = this.getKey(id);
        this.cache.pexpireAt(key, time);
    }

    public void expired(String id, int seconds) {
        String key = this.getKey(id);
        this.cache.expire(key, seconds);
    }

    public boolean exists(String id) {
        String key = this.getKey(id);
        return this.cache.exists(key);
    }

    protected void merge(String id, Object updatedObj, Class<?> checkedClass) {
        if (!checkedClass.isInstance(updatedObj)) {
            return;
        }
        byte[] returnBytes = this.getBytes(id);
        if (returnBytes != null) {
            Object mergeObject = AbstractSimpleRepository.mergeObject(SerializerUtil.deserialize(returnBytes, checkedClass), updatedObj);
            this.set(id, mergeObject);
            this.expired(id, this.getExistSecond());
        }
    }

    private static Object mergeObject(Object old, Object updatedObject) {
        Map map = BeanTools.toMap((Object)old);
        Map map2 = BeanTools.toMap((Object)updatedObject);
        map.putAll(map2);
        BeanTools.copyFromMap((Object)updatedObject, (Map)map);
        return updatedObject;
    }
}

