/*
 * Decompiled with CFR 0.152.
 */
package net.jadedungeon.scalautil.dao;

import net.jadedungeon.scalautil.common.Logging;
import net.jadedungeon.scalautil.dao.JoinLastTransaction;
import net.jadedungeon.scalautil.dao.NewTransactionLayer;
import net.jadedungeon.scalautil.dao.NoTransactionLayer;
import net.jadedungeon.scalautil.dao.TransactionLayer;
import org.slf4j.Logger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%4AAD\b\u00011!AQ\u0005\u0001BC\u0002\u0013\u0005a\u0005\u0003\u00053\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u001dA\u0004A1A\u0005\u0002eBa!\u0011\u0001!\u0002\u0013Q\u0004b\u0002\"\u0001\u0001\u0004%\ta\u0011\u0005\b!\u0002\u0001\r\u0011\"\u0001R\u0011\u00199\u0006\u0001)Q\u0005\t\")\u0001\f\u0001C\u00013\")Q\f\u0001C\u0001=\")\u0011\r\u0001C\u00013\")!\r\u0001C\u0001G\")q\r\u0001C!Q\n\u0001BK]1og\u0006\u001cG/[8o'R\f7m\u001b\u0006\u0003!E\t1\u0001Z1p\u0015\t\u00112#A\u0005tG\u0006d\u0017-\u001e;jY*\u0011A#F\u0001\fU\u0006$W\rZ;oO\u0016|gNC\u0001\u0017\u0003\rqW\r^\u0002\u0001'\r\u0001\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t\n\u0012AB2p[6|g.\u0003\u0002%C\t9Aj\\4hS:<\u0017a\u0001;bOV\tq\u0005\u0005\u0002)_9\u0011\u0011&\f\t\u0003Umi\u0011a\u000b\u0006\u0003Y]\ta\u0001\u0010:p_Rt\u0014B\u0001\u0018\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059Z\u0012\u0001\u0002;bO\u0002\na\u0001P5oSRtDCA\u001b8!\t1\u0004!D\u0001\u0010\u0011\u0015)3\u00011\u0001(\u0003\u0011q\u0017-\\3\u0016\u0003i\u0002\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\t1\fgn\u001a\u0006\u0002\u007f\u0005!!.\u0019<b\u0013\t\u0001D(A\u0003oC6,\u0007%\u0001\u0006ue\u0006t7o\u0015;bG.,\u0012\u0001\u0012\t\u0004\u000b*keB\u0001$I\u001d\tQs)C\u0001\u001d\u0013\tI5$A\u0004qC\u000e\\\u0017mZ3\n\u0005-c%\u0001\u0002'jgRT!!S\u000e\u0011\u0005Yr\u0015BA(\u0010\u0005A!&/\u00198tC\u000e$\u0018n\u001c8MCf,'/\u0001\bue\u0006t7o\u0015;bG.|F%Z9\u0015\u0005I+\u0006C\u0001\u000eT\u0013\t!6D\u0001\u0003V]&$\bb\u0002,\b\u0003\u0003\u0005\r\u0001R\u0001\u0004q\u0012\n\u0014a\u0003;sC:\u001c8\u000b^1dW\u0002\nqaY;se\u0016tG\u000fF\u0001[!\rQ2,T\u0005\u00039n\u0011aa\u00149uS>t\u0017\u0001\u00029vg\"$\"AU0\t\u000b\u0001T\u0001\u0019A'\u0002\u0015Q\u0014\u0018M\\:F]R\u0014\u00180A\u0002q_B\fq\"[:J]R\u0013\u0018M\\:bGRLwN\u001c\u000b\u0002IB\u0011!$Z\u0005\u0003Mn\u0011qAQ8pY\u0016\fg.\u0001\u0005u_N#(/\u001b8h)\u00059\u0003")
public class TransactionStack
implements Logging {
    private final String tag;
    private final String name;
    private List<TransactionLayer> transStack;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public Logger getLoggerByName(String name) {
        return Logging.getLoggerByName$(this, name);
    }

    @Override
    public void logTrace(String msg, Seq<Object> refs) {
        Logging.logTrace$(this, msg, refs);
    }

    @Override
    public void logDebug(String msg, Seq<Object> refs) {
        Logging.logDebug$(this, msg, refs);
    }

    @Override
    public void logInfo(String msg, Seq<Object> refs) {
        Logging.logInfo$(this, msg, refs);
    }

    @Override
    public void logWarn(String msg, Seq<Object> refs) {
        Logging.logWarn$(this, msg, refs);
    }

    @Override
    public void logError(String msg, Seq<Object> refs) {
        Logging.logError$(this, msg, refs);
    }

    private Logger logger$lzycompute() {
        TransactionStack transactionStack = this;
        synchronized (transactionStack) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String tag() {
        return this.tag;
    }

    public String name() {
        return this.name;
    }

    public List<TransactionLayer> transStack() {
        return this.transStack;
    }

    public void transStack_$eq(List<TransactionLayer> x$1) {
        this.transStack = x$1;
    }

    public Option<TransactionLayer> current() {
        return this.transStack().isEmpty() ? None$.MODULE$ : new Some(this.transStack().head());
    }

    public void push(TransactionLayer transEntry) {
        this.logTrace("Trans layer stack before push: {}", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transStack()}));
        TransactionLayer transactionLayer = transEntry;
        this.transStack_$eq((List<TransactionLayer>)this.transStack().$colon$colon((Object)transactionLayer));
        this.logTrace("Trans layer stack after push: {}", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transStack()}));
    }

    /*
     * WARNING - void declaration
     */
    public Option<TransactionLayer> pop() {
        void var1_1;
        this.logTrace("Trans layer stack before pop: {}", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transStack()}));
        Option<TransactionLayer> currLayer = this.current();
        this.transStack_$eq((List<TransactionLayer>)((List)this.transStack().tail()));
        this.logTrace("Trans layer stack after  pop: {}", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transStack()}));
        return var1_1;
    }

    public boolean isInTransaction() {
        boolean bl;
        if (this.transStack().isEmpty()) {
            bl = false;
        } else {
            boolean bl2;
            TransactionLayer transactionLayer = (TransactionLayer)this.transStack().head();
            if (transactionLayer instanceof NewTransactionLayer) {
                bl2 = true;
            } else if (transactionLayer instanceof JoinLastTransaction) {
                bl2 = true;
            } else if (transactionLayer instanceof NoTransactionLayer) {
                bl2 = false;
            } else {
                throw new MatchError((Object)transactionLayer);
            }
            bl = bl2;
        }
        return bl;
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("TransStack:%s[%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), this.transStack().toString()}));
    }

    public TransactionStack(String tag) {
        this.tag = tag;
        Logging.$init$(this);
        this.name = new StringBuilder(1).append(tag).append("-").append(System.currentTimeMillis()).toString();
        this.transStack = Nil$.MODULE$;
    }
}

