/*
 * Decompiled with CFR 0.152.
 */
package net.jadedungeon.scalautil.dao;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.jadedungeon.scalautil.dao.Column;
import net.jadedungeon.scalautil.dao.Dialect;
import net.jadedungeon.scalautil.dao.Record;
import net.jadedungeon.scalautil.dao.Table;
import org.apache.commons.lang.StringUtils;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.BigDecimal;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;

public final class ORMUtil$ {
    public static ORMUtil$ MODULE$;
    private final Regex paramRegex;

    static {
        new ORMUtil$();
    }

    public Seq<Map<String, Object>> allRow2map(Set<String> showCols, ResultSet rs) {
        Nil$ lst = Nil$.MODULE$;
        while (rs.next()) {
            Map<String, Object> map = this.row2map(showCols, rs);
            lst = lst.$colon$colon(map);
        }
        rs.close();
        return lst.reverse();
    }

    public Map<String, Object> row2map(Set<String> showCols, ResultSet rs) {
        scala.collection.mutable.Map map = Map$.MODULE$.empty();
        int colCount = rs.getMetaData().getColumnCount();
        IndexedSeq colNames = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), colCount).map((Function1 & Serializable & scala.Serializable)c -> ORMUtil$.$anonfun$row2map$1(rs, BoxesRunTime.unboxToInt((Object)c)), IndexedSeq$.MODULE$.canBuildFrom());
        colNames.foreach((Function1 & Serializable & scala.Serializable)name -> {
            BoxedUnit boxedUnit;
            if (showCols != null && showCols.size() > 0 && showCols.contains(name)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                try {
                    boxedUnit = map.put(name, rs.getObject((String)name));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return boxedUnit;
        });
        return map.toMap(Predef$.MODULE$.$conforms());
    }

    public <T extends Record<K>, K> Seq<T> allRow2obj(Class<T> clazz, Set<String> showCols, ResultSet rs) {
        Nil$ lst = Nil$.MODULE$;
        while (rs.next()) {
            T t = this.row2obj(clazz, showCols, rs);
            lst = lst.$colon$colon(t);
        }
        return lst.reverse();
    }

    public <T extends Record<K>, K> T row2obj(Class<T> clazz, Set<String> showCols, ResultSet rs) {
        Record obj = (Record)clazz.getDeclaredConstructor((Class[])((TraversableOnce)Seq$.MODULE$.empty()).toArray(ClassTag$.MODULE$.apply(Class.class))).newInstance(new Object[0]);
        this.getColumnFields(clazz, showCols).foreach((Function1 & Serializable & scala.Serializable)fld -> {
            ORMUtil$.$anonfun$row2obj$1(rs, obj, fld);
            return BoxedUnit.UNIT;
        });
        return (T)obj;
    }

    public <T extends Record<K>, K> Seq<Tuple2<String, Object>> obj2kv(Class<T> clazz, T obj, Set<String> showCols) {
        return (Seq)this.getColumnFields(clazz, showCols).map((Function1 & Serializable & scala.Serializable)f -> {
            Column clm = f.getAnnotation(Column.class);
            String colName = StringUtils.isBlank((String)clm.column()) ? f.getName() : clm.column();
            f.setAccessible(true);
            return new Tuple2((Object)colName, f.get(obj));
        }, Seq$.MODULE$.canBuildFrom());
    }

    public <T extends Record<K>, K> Seq<String> getColumns(Class<?> clazz, Set<String> showCols) {
        return (Seq)this.getColumnFields(clazz, showCols).map((Function1 & Serializable & scala.Serializable)f -> {
            Column clm = f.getAnnotation(Column.class);
            String colName = StringUtils.isBlank((String)clm.column()) ? f.getName() : clm.column();
            return new StringOps(Predef$.MODULE$.augmentString("%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{colName}));
        }, Seq$.MODULE$.canBuildFrom());
    }

    public <T extends Record<K>, K> Seq<Field> getColumnFields(Class<?> clazz, Set<String> showCols) {
        return this.loop$1(clazz, (Seq)Nil$.MODULE$, showCols);
    }

    public <T extends Record<K>, K> Try<String> getTableName(Class<T> clazz, Dialect dialect) {
        Failure failure;
        Table tbl = clazz.getAnnotation(Table.class);
        if (tbl == null) {
            failure = new Failure((Throwable)new RuntimeException("Not Db Entry"));
        } else {
            String database = StringUtils.isBlank((String)tbl.database()) ? "" : tbl.database();
            String table = StringUtils.isBlank((String)tbl.table()) ? clazz.getName() : tbl.table();
            failure = new Success((Object)dialect.sqlTableName(database, table));
        }
        return failure;
    }

    public Regex paramRegex() {
        return this.paramRegex;
    }

    public Seq<Object> parseValues(String query, Map<String, Object> params) {
        return this.paramRegex().findAllMatchIn((CharSequence)query).map((Function1 & Serializable & scala.Serializable)m -> m.group(1)).toSeq();
    }

    public String parseQuery(String query) {
        return this.paramRegex().replaceAllIn((CharSequence)query, "?");
    }

    public void setValueInField(Field field, Object obj, Object value) {
        Class<java.util.Date> fieldType;
        field.setAccessible(true);
        Class<java.util.Date> clazz = fieldType = field.getType();
        if (clazz.isAssignableFrom(java.util.Date.class)) {
            Object object = value;
            if (object instanceof Long) {
                Long l = (Long)object;
                field.set(obj, new java.util.Date(Predef$.MODULE$.Long2long(l)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)object;
                field.set(obj, date);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                field.set(obj, object);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            field.set(obj, value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public PreparedStatement setQueryValues(PreparedStatement ps, Seq<Object> values) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), values.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)n -> {
            Object object = values.apply(n - 1);
            if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                ps.setByte(n, by);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                ps.setShort(n, s);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Integer) {
                int n2 = BoxesRunTime.unboxToInt((Object)object);
                ps.setInt(n, n2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                ps.setLong(n, l);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                ps.setFloat(n, f);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                ps.setDouble(n, d);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                ps.setBigDecimal(n, bigDecimal.bigDecimal());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Byte) {
                Byte by = (Byte)object;
                ps.setByte(n, Predef$.MODULE$.Byte2byte(by));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Short) {
                Short s = (Short)object;
                ps.setShort(n, Predef$.MODULE$.Short2short(s));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Integer) {
                Integer n3 = (Integer)object;
                ps.setInt(n, Predef$.MODULE$.Integer2int(n3));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Long) {
                Long l = (Long)object;
                ps.setLong(n, Predef$.MODULE$.Long2long(l));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Float) {
                Float f = (Float)object;
                ps.setFloat(n, Predef$.MODULE$.Float2float(f));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Double) {
                Double d = (Double)object;
                ps.setDouble(n, Predef$.MODULE$.Double2double(d));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof java.math.BigDecimal) {
                java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
                ps.setBigDecimal(n, bigDecimal);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof String) {
                String string = (String)object;
                ps.setString(n, string);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)object;
                ps.setDate(n, new Date(date.getTime()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                ps.setObject(n, null);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        });
        return ps;
    }

    public static final /* synthetic */ String $anonfun$row2map$1(ResultSet rs$1, int c) {
        return rs$1.getMetaData().getColumnName(c);
    }

    public static final /* synthetic */ void $anonfun$row2obj$1(ResultSet rs$2, Record obj$1, Field fld) {
        Column clm = fld.getAnnotation(Column.class);
        String fldName = fld.getName();
        String colName = StringUtils.isBlank((String)clm.column()) ? fldName : clm.column();
        try {
            Object colValue = rs$2.getObject(colName);
            MODULE$.setValueInField(fld, obj$1, colValue);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final /* synthetic */ void $anonfun$getColumnFields$1(Set showCols$2, ObjectRef newFlds$1, Field fld) {
        Column clm = fld.getAnnotation(Column.class);
        if (clm != null) {
            String colName;
            String fldName = fld.getName();
            String string = colName = StringUtils.isBlank((String)clm.column()) ? fldName : clm.column();
            if (showCols$2 == null || showCols$2.isEmpty() || showCols$2.contains((Object)colName) || showCols$2.contains((Object)fld.getName())) {
                Field field = fld;
                newFlds$1.elem = ((List)newFlds$1.elem).$colon$colon((Object)field);
            }
        }
    }

    private final Seq loop$1(Class clazz, Seq oldFlds, Set showCols) {
        Seq allFlds;
        while (true) {
            ObjectRef newFlds = ObjectRef.create((Object)Nil$.MODULE$);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)fld -> {
                ORMUtil$.$anonfun$getColumnFields$1(showCols, newFlds, fld);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Seq seq = ((List)newFlds.elem).toSeq();
            allFlds = (Seq)oldFlds.$plus$plus$colon((Traversable)seq, Seq$.MODULE$.canBuildFrom());
            Class superClass = clazz.getSuperclass();
            if (superClass == null) break;
            oldFlds = allFlds;
            clazz = superClass;
        }
        return allFlds;
    }

    private ORMUtil$() {
        MODULE$ = this;
        this.paramRegex = new StringOps(Predef$.MODULE$.augmentString(":([-_0-9a-zA-Z]+)")).r();
    }
}

