/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.comm.dao;

import jadeutils.comm.dao.DaoSession;
import jadeutils.common.Logging;
import jadeutils.common.Logging$class;
import java.sql.Connection;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Stack;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4Q!\u0001\u0002\u0002\u0002%\u0011\u0011\u0003R1p'\u0016\u001c8/[8o\r\u0006\u001cGo\u001c:z\u0015\t\u0019A!A\u0002eC>T!!\u0002\u0004\u0002\t\r|W.\u001c\u0006\u0002\u000f\u0005I!.\u00193fkRLGn]\u0002\u0001'\r\u0001!\u0002\u0005\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E!R\"\u0001\n\u000b\u0005M1\u0011AB2p[6|g.\u0003\u0002\u0016%\t9Aj\\4hS:<\u0007\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\r\u0002\u00175Lg\u000eU8pYNK'0Z\u000b\u00023A\u00111BG\u0005\u000371\u00111!\u00138u\u0011!i\u0002A!A!\u0002\u0013I\u0012\u0001D7j]B{w\u000e\\*ju\u0016\u0004\u0003\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\u0001\r\u0002\u00175\f\u0007\u0010U8pYNK'0\u001a\u0005\tC\u0001\u0011\t\u0011)A\u00053\u0005aQ.\u0019=Q_>d7+\u001b>fA!A1\u0005\u0001BC\u0002\u0013\u0005\u0001$\u0001\u0007j]&$\bk\\8m'&TX\r\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003\u001a\u00035Ig.\u001b;Q_>d7+\u001b>fA!)q\u0005\u0001C\u0001Q\u00051A(\u001b8jiz\"B!K\u0016-[A\u0011!\u0006A\u0007\u0002\u0005!)qC\na\u00013!)qD\na\u00013!)1E\na\u00013!9q\u0006\u0001b\u0001\u000e\u0003A\u0012\u0001\u00053fM\u0006,H\u000e^%t_2\fG/[8o\u0011\u0019\t\u0004\u0001)A\u0005e\u0005A\u0011\u000e\u001a7f'\u0016\u001c8\u000fE\u00024qij\u0011\u0001\u000e\u0006\u0003kY\nq!\\;uC\ndWM\u0003\u00028\u0019\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005e\"$!B*uC\u000e\\\u0007C\u0001\u0016<\u0013\ta$A\u0001\u0006EC>\u001cVm]:j_:DaA\u0010\u0001!\u0002\u0013y\u0014\u0001C1diN+7o]:\u0011\tM\u0002%IO\u0005\u0003\u0003R\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002D\r:\u00111\u0002R\u0005\u0003\u000b2\ta\u0001\u0015:fI\u00164\u0017BA$I\u0005\u0019\u0019FO]5oO*\u0011Q\t\u0004\u0005\u0007\u0015\u0002\u0001K\u0011B&\u0002\tML'0\u001a\u000b\u00023!1Q\n\u0001Q!\n9\u000b1bY;seN+7o]5p]B\u0019q\n\u0016\u001e\u000e\u0003AS!!\u0015*\u0002\t1\fgn\u001a\u0006\u0002'\u0006!!.\u0019<b\u0013\t)\u0006KA\u0006UQJ,\u0017\r\u001a'pG\u0006d\u0007\"B\u0014\u0001\t\u00039F#A\u0015\t\u000be\u0003a\u0011\u0001.\u0002!\r\u0014X-\u0019;f\u0007>tg.Z2uS>tG#A.\u0011\u0005q{V\"A/\u000b\u0005y\u0013\u0016aA:rY&\u0011\u0001-\u0018\u0002\u000b\u0007>tg.Z2uS>t\u0007\"\u00022\u0001\t\u0003\u0019\u0017AD2veJ,g\u000e^*fgNLwN\\\u000b\u0002u!)Q\r\u0001C\u0001M\u0006i1M]3bi\u0016\u001cVm]:j_:$\u0012A\u000f\u0005\u0007Q\u0002\u0001K\u0011\u00024\u0002\u00179,\u0007\u0010^*fgNLwN\u001c\u0005\u0006U\u0002!\ta[\u0001\rG2|7/Z*fgNLwN\u001c\u000b\u0003Y>\u0004\"aC7\n\u00059d!\u0001B+oSRDQ\u0001]5A\u0002i\nAa]3tg\u0002")
public abstract class DaoSessionFactory
implements Logging {
    private final int minPoolSize;
    private final int maxPoolSize;
    private final int initPoolSize;
    private final Stack<DaoSession> idleSess;
    private final HashMap<String, DaoSession> actSesss;
    private ThreadLocal<DaoSession> currSession;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        DaoSessionFactory daoSessionFactory = this;
        synchronized (daoSessionFactory) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Logger getLoggerByName(String name) {
        return Logging$class.getLoggerByName(this, name);
    }

    @Override
    public void logTrace(String msg, Seq<Object> refs) {
        Logging$class.logTrace(this, msg, refs);
    }

    @Override
    public void logDebug(String msg, Seq<Object> refs) {
        Logging$class.logDebug(this, msg, refs);
    }

    @Override
    public void logInfo(String msg, Seq<Object> refs) {
        Logging$class.logInfo(this, msg, refs);
    }

    @Override
    public void logWarn(String msg, Seq<Object> refs) {
        Logging$class.logWarn(this, msg, refs);
    }

    @Override
    public void logError(String msg, Seq<Object> refs) {
        Logging$class.logError(this, msg, refs);
    }

    public int minPoolSize() {
        return this.minPoolSize;
    }

    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    public int initPoolSize() {
        return this.initPoolSize;
    }

    public abstract int defaultIsolation();

    private int size() {
        return this.idleSess.size() + this.actSesss.size();
    }

    public abstract Connection createConnection();

    public DaoSession currentSession() {
        DaoSession daoSession;
        if (this.currSession.get() == null || this.currSession.get().isBroken()) {
            if (this.currSession.get() != null) {
                this.currSession.get().close();
            }
            daoSession = this.createSession();
        } else {
            daoSession = this.currSession.get();
        }
        return daoSession;
    }

    /*
     * WARNING - void declaration
     */
    public DaoSession createSession() {
        void var1_1;
        if (this.size() >= this.maxPoolSize()) {
            throw new RuntimeException("Db connection Pool filled");
        }
        DaoSession sess = this.nextSession();
        this.actSesss.put((Object)sess.id(), (Object)sess);
        this.currSession.set(sess);
        this.logTrace("after create session: size: {} ----- max: {}\nidle: {}\nactive: {}", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.size()), BoxesRunTime.boxToInteger((int)this.maxPoolSize()), this.idleSess, this.actSesss}));
        return var1_1;
    }

    private DaoSession nextSession() {
        DaoSession sess;
        while ((sess = this.idleSess.size() < 1 ? new DaoSession(String.valueOf(BoxesRunTime.boxToInteger((int)this.size())), this.createConnection(), this) : (DaoSession)this.idleSess.pop()).isBroken()) {
        }
        return sess;
    }

    public void closeSession(DaoSession sess) {
        BoxedUnit boxedUnit;
        if (this.actSesss.contains((Object)sess.id())) {
            this.actSesss.remove((Object)sess.id());
            boxedUnit = this.idleSess.push((Object)sess);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.logTrace("after close session: size: {} ----- max: {}\nidle: {}\nactive: {}", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.size()), BoxesRunTime.boxToInteger((int)this.maxPoolSize()), this.idleSess, this.actSesss}));
    }

    public DaoSessionFactory(int minPoolSize, int maxPoolSize, int initPoolSize) {
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.initPoolSize = initPoolSize;
        Logging$class.$init$(this);
        this.idleSess = new Stack();
        this.actSesss = new HashMap();
        this.currSession = new ThreadLocal();
    }

    public DaoSessionFactory() {
        this(3, 10, 5);
    }
}

