/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.web.har;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import jadeutils.web.har.HarCookie;
import jadeutils.web.har.HarEntry;
import jadeutils.web.har.HarFactory;
import jadeutils.web.har.HarHTTPMethod;
import jadeutils.web.har.HarPostData;
import jadeutils.web.har.HarPostDataParam;
import jadeutils.web.har.HarRequest;
import jadeutils.web.har.HarResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HarFactoryJsonImpl
implements HarFactory<JSONObject, JSONArray> {
    @Override
    public Map<String, String> genHeaders(JSONArray jArr) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (int i = 0; i < jArr.size(); ++i) {
            JSONObject jo = jArr.getJSONObject(i);
            String name = (String)JSONPath.eval((Object)jo, (String)"$.name");
            String value = (String)JSONPath.eval((Object)jo, (String)"$.value");
            if (null == name || null == value) continue;
            headers.put(name, value);
        }
        return headers;
    }

    @Override
    public List<HarCookie> genCookies(JSONArray ckArr) {
        ArrayList<HarCookie> cookies = new ArrayList<HarCookie>();
        for (int i = 0; i < ckArr.size(); ++i) {
            JSONObject jo = ckArr.getJSONObject(i);
            String name = (String)JSONPath.eval((Object)jo, (String)"$.name");
            String value = (String)JSONPath.eval((Object)jo, (String)"$.value");
            String path = (String)JSONPath.eval((Object)jo, (String)"$.path");
            String domain = (String)JSONPath.eval((Object)jo, (String)"$.domain");
            String expries = (String)JSONPath.eval((Object)jo, (String)"$.expries");
            boolean httpOnly = (Boolean)JSONPath.eval((Object)jo, (String)"$.httpOnly");
            boolean secure = (Boolean)JSONPath.eval((Object)jo, (String)"$.secure");
            String comment = (String)JSONPath.eval((Object)jo, (String)"$.comment");
            if (null == name || null == value) continue;
            HarCookie cookie = new HarCookie(name, value, path, domain, expries, httpOnly, secure, comment);
            cookies.add(cookie);
        }
        return cookies;
    }

    @Override
    public List<String[]> genQueryString(JSONArray qsArr) {
        ArrayList<String[]> queryString = new ArrayList<String[]>();
        for (int i = 0; i < qsArr.size(); ++i) {
            JSONObject jo = qsArr.getJSONObject(i);
            String name = (String)JSONPath.eval((Object)jo, (String)"$.name");
            String value = (String)JSONPath.eval((Object)jo, (String)"$.value");
            if (null == name || null == value) continue;
            String[] query = new String[]{name, value};
            queryString.add(query);
        }
        return queryString;
    }

    @Override
    public HarPostData genPostData(JSONObject pdJo) {
        HarPostData result = null;
        if (null != pdJo) {
            String mimeType = (String)JSONPath.eval((Object)pdJo, (String)"$.mimeType");
            String text = (String)JSONPath.eval((Object)pdJo, (String)"$.text");
            ArrayList<HarPostDataParam> params = new ArrayList<HarPostDataParam>();
            result = new HarPostData(mimeType, text, params);
        }
        return result;
    }

    @Override
    public HarRequest genRequest(JSONObject reqJo) {
        HarRequest request = null;
        if (null != reqJo) {
            String method = (String)JSONPath.eval((Object)reqJo, (String)"$.method");
            String url = (String)JSONPath.eval((Object)reqJo, (String)"$.url");
            List<String[]> queryString = this.genQueryString((JSONArray)JSONPath.eval((Object)reqJo, (String)"$.queryString"));
            Map<String, String> headers = this.genHeaders((JSONArray)JSONPath.eval((Object)reqJo, (String)"$.headers"));
            List<HarCookie> cookies = this.genCookies((JSONArray)JSONPath.eval((Object)reqJo, (String)"$.cookies"));
            HarPostData postData = this.genPostData((JSONObject)JSONPath.eval((Object)reqJo, (String)"$.postData"));
            if (null != method && null != url) {
                request = new HarRequest(HarHTTPMethod.valueOf(method.toUpperCase()), url, headers, cookies, queryString, postData);
            }
        }
        return request;
    }

    @Override
    public HarResponse genResponse(JSONObject rspJo) {
        HarResponse response = null;
        if (null != rspJo) {
            response = new HarResponse();
        }
        return response;
    }

    @Override
    public List<HarEntry> genEntries(JSONArray entArr) {
        ArrayList<HarEntry> entries = new ArrayList<HarEntry>();
        for (int i = 0; i < entArr.size(); ++i) {
            JSONObject jo = entArr.getJSONObject(i);
            HarRequest request = this.genRequest((JSONObject)JSONPath.eval((Object)jo, (String)"$.request"));
            HarResponse response = this.genResponse((JSONObject)JSONPath.eval((Object)jo, (String)"$.response"));
            HarEntry entry = new HarEntry(request, response);
            entries.add(entry);
        }
        return entries;
    }
}

