/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.net.http;

import jadeutils.encryption.ByteArrayQueue;
import jadeutils.encryption.Numbers;
import jadeutils.encryption.Streams;
import jadeutils.net.http.HttpParam;
import jadeutils.net.http.HttpProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.http.conn.DnsResolver;

public class HttpUtil {
    private static final int RESP_MAX_SIZE = 65536;
    private static final String HEX_DIGITS = "0123456789ABCDEF";
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] COLON = new byte[]{58, 32};
    private static final byte[] GET = "GET ".getBytes();
    private static final byte[] HEAD = "HEAD ".getBytes();
    private static final byte[] POST = "POST ".getBytes();
    private static final byte[] HTTP11 = " HTTP/1.1\r\n".getBytes();
    private static final byte[] HOST = "Host: ".getBytes();
    private static final byte[] PROXY_AUTH = "Proxy-Authorization: ".getBytes();
    private static final byte[] CONTENT_LENGTH = "Content-Length: ".getBytes();
    private static final byte[] HEAD_END = "Accept-Encoding: gzip\r\nConnection: Keep-Alive\r\n\r\n".getBytes();

    private static void copyResponse(InputStream in, ByteArrayQueue baq, byte[] buffer, int length) throws IOException {
        int bytesRead;
        for (int bytesToRead = length; bytesToRead > 0; bytesToRead -= bytesRead) {
            bytesRead = in.read(buffer, 0, Math.min(65536, bytesToRead));
            if (bytesRead < 0) {
                throw new IOException("Connection Lost");
            }
            if (bytesRead != 0) continue;
            throw new IOException("Zero Bytes Read");
        }
    }

    static void send(OutputStream out, String path, String host, String proxyAuth, ByteArrayQueue requestBody, Map<String, List<String>> requestHeaders, boolean head) throws IOException {
        ByteArrayQueue headerBaq = new ByteArrayQueue();
        if (requestBody == null) {
            headerBaq.add(head ? HEAD : GET).add(path.getBytes()).add(HTTP11);
        } else {
            String length = "" + requestBody.length();
            headerBaq.add(POST).add(path.getBytes()).add(HTTP11).add(CONTENT_LENGTH).add(length.getBytes()).add(CRLF);
        }
        headerBaq.add(HOST).add(host.getBytes()).add(CRLF);
        if (proxyAuth != null) {
            headerBaq.add(PROXY_AUTH).add(proxyAuth.getBytes()).add(CRLF);
        }
        if (requestHeaders != null) {
            for (Map.Entry<String, List<String>> entry : requestHeaders.entrySet()) {
                byte[] key = entry.getKey().getBytes();
                for (String value : entry.getValue()) {
                    headerBaq.add(key).add(COLON).add(value.getBytes()).add(CRLF);
                }
            }
        }
        headerBaq.add(HEAD_END);
        Streams.copy((InputStream)headerBaq.getInputStream(), (OutputStream)out);
        if (requestBody != null) {
            Streams.copy((InputStream)requestBody.getInputStream(), (OutputStream)out);
        }
    }

    public static int recv(InputStream in, ByteArrayQueue responseBody, Map<String, List<String>> responseHeaders, boolean head, boolean[] connectionClose) throws IOException {
        ByteArrayQueue gzipBody;
        Object value;
        boolean gzip = false;
        boolean close = false;
        int status = 0;
        int contentLength = 0;
        StringBuilder sb = new StringBuilder();
        while (true) {
            int index;
            int b;
            if ((b = in.read()) < 0) {
                throw new IOException("Connection Lost");
            }
            if (b == 13) continue;
            if (b != 10) {
                sb.append((char)b);
                continue;
            }
            if (sb.length() == 0) {
                if (status != 100) break;
                status = 0;
                continue;
            }
            if (status == 0) {
                String[] ss = sb.toString().split(" ");
                if (ss.length < 2) {
                    throw new IOException("Response Error: [" + sb + "]");
                }
                status = Numbers.parseInt((String)ss[1]);
            } else if (status != 100 && (index = sb.indexOf(": ")) >= 0) {
                String key = sb.substring(0, index).toUpperCase();
                value = sb.substring(index + 2);
                switch (key) {
                    case "CONNECTION": {
                        if (!((String)value).equalsIgnoreCase("close")) break;
                        close = true;
                        break;
                    }
                    case "CONTENT-LENGTH": {
                        contentLength = Numbers.parseInt((String)value);
                        break;
                    }
                    case "CONTENT-ENCODING": {
                        if (!((String)value).equalsIgnoreCase("gzip")) break;
                        gzip = true;
                        break;
                    }
                    case "TRANSFER-ENCODING": {
                        if (!((String)value).equalsIgnoreCase("chunked")) break;
                        contentLength = -1;
                    }
                }
                if (responseHeaders != null) {
                    List<String> values = responseHeaders.get(key);
                    if (values == null) {
                        values = new ArrayList<String>();
                        responseHeaders.put(key, values);
                    }
                    values.add((String)value);
                }
            }
            sb.setLength(0);
        }
        if (connectionClose != null && connectionClose.length > 0) {
            connectionClose[0] = close;
        }
        if (head || contentLength == 0) {
            return status;
        }
        byte[] buffer = new byte[65536];
        if (contentLength > 0) {
            if (gzip) {
                ByteArrayQueue gzipBody2 = new ByteArrayQueue();
                HttpUtil.copyResponse(in, gzipBody2, buffer, contentLength);
                if (responseBody != null) {
                    try {
                        GZIPInputStream gzipis = new GZIPInputStream(gzipBody2.getInputStream());
                        value = null;
                        try {
                            Streams.copy((InputStream)gzipis, (OutputStream)responseBody.getOutputStream());
                        }
                        catch (Throwable throwable) {
                            value = throwable;
                            throw throwable;
                        }
                        finally {
                            if (gzipis != null) {
                                if (value != null) {
                                    try {
                                        gzipis.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)value).addSuppressed(throwable);
                                    }
                                } else {
                                    gzipis.close();
                                }
                            }
                        }
                    }
                    catch (IOException gzipis) {}
                }
            } else {
                HttpUtil.copyResponse(in, responseBody, buffer, contentLength);
            }
            return status;
        }
        int chunkSize = 0;
        ByteArrayQueue byteArrayQueue = gzipBody = gzip ? new ByteArrayQueue() : responseBody;
        while (true) {
            int b;
            if ((b = in.read()) < 0) {
                throw new IOException("Connection Lost");
            }
            if (chunkSize < 0) {
                if (b != 10) continue;
                if (chunkSize == -2) break;
                chunkSize = 0;
                continue;
            }
            if (b == 10) {
                if (chunkSize == 0) {
                    chunkSize = -2;
                    continue;
                }
                HttpUtil.copyResponse(in, gzipBody, buffer, chunkSize);
                chunkSize = -1;
                continue;
            }
            if ((b = HEX_DIGITS.indexOf(Character.toUpperCase(b))) < 0) continue;
            chunkSize = chunkSize * 16 + b;
        }
        if (gzip && responseBody != null) {
            try {
                GZIPInputStream gzipis = new GZIPInputStream(gzipBody.getInputStream());
                Object object = null;
                try {
                    Streams.copy((InputStream)gzipis, (OutputStream)responseBody.getOutputStream());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (gzipis != null) {
                        if (object != null) {
                            try {
                                gzipis.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            gzipis.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return status;
    }

    static int request(Socket socket, String path, String host, String proxyAuth, ByteArrayQueue requestBody, Map<String, List<String>> requestHeaders, boolean head, ByteArrayQueue responseBody, Map<String, List<String>> responseHeaders, boolean[] connectionClose) throws IOException {
        HttpUtil.send(socket.getOutputStream(), path, host, proxyAuth, requestBody, requestHeaders, head);
        return HttpUtil.recv(socket.getInputStream(), responseBody, responseHeaders, head, connectionClose);
    }

    private static int request(HttpProxy httpProxy, DnsResolver resolver, String href, ByteArrayQueue requestBody, Map<String, List<String>> requestHeaders, boolean head, ByteArrayQueue responseBody, Map<String, List<String>> responseHeaders, int timeout) throws IOException {
        URL url = new URL(href);
        InetAddress address = resolver.resolve(url.getHost())[0];
        HttpParam param = new HttpParam(httpProxy, url, address);
        try (Socket socket = param.socketFactory.createSocket();){
            socket.setSoTimeout(timeout);
            socket.connect(param.socketAddress);
            int n = HttpUtil.request(socket, param.path, param.host, param.proxyAuth, requestBody, requestHeaders, head, responseBody, responseHeaders, null);
            return n;
        }
    }

    public static int head(DnsResolver resolver, String url, Map<String, List<String>> requestHeaders, Map<String, List<String>> responseHeaders, int timeout) throws IOException {
        return HttpUtil.head(null, resolver, url, requestHeaders, responseHeaders, timeout);
    }

    public static int get(DnsResolver resolver, String url, Map<String, List<String>> requestHeaders, ByteArrayQueue responseBody, Map<String, List<String>> responseHeaders, int timeout) throws IOException {
        return HttpUtil.get(null, resolver, url, requestHeaders, responseBody, responseHeaders, timeout);
    }

    public static int post(DnsResolver resolver, String url, ByteArrayQueue requestBody, Map<String, List<String>> requestHeaders, ByteArrayQueue responseBody, Map<String, List<String>> responseHeaders, int timeout) throws IOException {
        return HttpUtil.post(null, resolver, url, requestBody, requestHeaders, responseBody, responseHeaders, timeout);
    }

    public static int head(HttpProxy httpProxy, DnsResolver resolver, String url, Map<String, List<String>> requestHeaders, Map<String, List<String>> responseHeaders, int timeout) throws IOException {
        return HttpUtil.request(httpProxy, resolver, url, null, requestHeaders, true, null, responseHeaders, timeout);
    }

    public static int get(HttpProxy httpProxy, DnsResolver resolver, String url, Map<String, List<String>> requestHeaders, ByteArrayQueue responseBody, Map<String, List<String>> responseHeaders, int timeout) throws IOException {
        return HttpUtil.request(httpProxy, resolver, url, null, requestHeaders, false, responseBody, responseHeaders, timeout);
    }

    public static int post(HttpProxy httpProxy, DnsResolver resolver, String url, ByteArrayQueue requestBody, Map<String, List<String>> requestHeaders, ByteArrayQueue responseBody, Map<String, List<String>> responseHeaders, int timeout) throws IOException {
        return HttpUtil.request(httpProxy, resolver, url, requestBody, requestHeaders, false, responseBody, responseHeaders, timeout);
    }
}

