/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.net.http;

import jadeutils.encryption.ByteArrayQueue;
import jadeutils.net.SocketPool;
import jadeutils.net.http.HttpParam;
import jadeutils.net.http.HttpProxy;
import jadeutils.net.http.HttpUtil;
import jadeutils.net.http.Pipeline;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class HttpPool
extends SocketPool {
    private String path_;
    private String host;
    private String proxyAuth;

    private HttpPool(HttpParam param, int timeout) {
        super(param.socketFactory, param.socketAddress, timeout);
        this.path_ = param.path;
        this.host = param.host;
        this.proxyAuth = param.proxyAuth;
    }

    public HttpPool(URL url, int timeout) {
        this(null, url, timeout);
    }

    public HttpPool(HttpProxy httpProxy, URL url, int timeout) {
        this(new HttpParam(httpProxy, url, null), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int request(String path, ByteArrayQueue requestBody, Map<String, List<String>> requestHeaders, boolean head, ByteArrayQueue responseBody, Map<String, List<String>> responseHeaders) throws IOException {
        try (Socket socket = (Socket)this.borrowObject();){
            boolean[] connectionClose = new boolean[]{false};
            int status = HttpUtil.request(socket, this.path_ + path, this.host, this.proxyAuth, requestBody, requestHeaders, head, responseBody, responseHeaders, connectionClose);
            if (connectionClose[0]) {
                socket.close();
            } else {
                this.returnObject(socket);
            }
            socket = null;
            int n = status;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestWithOutResponse(String path, ByteArrayQueue requestBody, Map<String, List<String>> requestHeaders, boolean head) throws IOException {
        try (Socket socket = (Socket)this.borrowObject();){
            HttpUtil.send(socket.getOutputStream(), this.path_ + path, this.host, this.proxyAuth, requestBody, requestHeaders, head);
            this.returnObject(socket);
        }
    }

    public int head(String path, Map<String, List<String>> requestHeaders, Map<String, List<String>> responseHeaders) throws IOException {
        return this.request(path, null, requestHeaders, true, null, responseHeaders);
    }

    public int get(String path, Map<String, List<String>> requestHeaders, ByteArrayQueue responseBody, Map<String, List<String>> responseHeaders) throws IOException {
        return this.request(path, null, requestHeaders, false, responseBody, responseHeaders);
    }

    public int post(String path, ByteArrayQueue requestBody, Map<String, List<String>> requestHeaders, ByteArrayQueue responseBody, Map<String, List<String>> responseHeaders) throws IOException {
        return this.request(path, requestBody, requestHeaders, false, responseBody, responseHeaders);
    }

    public void postWithOutResponse(String path, ByteArrayQueue requestBody, Map<String, List<String>> requestHeaders) throws IOException {
        this.requestWithOutResponse(path, requestBody, requestHeaders, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pipeline(List<Pipeline.Request> requests, List<Pipeline.Response> responses) throws IOException {
        try (Socket socket = (Socket)this.borrowObject();){
            boolean[] connectionClose = new boolean[]{false};
            Pipeline.pipeline(socket, this.host, requests, responses, connectionClose);
            if (connectionClose[0]) {
                socket.close();
            } else {
                this.returnObject(socket);
            }
            socket = null;
        }
    }
}

