/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.net.http;

import jadeutils.net.SocketPool;
import jadeutils.net.http.HttpProxy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Base64;
import javax.net.SocketFactory;

public class HttpParam {
    SocketFactory socketFactory;
    SocketAddress socketAddress;
    String path;
    String host;
    String proxyAuth;

    HttpParam(HttpProxy httpProxy, URL url, InetAddress address) {
        if (httpProxy == null) {
            try {
                int port = url.getPort();
                String query = url.getQuery();
                this.socketFactory = SocketPool.getSocketFactory(url.getProtocol().equals("https"));
                this.socketAddress = new InetSocketAddress(address, port == -1 ? url.getDefaultPort() : port);
                this.path = url.getPath() + (query == null ? "" : "?" + query);
                this.host = url.getHost() + (port == -1 ? "" : ":" + port);
            }
            catch (Exception e) {
                this.socketFactory = SocketPool.getSocketFactory(false);
                this.socketAddress = new InetSocketAddress("localhost", 80);
                this.path = "/";
                this.host = "localhost";
            }
            this.proxyAuth = null;
        } else {
            this.socketFactory = SocketPool.getSocketFactory(false);
            this.socketAddress = httpProxy.getSocketAddress();
            this.path = url.getRef();
            try {
                int port = url.getPort();
                this.host = url.getHost() + (port == -1 ? "" : ":" + port);
            }
            catch (Exception e) {
                this.host = "localhost";
            }
            String username = httpProxy.getUsername();
            if (username == null) {
                this.proxyAuth = null;
            } else {
                String password = httpProxy.getPassword();
                this.proxyAuth = "Basic " + Base64.getEncoder().encodeToString((username + ":" + (password == null ? "" : password)).getBytes());
            }
        }
    }
}

