/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.net.email;

import jadeutils.net.email.MailAttachmentHandler;
import jadeutils.net.email.MailBodyHandler;
import jadeutils.net.email.MailFolderHandler;
import jadeutils.text.HtmlUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailUtil {
    public static final String MAIL_TYPE_TEXT_PAIN = "text/*";
    public static final String MAIL_TYPE_TEXT_HTML = "text/html";
    public static final String MAIL_TYPE_MSG_RFC822 = "message/rfc822";

    public static void sendTextMail(Properties emailProps, final String email, final String password, String[] toArr, String[] ccArr, String[] bccArr, String subject, String text) throws Exception {
        Session smtpSession = Session.getInstance((Properties)emailProps, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(email, password);
            }
        });
        try {
            MimeMessage msg = null;
            msg = new MimeMessage(smtpSession);
            msg.setFrom((Address)new InternetAddress(email));
            for (String to : toArr) {
                msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            }
            for (String cc : ccArr) {
                msg.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc));
            }
            for (String bcc : bccArr) {
                msg.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
            }
            msg.setSubject(subject);
            msg.setText(text);
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            throw new Exception(e.getMessage());
        }
    }

    public static void sendTextMail(Properties emailProps, final String email, final String password, String[] toArr, String[] ccArr, String[] bccArr, String subject, String text, Map<String, DataSource> attachments) throws Exception {
        Session smtpSession = Session.getInstance((Properties)emailProps, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(email, password);
            }
        });
        try {
            MimeMessage msg = null;
            msg = new MimeMessage(smtpSession);
            msg.setFrom((Address)new InternetAddress(email));
            for (String to : toArr) {
                msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            }
            for (String cc : ccArr) {
                msg.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc));
            }
            for (String bcc : bccArr) {
                msg.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
            }
            msg.setSubject(subject);
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart part0 = new MimeBodyPart();
            part0.setContent((Object)text, "text/plain;charset=UTF-8");
            multipart.addBodyPart((BodyPart)part0);
            if (null != attachments) {
                for (Map.Entry<String, DataSource> ath : attachments.entrySet()) {
                    MimeBodyPart pat = new MimeBodyPart();
                    pat.setDataHandler(new DataHandler(ath.getValue()));
                    pat.setFileName(ath.getKey());
                    multipart.addBodyPart((BodyPart)pat);
                }
                multipart.setSubType("mixed");
            }
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            throw new Exception(e.getMessage());
        }
    }

    public static void sendHtmlMail(Properties emailProps, final String email, final String password, String[] toArr, String[] ccArr, String[] bccArr, String subject, String html, Map<String, DataSource> related, Map<String, DataSource> attachments) throws Exception {
        Session smtpSession = Session.getInstance((Properties)emailProps, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(email, password);
            }
        });
        try {
            MimeMessage msg = null;
            msg = new MimeMessage(smtpSession);
            msg.setFrom((Address)new InternetAddress(email));
            for (String to : toArr) {
                msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            }
            for (String cc : ccArr) {
                msg.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc));
            }
            for (String bcc : bccArr) {
                msg.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
            }
            msg.setSubject(subject);
            MimeMultipart pageMulti = new MimeMultipart();
            MimeBodyPart pageBody = new MimeBodyPart();
            pageBody.setContent((Object)html, "text/html;charset=UTF-8");
            pageMulti.addBodyPart((BodyPart)pageBody);
            if (null != related) {
                for (Map.Entry<String, DataSource> ath : related.entrySet()) {
                    MimeBodyPart pat = new MimeBodyPart();
                    pat.setDataHandler(new DataHandler(ath.getValue()));
                    pat.setContentID(ath.getKey());
                    pageMulti.addBodyPart((BodyPart)pat);
                }
                pageMulti.setSubType("related");
            }
            MimeBodyPart contentBody = new MimeBodyPart();
            contentBody.setContent((Multipart)pageMulti);
            MimeMultipart contentMulti = new MimeMultipart();
            contentMulti.addBodyPart((BodyPart)contentBody);
            if (null != attachments) {
                for (Map.Entry entry : attachments.entrySet()) {
                    MimeBodyPart pat = new MimeBodyPart();
                    pat.setDataHandler(new DataHandler((DataSource)entry.getValue()));
                    pat.setFileName((String)entry.getKey());
                    contentMulti.addBodyPart((BodyPart)pat);
                }
                contentMulti.setSubType("mixed");
            }
            MimeBodyPart mmBody = new MimeBodyPart();
            mmBody.setContent((Multipart)contentMulti);
            MimeMultipart mimeMultipart = new MimeMultipart();
            mimeMultipart.addBodyPart((BodyPart)mmBody);
            MimeBodyPart textBody = new MimeBodyPart();
            String text = HtmlUtil.html2text((String)html);
            textBody.setContent((Object)text, "text/plain;charset=UTF-8");
            mimeMultipart.addBodyPart((BodyPart)textBody);
            msg.setContent((Multipart)mimeMultipart);
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            throw new Exception(e.getMessage());
        }
    }

    public static void receiveMail(Properties emailProps, String email, String password, boolean isReadOnly, MailFolderHandler folderHandler, MailBodyHandler bodyHandler, MailAttachmentHandler athmHandler) throws Exception {
        Folder[] folders;
        Session session = null;
        Store store = null;
        session = Session.getInstance((Properties)emailProps);
        store = session.getStore(emailProps.getProperty("mail.store.protocol"));
        store.connect(email, password);
        for (Folder folder : folders = store.getDefaultFolder().list()) {
            if (isReadOnly) {
                folder.open(1);
            } else {
                folder.open(2);
            }
            folderHandler.handleMailFolder(folder, bodyHandler, athmHandler);
            if (isReadOnly) {
                folder.close(false);
                continue;
            }
            folder.close(true);
        }
        store.close();
    }

    public static void parseMessage(MailBodyHandler bodyHandler, MailAttachmentHandler athmHandler, Message ... messages) throws MessagingException, IOException {
        if (messages != null && messages.length > 0) {
            for (Message msg : messages) {
                bodyHandler.handleMailBody(msg);
                boolean hasAttachment = MailUtil.hasAttachment((Part)msg);
                if (!hasAttachment) continue;
                MailUtil.parseAttachment(msg, (Part)msg, athmHandler);
            }
        }
    }

    public static String getSubject(Message msg) throws UnsupportedEncodingException, MessagingException {
        return MimeUtility.decodeText((String)msg.getSubject());
    }

    public static String getSender(MimeMessage msg) throws MessagingException, UnsupportedEncodingException {
        Address sender = msg.getSender();
        msg.getSender();
        if (null == sender) {
            return null;
        }
        return msg.getSender().toString();
    }

    public static String getFrom(Message msg) throws MessagingException, UnsupportedEncodingException {
        String from = "";
        Address[] froms = msg.getFrom();
        if (froms.length < 1) {
            throw new MessagingException("Err: From message is missing in the email header");
        }
        InternetAddress address = (InternetAddress)froms[0];
        String person = address.getPersonal();
        person = person != null ? MimeUtility.decodeText((String)person) + " " : "";
        from = person + "<" + address.getAddress() + ">";
        return from;
    }

    public static String getReceiveAddress(Message msg, Message.RecipientType type) throws MessagingException {
        StringBuffer receiveAddress = new StringBuffer();
        Address[] addresss = null;
        addresss = type == null ? msg.getAllRecipients() : msg.getRecipients(type);
        if (addresss == null || addresss.length < 1) {
            throw new MessagingException("\u6ca1\u6709\u6536\u4ef6\u4eba!");
        }
        for (Address address : addresss) {
            InternetAddress internetAddress = (InternetAddress)address;
            receiveAddress.append(internetAddress.toUnicodeString()).append(",");
        }
        receiveAddress.deleteCharAt(receiveAddress.length() - 1);
        return receiveAddress.toString();
    }

    public static String getSentDate(Message msg, String pattern) throws MessagingException {
        Date receivedDate = msg.getSentDate();
        if (receivedDate == null) {
            return "";
        }
        if (pattern == null || "".equals(pattern)) {
            pattern = "yyyy-MM-dd_HH:mm:ss";
        }
        return new SimpleDateFormat(pattern).format(receivedDate);
    }

    public static boolean hasAttachment(Part part) throws MessagingException, IOException {
        boolean flag = false;
        if (part.isMimeType("multipart/*")) {
            MimeMultipart multipart = (MimeMultipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                String disp = bodyPart.getDisposition();
                if (disp != null && (disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline"))) {
                    flag = true;
                } else if (bodyPart.isMimeType("multipart/*")) {
                    flag = MailUtil.hasAttachment((Part)bodyPart);
                } else {
                    String contentType = bodyPart.getContentType();
                    if (contentType.toLowerCase().indexOf("application") > -1 || contentType.toLowerCase().indexOf("name") > -1) {
                        flag = true;
                    }
                }
                if (!flag) {
                    continue;
                }
                break;
            }
        } else if (part.isMimeType(MAIL_TYPE_MSG_RFC822)) {
            flag = MailUtil.hasAttachment((Part)part.getContent());
        }
        return flag;
    }

    public static boolean isSeen(Message msg) throws MessagingException {
        return msg.getFlags().contains(Flags.Flag.SEEN);
    }

    public static boolean isReplySign(Message msg) throws MessagingException {
        boolean replySign = false;
        String[] headers = msg.getHeader("Disposition-Notification-To");
        if (headers != null) {
            replySign = true;
        }
        return replySign;
    }

    public static String getPriority(Message msg) throws MessagingException {
        String priority = "\u666e\u901a";
        String[] headers = msg.getHeader("X-Priority");
        if (headers != null) {
            String headerPriority = headers[0];
            priority = headerPriority.indexOf("1") != -1 || headerPriority.indexOf("High") != -1 ? "High" : (headerPriority.indexOf("5") != -1 || headerPriority.indexOf("Low") != -1 ? "Low" : "Normal");
        }
        return priority;
    }

    public static void parseMailTextContent(Part part, Map<String, StringBuffer> content) throws MessagingException, IOException {
        boolean isContainTextAttach;
        boolean bl = isContainTextAttach = part.getContentType().indexOf("name") > 0;
        if (part.isMimeType(MAIL_TYPE_TEXT_HTML) && !isContainTextAttach) {
            StringBuffer sb = content.get(MAIL_TYPE_TEXT_HTML);
            if (null == sb) {
                sb = new StringBuffer(500);
                content.put(MAIL_TYPE_TEXT_HTML, sb);
            }
            sb.append(MimeUtility.decodeText((String)part.getContent().toString()));
        } else if (part.isMimeType(MAIL_TYPE_TEXT_PAIN) && !isContainTextAttach) {
            StringBuffer sb = content.get(MAIL_TYPE_TEXT_PAIN);
            if (null == sb) {
                sb = new StringBuffer(500);
                content.put(MAIL_TYPE_TEXT_PAIN, sb);
            }
            sb.append(part.getContent().toString());
        } else if (part.isMimeType(MAIL_TYPE_MSG_RFC822)) {
            MailUtil.parseMailTextContent((Part)part.getContent(), content);
        } else if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                MailUtil.parseMailTextContent((Part)bodyPart, content);
            }
        }
    }

    public static void parseAttachment(Message msg, Part part, MailAttachmentHandler athmHandler) throws UnsupportedEncodingException, MessagingException, FileNotFoundException, IOException {
        if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                String disp = bodyPart.getDisposition();
                if (disp != null && (disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline"))) {
                    athmHandler.handleMailAttachment(msg, bodyPart);
                    continue;
                }
                if (bodyPart.isMimeType("multipart/*")) {
                    MailUtil.parseAttachment(msg, (Part)bodyPart, athmHandler);
                    continue;
                }
                String contentType = bodyPart.getContentType();
                if (contentType.toLowerCase().indexOf("name") <= -1 && contentType.toLowerCase().indexOf("application") <= -1) continue;
                athmHandler.handleMailAttachment(msg, bodyPart);
            }
        } else if (part.isMimeType(MAIL_TYPE_MSG_RFC822)) {
            MailUtil.parseAttachment(msg, (Part)part.getContent(), athmHandler);
        }
    }

    public static String decodeText(String encodedText) throws UnsupportedEncodingException {
        if (encodedText == null || "".equals(encodedText)) {
            return "";
        }
        return MimeUtility.decodeText((String)encodedText);
    }
}

