/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.net.dns;

import jadeutils.net.InterfaceUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.conn.DnsResolver;

public class CustomResolver
implements DnsResolver {
    private boolean isFakeFirst;
    private Map<String, String> nameToIP;

    public CustomResolver(Map<String, String> nameToIP, boolean isFakeFirst) {
        this.nameToIP = null != nameToIP ? nameToIP : new HashMap();
        this.isFakeFirst = isFakeFirst;
    }

    private InetAddress getFakeAddress(String hostname) throws UnknownHostException {
        InetAddress addr = null;
        if (!this.nameToIP.containsKey(hostname)) {
            throw new UnknownHostException(hostname);
        }
        byte[] ip = InterfaceUtils.parseIpv4ToByts(this.nameToIP.get(hostname));
        addr = InetAddress.getByAddress(hostname, ip);
        return addr;
    }

    public InetAddress[] resolve(String hostname) throws UnknownHostException {
        InetAddress addr = null;
        if (this.isFakeFirst) {
            try {
                addr = this.getFakeAddress(hostname);
            }
            catch (UnknownHostException e) {
                addr = InetAddress.getByName(hostname);
            }
        } else {
            try {
                addr = InetAddress.getByName(hostname);
            }
            catch (UnknownHostException e) {
                addr = this.getFakeAddress(hostname);
            }
        }
        return new InetAddress[]{addr};
    }
}

