/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class InterfaceUtils {
    public static byte[] parseIpv4ToByts(String ipv4Str) {
        byte[] ipv4addr = new byte[]{0, 0, 0, 0};
        String[] ipv4StrArr = ipv4Str.split("\\.");
        ipv4addr[0] = (byte)Integer.parseInt(ipv4StrArr[0]);
        ipv4addr[1] = (byte)Integer.parseInt(ipv4StrArr[1]);
        ipv4addr[2] = (byte)Integer.parseInt(ipv4StrArr[2]);
        ipv4addr[3] = (byte)Integer.parseInt(ipv4StrArr[3]);
        return ipv4addr;
    }

    public static String getLocalIP() throws UnknownHostException, SocketException {
        String ip = "127.0.0.1";
        if (InterfaceUtils.isWindowsOS()) {
            ip = InetAddress.getLocalHost().getHostAddress();
        } else {
            try {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    String name = intf.getName();
                    if (name.contains("docker") || name.contains("lo")) continue;
                    Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        String ipaddress;
                        InetAddress inetAddress = enumIpAddr.nextElement();
                        if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress().toString()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                        ip = ipaddress;
                    }
                }
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
        }
        return ip;
    }

    private static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    private static void getLocalMac(InetAddress ia) throws SocketException {
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        System.out.println("mac\u6570\u7ec4\u957f\u5ea6\uff1a" + mac.length);
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < mac.length; ++i) {
            if (i != 0) {
                sb.append("-");
            }
            int temp = mac[i] & 0xFF;
            String str = Integer.toHexString(temp);
            System.out.println("\u6bcf8\u4f4d:" + str);
            if (str.length() == 1) {
                sb.append("0" + str);
                continue;
            }
            sb.append(str);
        }
        System.out.println("\u672c\u673aMAC\u5730\u5740:" + sb.toString().toUpperCase());
    }

    public static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public static void main(String[] args) throws UnknownHostException, SocketException {
        System.out.println(InterfaceUtils.getLocalIP());
        System.out.println(InterfaceUtils.getLocalHostName());
        InetAddress ia = InetAddress.getLocalHost();
        System.out.println(ia);
        InterfaceUtils.getLocalMac(ia);
    }
}

