/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.web.http.upload;

import jadeutils.base.FileOperater;
import jadeutils.web.http.upload.UploadToolsCfg;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class UploadTools {
    public static final String DATE_FORMAT_YEAR = "yyyy";
    public static final String DATE_FORMAT_MON_DAY = "MMdd";
    public static final String IS_RENAME = "isRename";
    public static final String FUNC_NAME = "funcName";
    public static final String RELATIVE_PATH = "relativePath";
    public static final String FILE_NAME = "realFileName";

    public void uploadSingleFile(HttpServletRequest req, String characterEncoding, String uploadFilePath, String tmpFilePath, int singleFileSize, boolean isCached, final String fileName) throws Exception {
        this.uploadManyFiles(req, characterEncoding, uploadFilePath, tmpFilePath, singleFileSize, singleFileSize, isCached, new UploadToolsCfg(){

            @Override
            public boolean isMatchFieldName(String fieldName) {
                return fieldName.equals(fileName);
            }
        });
    }

    public void uploadManyFiles(HttpServletRequest req, String characterEncoding, String uploadFilePath, String tmpFilePath, int singleFileSize, int allFileSize, boolean isCached, UploadToolsCfg cfg) throws Exception {
        try {
            String fieldName;
            req.setCharacterEncoding(characterEncoding);
            DiskFileItemFactory factory = new DiskFileItemFactory();
            if (isCached) {
                File tmpPath = new File(tmpFilePath);
                if (tmpPath.exists() && tmpPath.isFile()) {
                    tmpPath.delete();
                    tmpPath.mkdirs();
                } else if (!tmpPath.exists()) {
                    tmpPath.mkdirs();
                }
                factory.setRepository(tmpPath);
                if (allFileSize > 0) {
                    factory.setSizeThreshold(allFileSize);
                } else {
                    factory.setSizeThreshold(512000);
                }
            }
            ServletFileUpload uploader = new ServletFileUpload((FileItemFactory)factory);
            uploader.setSizeMax((long)allFileSize);
            uploader.setSizeMax((long)singleFileSize);
            List list = uploader.parseRequest(req);
            boolean isRename = true;
            String funcName = "others";
            for (FileItem item : list) {
                if (!item.isFormField()) continue;
                fieldName = item.getFieldName();
                String fieldValue = item.getString();
                if (fieldName.equals(IS_RENAME)) {
                    if (fieldValue != null && fieldValue.equalsIgnoreCase("false")) {
                        isRename = false;
                    }
                } else if (FUNC_NAME.equals(fieldName) && null != fieldValue && !"".equals(fieldValue.trim())) {
                    funcName = fieldValue;
                }
                req.setAttribute(fieldName, (Object)fieldValue);
            }
            for (FileItem item : list) {
                fieldName = item.getFieldName();
                if (item.isFormField() || !cfg.isMatchFieldName(fieldName)) continue;
                this.doUpload(req, item, uploadFilePath, funcName, isRename);
            }
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void doUpload(HttpServletRequest req, FileItem item, String uploadFilePath, String funcName, boolean isRename) throws Exception {
        String relativePath = this.getRelativePath(funcName);
        req.setAttribute(RELATIVE_PATH, (Object)relativePath);
        String fieldName = item.getFieldName();
        String filename = this.getUploadFileName(item.getName(), isRename);
        req.setAttribute(FILE_NAME, (Object)filename);
        req.setAttribute(fieldName, (Object)filename);
        if (Integer.parseInt("2") > 6666) {
            this.autoWriteFile(item, uploadFilePath, filename);
        }
        FileOperater.writeFile((String)(uploadFilePath + relativePath), (String)filename, (InputStream)item.getInputStream());
    }

    private void autoWriteFile(FileItem item, String path, String filename) throws Exception {
        item.write(new File(path, filename));
    }

    private String getRelativePath(String funcName) {
        Date now = new Date();
        StringBuffer sb = new StringBuffer(funcName);
        sb.append("/");
        sb.append(new SimpleDateFormat(DATE_FORMAT_YEAR).format(now)).append("/");
        sb.append(new SimpleDateFormat(DATE_FORMAT_MON_DAY).format(now)).append("/");
        return sb.toString();
    }

    private String getUploadFileName(String fieldValue, boolean isRename) {
        String fileName = fieldValue;
        String[] tmp = fileName.split("/");
        int tailIdx = tmp.length - 1;
        fileName = tmp[tailIdx];
        tmp = fileName.split("\\\\");
        tailIdx = tmp.length - 1;
        fileName = tmp[tailIdx];
        if (isRename) {
            StringBuffer sb = new StringBuffer(UUID.randomUUID().toString());
            String[] nn = fileName.split("\\.");
            if (null != nn && nn.length > 0) {
                sb.append(".").append(nn[nn.length - 1]);
            }
            fileName = sb.toString();
        }
        return fileName;
    }
}

