/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.net.http;

import jadeutils.encryption.Base64;
import jadeutils.net.SocketPool;
import jadeutils.net.http.HttpProxy;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import javax.net.SocketFactory;

public class HttpParam {
    SocketFactory sf;
    SocketAddress sa;
    String path;
    String host;
    String proxyAuth;

    HttpParam(HttpProxy httpProxy, String url) {
        if (httpProxy == null) {
            try {
                URL url_ = new URL(url);
                int port = url_.getPort();
                String query = url_.getQuery();
                this.sf = SocketPool.getSocketFactory(url_.getProtocol().equals("https"));
                this.sa = new InetSocketAddress(url_.getHost(), port == -1 ? url_.getDefaultPort() : port);
                this.path = url_.getPath() + (query == null ? "" : "?" + query);
                this.host = url_.getHost() + (port == -1 ? "" : ":" + port);
            }
            catch (IOException e) {
                this.sf = SocketPool.getSocketFactory(false);
                this.sa = new InetSocketAddress("localhost", 80);
                this.path = "/";
                this.host = "localhost";
            }
            this.proxyAuth = null;
        } else {
            this.sf = SocketPool.getSocketFactory(false);
            this.sa = httpProxy.getSocketAddress();
            this.path = url;
            try {
                URL url_ = new URL(url);
                int port = url_.getPort();
                this.host = url_.getHost() + (port == -1 ? "" : ":" + port);
            }
            catch (IOException e) {
                this.host = "localhost";
            }
            String username = httpProxy.getUsername();
            if (username == null) {
                this.proxyAuth = null;
            } else {
                String password = httpProxy.getPassword();
                this.proxyAuth = "Basic " + Base64.encode((byte[])(username + ":" + (password == null ? "" : password)).getBytes());
            }
        }
    }
}

