/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.net.dns;

import jadeutils.encryption.Bytes;
import jadeutils.encryption.Numbers;
import jadeutils.net.dns.DNSUpdater;
import jadeutils.net.dns.RemoteDNSUpdater;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

public class DDNSService {
    private ConcurrentHashMap<String, Record> dynamicRecords = new ConcurrentHashMap();
    private HashMap<String, Record[]> aRecords = new HashMap();
    private HashMap<String, Record[]> aaaaRecords = new HashMap();
    private HashMap<String, Record[]> nsRecords = new HashMap();
    private HashMap<String, Record[]> mxRecords = new HashMap();

    public byte[] parseIpAddress(String ipStr) throws ParseException {
        String[] ss = ipStr.split("\\.");
        if (ss.length < 4) {
            throw new ParseException("erro ip address String: " + ipStr, 1);
        }
        byte[] ip = new byte[4];
        for (int j = 0; j < 4; ++j) {
            ip[j] = (byte)Numbers.parseInt((String)ss[j]);
        }
        return ip;
    }

    public String absoluteHostName(String hostName) {
        return (hostName.endsWith(".") ? hostName : hostName + ".").toLowerCase();
    }

    private void addIp(String hostName, String ip, int ttl) {
        try {
            ARecord rec = this.createARecord(hostName, this.parseIpAddress(ip), ttl);
            this.dynamicRecords.put(hostName, (Record)rec);
            System.out.println("add rec: " + hostName + " -> " + ip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ARecord createARecord(String hostName, byte[] ip, int ttl) {
        ARecord rec = null;
        try {
            Name name = new Name(this.absoluteHostName(hostName));
            InetAddress addr = InetAddress.getByAddress(ip);
            rec = new ARecord(name, 1, (long)ttl, addr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rec;
    }

    private ARecord findARecordInPublicDNS(String hostName, int ttl) {
        ARecord rec = null;
        try {
            InetAddress addr = InetAddress.getByName(hostName);
            rec = this.createARecord(hostName, addr.getAddress(), ttl);
            this.dynamicRecords.put(hostName, (Record)rec);
            System.out.println("add rec: " + hostName + " -> " + addr.getAddress());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rec;
    }

    private void dump(DatagramPacket packet, boolean send) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        Bytes.dump((PrintWriter)out, (byte[])packet.getData(), (int)packet.getOffset(), (int)packet.getLength());
        System.out.println("\n\ndumpstart ============================");
        System.out.println((send ? "Sent to " : "Received from ") + packet.getAddress().getHostAddress());
        System.out.println(sw.toString());
        System.out.println("\n\ndumpend ============================");
    }

    private Message getError(Header header, int rcode, Record question) {
        Message response = new Message();
        response.setHeader(header);
        response.removeAllRecords(0);
        response.removeAllRecords(1);
        response.removeAllRecords(2);
        response.removeAllRecords(3);
        if (rcode == 2) {
            response.addRecord(question, 0);
        }
        header.setRcode(rcode);
        return response;
    }

    private Message process(Message request) {
        Record[] records;
        Header reqHeader = request.getHeader();
        if (reqHeader.getFlag(0)) {
            return null;
        }
        Record question = request.getQuestion();
        if (reqHeader.getRcode() != 0) {
            return this.getError(reqHeader, 1, question);
        }
        if (reqHeader.getOpcode() != 0) {
            return this.getError(reqHeader, 4, question);
        }
        Message response = new Message(reqHeader.getID());
        Header respHeader = response.getHeader();
        respHeader.setFlag(0);
        respHeader.setFlag(5);
        if (reqHeader.getFlag(7)) {
            respHeader.setFlag(7);
        }
        response.addRecord(question, 0);
        String host = question.getName().toString(true).toLowerCase();
        switch (question.getType()) {
            case 1: 
            case 255: {
                Record[] recordArray;
                records = this.aRecords.get(host);
                if (records != null) break;
                Record record = this.dynamicRecords.get(host);
                if (null == record) {
                    record = this.findARecordInPublicDNS(host, 60000);
                }
                System.out.println("find record: " + host + " -> " + record);
                if (record == null) {
                    recordArray = null;
                } else {
                    Record[] recordArray2 = new Record[1];
                    recordArray = recordArray2;
                    recordArray2[0] = record;
                }
                records = recordArray;
                break;
            }
            case 2: {
                records = this.nsRecords.get(host);
                break;
            }
            case 15: {
                records = this.mxRecords.get(host);
                break;
            }
            case 28: {
                records = this.aaaaRecords.get(host);
                break;
            }
            default: {
                return this.getError(reqHeader, 4, question);
            }
        }
        if (records == null) {
            return this.getError(reqHeader, 3, question);
        }
        for (Record record : records) {
            response.addRecord(record, 1);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doService(int port, final DNSUpdater dnsUpdater) {
        try {
            DatagramSocket socket = new DatagramSocket(port);
            Throwable throwable = null;
            try {
                try {
                    Thread thread = new Thread(){

                        /*
                         * Unable to fully structure code
                         */
                        @Override
                        public void run() {
                            block0: while (true) {
                                if (null == (recs = dnsUpdater.updateDynamicRecords()) || recs.size() <= 0) {
                                    continue;
                                }
                                var2_2 = recs.iterator();
                                while (true) {
                                    if (var2_2.hasNext()) ** break;
                                    continue block0;
                                    rec = var2_2.next();
                                    DDNSService.access$000(DDNSService.this, rec[0], rec[1], 5);
                                }
                                break;
                            }
                        }
                    };
                    thread.start();
                    socket.setSoTimeout(816);
                    while (true) {
                        byte[] buf = new byte[65536];
                        DatagramPacket packet = new DatagramPacket(buf, buf.length);
                        try {
                            Message request;
                            socket.receive(packet);
                            this.dump(packet, false);
                            try {
                                request = new Message(Bytes.left((byte[])buf, (int)packet.getLength()));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                continue;
                            }
                            Message response = this.process(request);
                            if (response == null) continue;
                            buf = response.toWire();
                            try {
                                packet = new DatagramPacket(buf, buf.length, packet.getSocketAddress());
                                socket.send(packet);
                                this.dump(packet, true);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (IOException e) {
                            if (!(e instanceof SocketTimeoutException)) {
                                e.printStackTrace();
                            }
                            try {
                                Thread.sleep(16L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (socket != null) {
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        socket.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException | Error | RuntimeException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int port = 53;
        String apiAddr = "http://localhost:8383/addr.jsp";
        int apiTimeout = 10000;
        RemoteDNSUpdater updater = new RemoteDNSUpdater(apiAddr, apiTimeout);
        DDNSService ddns = new DDNSService();
        ddns.doService(port, updater);
    }

    static /* synthetic */ void access$000(DDNSService x0, String x1, String x2, int x3) {
        x0.addIp(x1, x2, x3);
    }
}

