/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.mongo;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import jadeutils.mongo.Condition;
import jadeutils.mongo.MongoModel;
import jadeutils.mongo.impl.MongoUtil;
import java.util.ArrayList;
import java.util.List;

public class MongoResultSet<T extends MongoModel> {
    private DBCursor cursor;
    private Class<T> entryClass;

    public MongoResultSet(Class<T> entryClass, DBCursor cursor) {
        this.cursor = cursor;
        this.entryClass = entryClass;
    }

    public MongoResultSet<T> skip(int n) {
        return new MongoResultSet<T>(this.entryClass, this.cursor.skip(n));
    }

    public MongoResultSet<T> limit(int n) {
        return new MongoResultSet<T>(this.entryClass, this.cursor.limit(n));
    }

    public MongoResultSet<T> sort(Condition orderBy) throws IllegalArgumentException, IllegalAccessException {
        return new MongoResultSet<T>(this.entryClass, this.cursor.sort((DBObject)MongoUtil.parseCondition(orderBy)));
    }

    public boolean hasNext() {
        if (null == this.cursor) {
            return false;
        }
        boolean result = this.cursor.hasNext();
        if (result) {
            return result;
        }
        this.cursor.close();
        return false;
    }

    public T next() throws InstantiationException, IllegalAccessException {
        T obj = null;
        if (this.cursor.hasNext()) {
            obj = MongoUtil.genModelFromRec(this.entryClass, this.cursor.next());
        } else {
            this.cursor.close();
        }
        return obj;
    }

    public List<T> toList() throws InstantiationException, IllegalAccessException {
        ArrayList<T> list = new ArrayList<T>();
        while (this.hasNext()) {
            list.add(this.next());
        }
        return list;
    }
}

