/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.mongo.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import jadeutils.mongo.Condition;
import jadeutils.mongo.MongoDocument;
import jadeutils.mongo.MongoField;
import jadeutils.mongo.MongoModel;
import java.lang.reflect.Field;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;

public class MongoUtil<T extends MongoModel> {
    public static <T extends MongoModel> String getCollectionNameFromOjbect(T obj) {
        MongoDocument md = obj.getClass().getAnnotation(MongoDocument.class);
        return null == md ? null : md.collectionName();
    }

    public static <T extends MongoModel> DBObject genRecFromModel(T obj) throws IllegalArgumentException, IllegalAccessException {
        return MongoUtil.genRecFromObject(obj);
    }

    public static DBObject genRecFromObject(Object obj) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        BasicDBObject rec = new BasicDBObject();
        for (Field f : fields = obj.getClass().getDeclaredFields()) {
            if (f.getAnnotation(MongoField.class) == null) continue;
            f.setAccessible(true);
            rec.put(f.getName(), MongoUtil.parseObject(f.get(obj)));
        }
        return rec;
    }

    public static <T extends MongoModel> T genModelFromRec(Class<? extends MongoModel> clazz, DBObject rec) throws InstantiationException, IllegalAccessException {
        Object obj = MongoUtil.genObjectFromRec(clazz, rec);
        if (null != obj) {
            MongoModel result = (MongoModel)obj;
            ObjectId mid = (ObjectId)rec.get("_id");
            result.setMongoId(null == mid ? null : mid.toString());
            return (T)result;
        }
        return null;
    }

    public static Object genObjectFromRec(Class<?> clazz, DBObject rec) throws InstantiationException, IllegalAccessException {
        Object obj = null;
        if (null != rec) {
            Field[] fields;
            obj = clazz.newInstance();
            for (Field f : fields = clazz.getDeclaredFields()) {
                MongoField mf = f.getAnnotation(MongoField.class);
                if (mf == null || !rec.containsField(f.getName())) continue;
                f.setAccessible(true);
                Object value = MongoUtil.parseField(mf.ElemType(), rec.get(f.getName()));
                f.set(obj, value);
            }
        }
        return obj;
    }

    public static Object parseField(Class<?> clazz, Object value) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Cloneable result = null;
        if (null != value) {
            if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String || value instanceof Date) {
                result = value;
            } else if (value instanceof List) {
                List l = value;
                ArrayList<Object> ll = new ArrayList<Object>();
                for (Object o : l) {
                    ll.add(MongoUtil.parseField(clazz, o));
                }
                result = ll;
            } else if (value instanceof Object[]) {
                Object[] l = (Object[])value;
                ArrayList<Object> ll = new ArrayList<Object>();
                for (Object o : l) {
                    ll.add(MongoUtil.parseField(clazz, o));
                }
                result = ll;
            } else if (value instanceof Map && clazz.isInstance(Map.class)) {
                Map m = (Map)((Object)value);
                if (!m.isEmpty()) {
                    Class<?> et = m.entrySet().toArray()[0].getClass();
                    HashMap<String, Object> o = new HashMap<String, Object>();
                    for (Map.Entry e : m.entrySet()) {
                        o.put(e.getKey().toString(), MongoUtil.parseField(et, e.getValue()));
                    }
                    result = o;
                }
            } else if (value instanceof DBObject) {
                result = MongoUtil.genObjectFromRec(clazz, (DBObject)value);
            }
        }
        return result;
    }

    public static Object parseObject(Object value) throws IllegalArgumentException, IllegalAccessException {
        Object result = null;
        if (null != value) {
            if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String || value instanceof Date) {
                result = value;
            } else if (value instanceof List) {
                List l = (List)value;
                BasicDBObject ll = new ArrayList();
                for (Object o : l) {
                    ll.add(MongoUtil.parseObject(o));
                }
                result = ll;
            } else if (value instanceof Object[]) {
                Object[] l = (Object[])value;
                ArrayList<Object> ll = new ArrayList<Object>();
                for (Object o : l) {
                    ll.add(MongoUtil.parseObject(o));
                }
                result = ll;
            } else if (value instanceof Map) {
                Map m = (Map)value;
                BasicDBObject o = new BasicDBObject();
                for (Map.Entry e : m.entrySet()) {
                    o.put(e.getKey().toString(), MongoUtil.parseObject(e.getValue()));
                }
                result = o;
            } else {
                result = MongoUtil.genRecFromObject(value);
            }
        }
        return result;
    }

    public static BasicDBObject parseCondition(Condition condition) throws IllegalArgumentException, IllegalAccessException {
        BasicDBObject result = null;
        if (null != condition && null != condition.getKey() && null != condition.getValue()) {
            Object value = MongoUtil.parseConditionValue(condition.getValue());
            if (null != value) {
                result = new BasicDBObject(condition.getKey(), value);
            } else if (null != condition.getLink() && null != condition.getLink().getCondition()) {
                Condition nextCondition = condition.getLink().getCondition();
                result = MongoUtil.parseCondition(nextCondition);
            }
            if (null != result) {
                MongoUtil.addLink(result, condition);
            }
        }
        return result;
    }

    private static void addLink(BasicDBObject result, Condition condition) throws IllegalArgumentException, IllegalAccessException {
        Condition.Link link = condition.getLink();
        if (null != link && null != link.getCondition()) {
            Condition nextCondition = link.getCondition();
            if (Condition.LinkType.AND.equals((Object)link.getType())) {
                result.append(nextCondition.getKey(), MongoUtil.parseConditionValue(nextCondition.getValue()));
            }
            if (null != nextCondition.getLink() && null != nextCondition.getLink().getCondition()) {
                MongoUtil.addLink(result, nextCondition);
            }
        }
    }

    private static Object parseConditionValue(Object value) throws IllegalArgumentException, IllegalAccessException {
        Object result = null;
        if (null != value) {
            if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String || value instanceof Date) {
                result = value;
            } else if (value instanceof List) {
                List l = (List)value;
                BasicDBObject ll = new ArrayList();
                for (Object o : l) {
                    ll.add(MongoUtil.parseConditionValue(o));
                }
                result = ll;
            } else if (value instanceof Object[]) {
                Object[] l = (Object[])value;
                ArrayList<Object> ll = new ArrayList<Object>();
                for (Object o : l) {
                    ll.add(MongoUtil.parseConditionValue(o));
                }
                result = ll;
            } else if (value instanceof Map) {
                Map m = (Map)value;
                BasicDBObject o = new BasicDBObject();
                for (Map.Entry e : m.entrySet()) {
                    o.put(e.getKey().toString(), MongoUtil.parseConditionValue(e.getValue()));
                }
                result = o;
            } else {
                result = value instanceof Condition ? MongoUtil.parseCondition((Condition)value) : MongoUtil.genRecFromObject(value);
            }
        }
        return result;
    }
}

