/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TextTempletRanderTool {
    private static final Pattern TAKER_PATTERN = Pattern.compile("\\$\\{([0-9a-zA-Z]+\\.?)+\\}");

    public static String render(String templet, Map<String, String> params) {
        String result = templet;
        if (StringUtils.isNotBlank((String)result)) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                String key = param.getKey();
                if (StringUtils.isBlank((String)key)) continue;
                key = "\\$\\{" + key.replaceAll("\\.", "\\.") + "\\}";
                String value = param.getValue();
                value = null == value ? "" : value;
                result = result.replaceAll(key, value);
            }
        }
        return result;
    }

    public static List<String> getUnRanderedParams(String template) {
        ArrayList results = null;
        HashMap<String, String> keyMap = new HashMap<String, String>();
        Matcher matcher = TAKER_PATTERN.matcher(template);
        while (matcher.find()) {
            String key = template.substring(matcher.start(), matcher.end());
            keyMap.put(key, key);
        }
        if (keyMap.size() > 0) {
            results = new ArrayList();
            for (Map.Entry e : keyMap.entrySet()) {
                results.add(e.getKey());
            }
        }
        return results;
    }
}

