/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.json;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class JsonUtils {
    private ObjectMapper mapper = new ObjectMapper();

    private JsonUtils(JsonSerialize.Inclusion inclusion) {
        this.mapper.getSerializationConfig().setSerializationInclusion(inclusion);
        this.mapper.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static JsonUtils newInstance() {
        return new JsonUtils(JsonSerialize.Inclusion.NON_DEFAULT);
    }

    public static JsonUtils newInstanceAlways() {
        return new JsonUtils(JsonSerialize.Inclusion.ALWAYS);
    }

    public static JsonUtils newInstanceNonNull() {
        return new JsonUtils(JsonSerialize.Inclusion.NON_NULL);
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) {
        if (StringUtils.isEmpty((String)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toJson(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setDateFormat(String pattern) {
        if (StringUtils.isNotBlank((String)pattern)) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            this.mapper.getSerializationConfig().setDateFormat((DateFormat)df);
            this.mapper.getDeserializationConfig().setDateFormat((DateFormat)df);
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public static String formatJson(String json, String indentStr) {
        String token;
        if (json == null || json.trim().length() == 0) {
            return null;
        }
        int fixedLenth = 0;
        ArrayList<String> tokenList = new ArrayList<String>();
        String jsonTemp = json;
        while (jsonTemp.length() > 0) {
            token = JsonUtils.getToken(jsonTemp);
            jsonTemp = jsonTemp.substring(token.length());
            token = token.trim();
            tokenList.add(token);
        }
        for (int i = 0; i < tokenList.size(); ++i) {
            token = (String)tokenList.get(i);
            int length = token.getBytes().length;
            if (length <= fixedLenth || i >= tokenList.size() - 1 || !((String)tokenList.get(i + 1)).equals(":")) continue;
            fixedLenth = length;
        }
        StringBuilder buf = new StringBuilder();
        int indentLevel = 0;
        for (int i = 0; i < tokenList.size(); ++i) {
            int fillLength;
            String token2 = (String)tokenList.get(i);
            if (token2.equals(",")) {
                buf.append(token2);
                JsonUtils.doFill(buf, indentLevel, indentStr);
                continue;
            }
            if (token2.equals(":")) {
                buf.append(" ").append(token2).append(" ");
                continue;
            }
            if (token2.equals("{")) {
                String nextToken = (String)tokenList.get(i + 1);
                if (nextToken.equals("}")) {
                    ++i;
                    buf.append("{ }");
                    continue;
                }
                buf.append(token2);
                JsonUtils.doFill(buf, ++indentLevel, indentStr);
                continue;
            }
            if (token2.equals("}")) {
                JsonUtils.doFill(buf, --indentLevel, indentStr);
                buf.append(token2);
                continue;
            }
            if (token2.equals("[")) {
                String nextToken = (String)tokenList.get(i + 1);
                if (nextToken.equals("]")) {
                    ++i;
                    buf.append("[ ]");
                    continue;
                }
                buf.append(token2);
                JsonUtils.doFill(buf, ++indentLevel, indentStr);
                continue;
            }
            if (token2.equals("]")) {
                JsonUtils.doFill(buf, --indentLevel, indentStr);
                buf.append(token2);
                continue;
            }
            buf.append(token2);
            if (i >= tokenList.size() - 1 || !((String)tokenList.get(i + 1)).equals(":") || (fillLength = fixedLenth - token2.getBytes().length) <= 0) continue;
            for (int j = 0; j < fillLength; ++j) {
                buf.append(" ");
            }
        }
        return buf.toString();
    }

    private static String getToken(String json) {
        StringBuilder buf = new StringBuilder();
        boolean isInYinHao = false;
        while (json.length() > 0) {
            String token = json.substring(0, 1);
            json = json.substring(1);
            if (!isInYinHao && (token.equals(":") || token.equals("{") || token.equals("}") || token.equals("[") || token.equals("]") || token.equals(","))) {
                if (buf.toString().trim().length() != 0) break;
                buf.append(token);
                break;
            }
            if (token.equals("\\")) {
                buf.append(token);
                buf.append(json.substring(0, 1));
                json = json.substring(1);
                continue;
            }
            if (token.equals("\"")) {
                buf.append(token);
                if (isInYinHao) break;
                isInYinHao = true;
                continue;
            }
            buf.append(token);
        }
        return buf.toString();
    }

    private static void doFill(StringBuilder buf, int indentLevel, String indentStr) {
        buf.append("\n");
        for (int i = 0; i < indentLevel; ++i) {
            buf.append(indentStr);
        }
    }
}

