/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.image;

import jadeutils.image.ImageUtils;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageUtilsWrapper {
    public static final void scale(String srcFileName, String destFileName, double scale) throws IOException {
        FileInputStream srcImg = null;
        OutputStream destImg = null;
        try {
            srcImg = new FileInputStream(new File(srcFileName));
            destImg = new FileOutputStream(new File(destFileName));
            ImageUtils.scale(srcImg, destImg, scale);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (null != srcImg) {
                    ((InputStream)srcImg).close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != destImg) {
                    destImg.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final void scale(String srcFileName, String destFileName, int width, int height, boolean isFill) throws IOException {
        FileInputStream srcImg = null;
        OutputStream destImg = null;
        try {
            srcImg = new FileInputStream(new File(srcFileName));
            destImg = new FileOutputStream(new File(destFileName));
            ImageUtils.scale(srcImg, destImg, width, height, isFill);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (null != srcImg) {
                    ((InputStream)srcImg).close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != destImg) {
                    destImg.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final void cut(String srcFileName, String destFileName, int x, int y, int width, int height) throws IOException {
        FileInputStream srcImg = null;
        OutputStream destImg = null;
        try {
            srcImg = new FileInputStream(new File(srcFileName));
            destImg = new FileOutputStream(new File(destFileName));
            ImageUtils.cut(srcImg, destImg, x, y, width, height);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (null != srcImg) {
                    ((InputStream)srcImg).close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != destImg) {
                    destImg.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final void divideByGrid(String srcFileName, final String descPrefix, int rowCount, int colCount) throws IOException {
        FileInputStream srcImg = null;
        try {
            srcImg = new FileInputStream(new File(srcFileName));
            ImageUtils.divideByGrid(srcImg, new ImageUtils.MutiOutputStreamGenerater(){

                @Override
                public OutputStream genOutputStream(String idx, String postFix) throws FileNotFoundException {
                    String fileName = descPrefix + idx + postFix;
                    return new FileOutputStream(new File(fileName));
                }
            }, rowCount, colCount);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (null != srcImg) {
                    ((InputStream)srcImg).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final void divideBySize(String srcFileName, final String descPrefix, int rowCount, int colCount) throws IOException {
        FileInputStream srcImg = null;
        try {
            srcImg = new FileInputStream(new File(srcFileName));
            ImageUtils.divideBySize(srcImg, new ImageUtils.MutiOutputStreamGenerater(){

                @Override
                public OutputStream genOutputStream(String idx, String postFix) throws FileNotFoundException {
                    String fileName = descPrefix + idx + postFix;
                    return new FileOutputStream(new File(fileName));
                }
            }, rowCount, colCount);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (null != srcImg) {
                    ((InputStream)srcImg).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final void gray(String srcFileName, String destFileName) throws IOException {
        FileInputStream srcImg = null;
        OutputStream destImg = null;
        try {
            srcImg = new FileInputStream(new File(srcFileName));
            destImg = new FileOutputStream(new File(destFileName));
            ImageUtils.gray(srcImg, destImg);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (null != srcImg) {
                    ((InputStream)srcImg).close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != destImg) {
                    destImg.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final void convert(String srcFileName, String destFileName, String format) throws IOException {
        FileInputStream srcImg = null;
        OutputStream destImg = null;
        try {
            srcImg = new FileInputStream(new File(srcFileName));
            destImg = new FileOutputStream(new File(destFileName));
            ImageUtils.convert(srcImg, destImg, format);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (null != srcImg) {
                    ((InputStream)srcImg).close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != destImg) {
                    destImg.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final void pressText(String srcFileName, String destFileName, String pressText, int x, int y, String fontName, int fontStyle, int fontSize, Color color, float alpha) throws IOException {
        FileInputStream srcImg = null;
        OutputStream destImg = null;
        try {
            srcImg = new FileInputStream(new File(srcFileName));
            destImg = new FileOutputStream(new File(destFileName));
            ImageUtils.pressText(srcImg, destImg, pressText, x, y, fontName, fontStyle, fontSize, color, alpha);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (null != srcImg) {
                    ((InputStream)srcImg).close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != destImg) {
                    destImg.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final void pressImage(String srcFileName, String pressFileName, String destFileName, int x, int y, float alpha) throws IOException {
        FileInputStream srcImg = null;
        InputStream pressImg = null;
        OutputStream destImg = null;
        try {
            srcImg = new FileInputStream(new File(srcFileName));
            pressImg = new FileInputStream(new File(pressFileName));
            destImg = new FileOutputStream(new File(destFileName));
            ImageUtils.pressImage(srcImg, pressImg, destImg, destFileName, x, y, alpha);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (null != srcImg) {
                    ((InputStream)srcImg).close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != pressImg) {
                    pressImg.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != destImg) {
                    destImg.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

