/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static String IMAGE_TYPE_GIF = "gif";
    public static String IMAGE_TYPE_JPEG = "jpg";
    public static String IMAGE_TYPE_BMP = "bmp";
    public static String IMAGE_TYPE_PNG = "png";
    public static String IMAGE_TYPE_PSD = "psd";

    public static final void convert(InputStream srcImg, OutputStream destImg, String format) {
        try {
            BufferedImage src = ImageIO.read(srcImg);
            ImageIO.write((RenderedImage)src, format, destImg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void gray(InputStream srcImg, OutputStream destImg) throws IOException {
        BufferedImage src = ImageIO.read(srcImg);
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp op = new ColorConvertOp(cs, null);
        src = op.filter(src, null);
        ImageIO.write((RenderedImage)src, IMAGE_TYPE_JPEG, destImg);
    }

    public static final void scale(InputStream srcImg, OutputStream destImg, double scale) throws IOException {
        BufferedImage src = ImageIO.read(srcImg);
        int width = src.getWidth();
        int height = src.getHeight();
        width = (int)((double)width * scale);
        height = (int)((double)height * scale);
        Image image = src.getScaledInstance(width, height, 1);
        BufferedImage tag = new BufferedImage(width, height, 1);
        Graphics g = tag.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, destImg);
    }

    public static final void scale(InputStream srcImg, OutputStream destImg, int width, int height, boolean isFill) throws IOException {
        BufferedImage bi = ImageIO.read(srcImg);
        Image itemp = bi.getScaledInstance(width, height, 4);
        double ratio = ImageUtils.caculateScaleRatio(bi.getWidth(), bi.getHeight(), width, height);
        AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
        itemp = op.filter(bi, null);
        if (isFill) {
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, width, height);
            if (width == itemp.getWidth(null)) {
                g.drawImage(itemp, 0, (height - itemp.getHeight(null)) / 2, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
            } else {
                g.drawImage(itemp, (width - itemp.getWidth(null)) / 2, 0, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
            }
            g.dispose();
            itemp = image;
        }
        ImageIO.write((RenderedImage)((BufferedImage)itemp), IMAGE_TYPE_JPEG, destImg);
    }

    public static double caculateScaleRatio(int srcWidth, int srcHeight, int tagWidth, int tagHeight) {
        double heightRatio;
        double widthRatio = new Integer(tagWidth).doubleValue() / (double)srcWidth;
        return widthRatio > (heightRatio = new Integer(tagHeight).doubleValue() / (double)srcHeight) ? heightRatio : widthRatio;
    }

    public static final void cut(InputStream srcImg, OutputStream destImg, int x, int y, int width, int height) throws IOException {
        BufferedImage bi = ImageIO.read(srcImg);
        int srcWidth = bi.getHeight();
        int srcHeight = bi.getWidth();
        if (srcWidth > 0 && srcHeight > 0) {
            Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
            CropImageFilter cropFilter = new CropImageFilter(x, y, width, height);
            Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(img, 0, 0, width, height, null);
            g.dispose();
            ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, destImg);
        }
    }

    public static final void pressText(InputStream srcImg, OutputStream destImg, String pressText, int x, int y, String fontName, int fontStyle, int fontSize, Color color, float alpha) throws IOException {
        BufferedImage src = ImageIO.read(srcImg);
        int width = ((Image)src).getWidth(null);
        int height = ((Image)src).getHeight(null);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        g.drawImage(src, 0, 0, width, height, null);
        g.setColor(color);
        g.setFont(new Font(fontName, fontStyle, fontSize));
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        g.drawString(pressText, (width - ImageUtils.getLength(pressText) * fontSize) / 2 + x, (height - fontSize) / 2 + y);
        g.dispose();
        ImageIO.write((RenderedImage)image, IMAGE_TYPE_JPEG, destImg);
    }

    public static final void pressImage(InputStream srcImg, InputStream pressImg, OutputStream destImg, String destFileName, int x, int y, float alpha) throws IOException {
        BufferedImage src = ImageIO.read(srcImg);
        int wideth = ((Image)src).getWidth(null);
        int height = ((Image)src).getHeight(null);
        BufferedImage image = new BufferedImage(wideth, height, 1);
        Graphics2D g = image.createGraphics();
        g.drawImage(src, 0, 0, wideth, height, null);
        BufferedImage src_biao = ImageIO.read(pressImg);
        int wideth_biao = ((Image)src_biao).getWidth(null);
        int height_biao = ((Image)src_biao).getHeight(null);
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        g.drawImage(src_biao, (wideth - wideth_biao) / 2, (height - height_biao) / 2, wideth_biao, height_biao, null);
        g.dispose();
        ImageIO.write((RenderedImage)image, IMAGE_TYPE_JPEG, new File(destFileName));
    }

    public static final void pressText2(String srcFileName, String destFileName, String pressText, int x, int y, String fontName, int fontStyle, int fontSize, Color color, float alpha) {
        try {
            File img = new File(srcFileName);
            BufferedImage src = ImageIO.read(img);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.setColor(color);
            g.setFont(new Font(fontName, fontStyle, fontSize));
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawString(pressText, (width - ImageUtils.getLength(pressText) * fontSize) / 2 + x, (height - fontSize) / 2 + y);
            g.dispose();
            ImageIO.write((RenderedImage)image, IMAGE_TYPE_JPEG, new File(destFileName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void divideByGrid(InputStream srcImg, MutiOutputStreamGenerater osGenerater, int rowCount, int colCount) throws IOException {
        if (rowCount <= 0 || rowCount > 20) {
            rowCount = 2;
        }
        if (colCount <= 0 || colCount > 20) {
            colCount = 2;
        }
        BufferedImage bi = ImageIO.read(srcImg);
        int srcWidth = bi.getHeight();
        int srcHeight = bi.getWidth();
        if (srcWidth > 0 && srcHeight > 0) {
            Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
            int cellWidth = srcWidth;
            int cellHeight = srcHeight;
            cellWidth = srcWidth % colCount == 0 ? srcWidth / colCount : (int)Math.floor(srcWidth / colCount) + 1;
            cellHeight = srcHeight % rowCount == 0 ? srcHeight / rowCount : (int)Math.floor(srcWidth / rowCount) + 1;
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    CropImageFilter cropFilter = new CropImageFilter(j * cellWidth, i * cellHeight, cellWidth, cellHeight);
                    Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                    BufferedImage tag = new BufferedImage(cellWidth, cellHeight, 1);
                    Graphics g = tag.getGraphics();
                    g.drawImage(img, 0, 0, null);
                    g.dispose();
                    OutputStream os = null;
                    try {
                        os = osGenerater.genOutputStream("_r" + i + "_c" + j, "." + IMAGE_TYPE_JPEG);
                        ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, os);
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    finally {
                        try {
                            if (null != os) {
                                os.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void divideBySize(InputStream srcImg, MutiOutputStreamGenerater osGenerater, int cellWidth, int cellHeight) throws IOException {
        if (cellWidth <= 0) {
            cellWidth = 200;
        }
        if (cellHeight <= 0) {
            cellHeight = 150;
        }
        BufferedImage bi = ImageIO.read(srcImg);
        int srcWidth = bi.getHeight();
        int srcHeight = bi.getWidth();
        if (srcWidth > cellWidth && srcHeight > cellHeight) {
            Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
            int colCount = 0;
            int rowCount = 0;
            colCount = srcWidth % cellWidth == 0 ? srcWidth / cellWidth : (int)Math.floor(srcWidth / cellWidth) + 1;
            rowCount = srcHeight % cellHeight == 0 ? srcHeight / cellHeight : (int)Math.floor(srcHeight / cellHeight) + 1;
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    CropImageFilter cropFilter = new CropImageFilter(j * cellWidth, i * cellHeight, cellWidth, cellHeight);
                    Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                    BufferedImage tag = new BufferedImage(cellWidth, cellHeight, 1);
                    Graphics g = tag.getGraphics();
                    g.drawImage(img, 0, 0, null);
                    g.dispose();
                    OutputStream os = null;
                    try {
                        os = osGenerater.genOutputStream("_r" + i + "_c" + j, "." + IMAGE_TYPE_JPEG);
                        ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, os);
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    finally {
                        try {
                            if (null != os) {
                                os.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    public static final int getLength(String text) {
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (new String(text.charAt(i) + "").getBytes().length > 1) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length / 2;
    }

    public static interface MutiOutputStreamGenerater {
        public OutputStream genOutputStream(String var1, String var2) throws FileNotFoundException;
    }
}

