/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.encryption;

import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Pool<T, E extends Exception>
implements AutoCloseable {
    private int timeout;
    private int interval;
    private ConcurrentLinkedDeque<Entry> deque = new ConcurrentLinkedDeque();
    private AtomicLong accessed = new AtomicLong(System.currentTimeMillis());
    private volatile boolean closed = false;

    protected abstract T makeObject() throws E;

    protected void activateObject(T obj) throws E {
    }

    protected void passivateObject(T obj) throws E {
    }

    protected abstract void destroyObject(T var1);

    public Pool() {
        this(0, 0);
    }

    public Pool(int timeout, int interval) {
        this.timeout = timeout;
        this.interval = interval;
    }

    public T borrowObject() throws E {
        Entry entry;
        long accessed_;
        long now;
        if (this.timeout > 0 && (now = System.currentTimeMillis()) > (accessed_ = this.accessed.get()) + (long)this.interval && this.accessed.compareAndSet(accessed_, now)) {
            while ((entry = this.deque.pollLast()) != null) {
                if (now < entry.expire) {
                    this.deque.offerLast(entry);
                    break;
                }
                this.destroyObject(entry.obj);
            }
        }
        while ((entry = this.deque.pollFirst()) != null) {
            try {
                this.activateObject(entry.obj);
                return entry.obj;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.destroyObject(entry.obj);
            }
        }
        T obj = this.makeObject();
        try {
            this.activateObject(obj);
            return obj;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.destroyObject(obj);
            throw e;
        }
    }

    public void returnObject(T obj) {
        try {
            this.passivateObject(obj);
            if (this.closed) {
                this.destroyObject(obj);
            } else {
                this.deque.offerFirst(new Entry(obj, System.currentTimeMillis() + (long)this.timeout));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.destroyObject(obj);
        }
    }

    public void reopen() {
        this.closed = false;
    }

    @Override
    public void close() {
        Entry entry;
        this.closed = true;
        while ((entry = this.deque.pollFirst()) != null) {
            this.destroyObject(entry.obj);
        }
    }

    class Entry {
        T obj;
        long expire;

        Entry(T obj, long expire) {
            this.obj = obj;
            this.expire = expire;
        }
    }
}

