/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.encryption;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Coder {
    private static MessageDigest MD;
    private static final String[] MD5hexDigits;
    private static final long[] LONGARRAY;
    private static final char[] hexDigits;

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return MD5hexDigits[d1] + MD5hexDigits[d2];
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(MD5Coder.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    public static byte[] encodeBytes(byte[] bytes) {
        byte[] result = null;
        try {
            result = MD.digest(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String encodeString(String originString) {
        if (originString != null) {
            try {
                byte[] results = MD.digest(originString.getBytes());
                String resultString = MD5Coder.byteArrayToHexString(results);
                return resultString;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static final String getMD5Code_64(String content) {
        if (content == null) {
            content = "";
        }
        byte[] tmp = MD5Coder.getMD5ByteArray(content);
        long h = (long)tmp[0] & LONGARRAY[0] | (long)tmp[1] << 8 & LONGARRAY[1] | (long)tmp[2] << 16 & LONGARRAY[2] | (long)tmp[3] << 24 & LONGARRAY[3] | (long)tmp[4] << 32 & LONGARRAY[4] | (long)tmp[5] << 40 & LONGARRAY[5] | (long)tmp[6] << 48 & LONGARRAY[6] | (long)tmp[7] << 56;
        long l = (long)tmp[8] & LONGARRAY[0] | (long)tmp[9] << 8 & LONGARRAY[1] | (long)tmp[10] << 16 & LONGARRAY[2] | (long)tmp[11] << 24 & LONGARRAY[3] | (long)tmp[12] << 32 & LONGARRAY[4] | (long)tmp[13] << 40 & LONGARRAY[5] | (long)tmp[14] << 48 & LONGARRAY[6] | (long)tmp[15] << 56;
        return MD5Coder.getCode64(h, l);
    }

    public static final String getMD5Code_16(String content) {
        if (content == null) {
            content = "";
        }
        byte[] tmp = MD5Coder.getMD5ByteArray(content);
        char[] str = new char[32];
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            byte byte0 = tmp[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return String.valueOf(str);
    }

    private static String getCode64(long h, long l) {
        char[] re = new char[22];
        long blk = 63L;
        long tail = 3L;
        re[0] = hexDigits[(int)(l & blk)];
        re[1] = hexDigits[(int)((l & blk << 6) >>> 6)];
        re[2] = hexDigits[(int)((l & blk << 12) >>> 12)];
        re[3] = hexDigits[(int)((l & blk << 18) >>> 18)];
        re[4] = hexDigits[(int)((l & blk << 24) >>> 24)];
        re[5] = hexDigits[(int)((l & blk << 30) >>> 30)];
        re[6] = hexDigits[(int)((l & blk << 36) >>> 36)];
        re[7] = hexDigits[(int)((l & blk << 42) >>> 42)];
        re[8] = hexDigits[(int)((l & blk << 48) >>> 48)];
        re[9] = hexDigits[(int)((l & blk << 52) >>> 54)];
        re[10] = hexDigits[(int)((h & tail) << 4 | (l & blk << 60) >>> 60)];
        re[11] = hexDigits[(int)((h & blk << 2) >>> 2)];
        re[12] = hexDigits[(int)((h & blk << 8) >>> 8)];
        re[13] = hexDigits[(int)((h & blk << 14) >>> 14)];
        re[14] = hexDigits[(int)((h & blk << 20) >>> 20)];
        re[15] = hexDigits[(int)((h & blk << 26) >>> 26)];
        re[16] = hexDigits[(int)((h & blk << 32) >>> 32)];
        re[17] = hexDigits[(int)((h & blk << 38) >>> 38)];
        re[18] = hexDigits[(int)((h & blk << 44) >>> 44)];
        re[19] = hexDigits[(int)((h & blk << 50) >>> 50)];
        re[20] = hexDigits[(int)((h & blk << 56) >>> 56)];
        re[21] = hexDigits[(int)((h & blk << 62) >>> 62)];
        return String.valueOf(re);
    }

    private static byte[] getMD5ByteArray(String content) {
        byte[] source = null;
        MessageDigest md = null;
        try {
            source = content.getBytes("UTF-8");
            md = MessageDigest.getInstance("MD5");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(source);
        return md.digest();
    }

    static {
        try {
            MD = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            // empty catch block
        }
        MD5hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        LONGARRAY = new long[]{255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0L};
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '$', '@'};
    }
}

