/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.encryption;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;

public class Bytes {
    public static final boolean BIG_ENDIAN = false;
    public static final boolean LITTLE_ENDIAN = true;
    public static final byte[] EMPTY_BYTES = new byte[0];
    private static final char[] HEX_UPPER_CHAR = "0123456789ABCDEF".toCharArray();
    private static final char[] HEX_LOWER_CHAR = "0123456789abcdef".toCharArray();
    private static final byte[] HEX_DECODE_CHAR = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static Random random = new Random();
    private static SecureRandom secureRandom = new SecureRandom();

    public static byte[] fromHex(String hex) {
        char[] c = hex.toCharArray();
        byte[] b = new byte[c.length / 2];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(HEX_DECODE_CHAR[c[i * 2] & 0xFF] * 16 + HEX_DECODE_CHAR[c[i * 2 + 1] & 0xFF]);
        }
        return b;
    }

    private static String toHex(byte[] b, int off, int len, char[] hexChar) {
        char[] c = new char[len * 2];
        for (int i = 0; i < len; ++i) {
            byte n = b[off + i];
            c[i * 2] = hexChar[(n & 0xF0) >>> 4];
            c[i * 2 + 1] = hexChar[n & 0xF];
        }
        return new String(c);
    }

    public static String toHexUpper(byte[] b) {
        return Bytes.toHexUpper(b, 0, b.length);
    }

    public static String toHexUpper(byte[] b, int off, int len) {
        return Bytes.toHex(b, off, len, HEX_UPPER_CHAR);
    }

    public static String toHexLower(byte[] b) {
        return Bytes.toHexLower(b, 0, b.length);
    }

    public static String toHexLower(byte[] b, int off, int len) {
        return Bytes.toHex(b, off, len, HEX_LOWER_CHAR);
    }

    public static byte[] fromShort(int n) {
        return Bytes.fromShort(n, false);
    }

    public static byte[] fromShort(int n, boolean bLittleEndian) {
        byte[] b = new byte[2];
        Bytes.setShort(n, b, 0, bLittleEndian);
        return b;
    }

    public static void setShort(int n, byte[] b, int off) {
        Bytes.setShort(n, b, off, false);
    }

    public static void setShort(int n, byte[] b, int off, boolean bLittleEndian) {
        if (bLittleEndian) {
            b[off] = (byte)n;
            b[off + 1] = (byte)(n >>> 8);
        } else {
            b[off] = (byte)(n >>> 8);
            b[off + 1] = (byte)n;
        }
    }

    public static byte[] fromInt(int n) {
        return Bytes.fromInt(n, false);
    }

    public static byte[] fromInt(int n, boolean bLittleEndian) {
        byte[] b = new byte[4];
        Bytes.setInt(n, b, 0, bLittleEndian);
        return b;
    }

    public static void setInt(int n, byte[] b, int off) {
        Bytes.setInt(n, b, off, false);
    }

    public static void setInt(int n, byte[] b, int off, boolean bLittleEndian) {
        if (bLittleEndian) {
            b[off] = (byte)n;
            b[off + 1] = (byte)(n >>> 8);
            b[off + 2] = (byte)(n >>> 16);
            b[off + 3] = (byte)(n >>> 24);
        } else {
            b[off] = (byte)(n >>> 24);
            b[off + 1] = (byte)(n >>> 16);
            b[off + 2] = (byte)(n >>> 8);
            b[off + 3] = (byte)n;
        }
    }

    public static byte[] fromLong(long n) {
        return Bytes.fromLong(n, false);
    }

    public static byte[] fromLong(long n, boolean bLittleEndian) {
        byte[] b = new byte[8];
        Bytes.setLong(n, b, 0, bLittleEndian);
        return b;
    }

    public static void setLong(long n, byte[] b, int off) {
        Bytes.setLong(n, b, off, false);
    }

    public static void setLong(long n, byte[] b, int off, boolean bLittleEndian) {
        if (bLittleEndian) {
            Bytes.setInt((int)n, b, off, true);
            Bytes.setInt((int)(n >>> 32), b, off + 4, true);
        } else {
            Bytes.setInt((int)(n >>> 32), b, off, false);
            Bytes.setInt((int)n, b, off + 4, false);
        }
    }

    public static int toShort(byte[] b) {
        return Bytes.toShort(b, 0);
    }

    public static int toShort(byte[] b, boolean bLittleEndian) {
        return Bytes.toShort(b, 0, bLittleEndian);
    }

    public static int toShort(byte[] b, int off) {
        return Bytes.toShort(b, off, false);
    }

    public static int toShort(byte[] b, int off, boolean bLittleEndian) {
        if (bLittleEndian) {
            return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
        }
        return (b[off] & 0xFF) << 8 | b[off + 1] & 0xFF;
    }

    public static int toInt(byte[] b) {
        return Bytes.toInt(b, 0);
    }

    public static int toInt(byte[] b, boolean bLittleEndian) {
        return Bytes.toInt(b, 0, bLittleEndian);
    }

    public static int toInt(byte[] b, int off) {
        return Bytes.toInt(b, off, false);
    }

    public static int toInt(byte[] b, int off, boolean bLittleEndian) {
        if (bLittleEndian) {
            return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8 | (b[off + 2] & 0xFF) << 16 | (b[off + 3] & 0xFF) << 24;
        }
        return (b[off] & 0xFF) << 24 | (b[off + 1] & 0xFF) << 16 | (b[off + 2] & 0xFF) << 8 | b[off + 3] & 0xFF;
    }

    public static long toLong(byte[] b) {
        return Bytes.toLong(b, 0);
    }

    public static long toLong(byte[] b, boolean bLittleEndian) {
        return Bytes.toLong(b, 0, bLittleEndian);
    }

    public static long toLong(byte[] b, int off) {
        return Bytes.toLong(b, off, false);
    }

    public static long toLong(byte[] b, int off, boolean bLittleEndian) {
        if (bLittleEndian) {
            return (long)Bytes.toInt(b, off, true) & 0xFFFFFFFFL | ((long)Bytes.toInt(b, off + 4, true) & 0xFFFFFFFFL) << 32;
        }
        return ((long)Bytes.toInt(b, off, false) & 0xFFFFFFFFL) << 32 | (long)Bytes.toInt(b, off + 4, false) & 0xFFFFFFFFL;
    }

    public static byte[] fromBigInteger(BigInteger bi, int len) {
        byte[] b = bi.toByteArray();
        byte[] result = new byte[len];
        if (b.length < len) {
            for (int i = 0; i < len - b.length; ++i) {
                result[i] = 0;
            }
            System.arraycopy(b, 0, result, len - b.length, b.length);
        } else {
            System.arraycopy(b, b.length - len, result, 0, len);
        }
        return result;
    }

    @Deprecated
    public static byte[] encodeLatin1(String str) {
        char[] c = str.toCharArray();
        byte[] b = new byte[c.length];
        for (int i = 0; i < c.length; ++i) {
            b[i] = (byte)c[i];
        }
        return b;
    }

    @Deprecated
    public static String decodeLatin1(byte[] b) {
        return Bytes.decodeLatin1(b, 0, b.length);
    }

    @Deprecated
    public static String decodeLatin1(byte[] b, int off, int len) {
        char[] c = new char[len];
        for (int i = 0; i < len; ++i) {
            c[i] = (char)b[off + i];
        }
        return new String(c);
    }

    @Deprecated
    public static byte[] encodeUtf8(String str) {
        char[] c = str.toCharArray();
        byte[] b = new byte[c.length * 3];
        int len = 0;
        for (int i = 0; i < c.length; ++i) {
            char n = c[i];
            if (n < '\u0080') {
                b[len] = (byte)n;
                ++len;
                continue;
            }
            if (n < '\u07ff') {
                b[len] = (byte)(n >> 6 | 0xC0);
                b[++len] = (byte)(n & 0x3F | 0x80);
                ++len;
                continue;
            }
            b[len] = (byte)(n >> 12 | 0xE0);
            b[++len] = (byte)(n >> 6 & 0x3F | 0x80);
            b[++len] = (byte)(n & 0x3F | 0x80);
            ++len;
        }
        return Bytes.sub(b, 0, len);
    }

    @Deprecated
    public static String decodeUtf8(byte[] b) {
        return Bytes.decodeUtf8(b, 0, b.length);
    }

    @Deprecated
    public static String decodeUtf8(byte[] b, int off, int len) {
        char[] c = new char[len];
        int length = 0;
        for (int i = 0; i < len; ++i) {
            int n = b[off + i] & 0xFF;
            if (n < 128) {
                c[length] = (char)n;
                ++length;
                continue;
            }
            if (n < 192) {
                c[length] = 63;
                ++length;
                continue;
            }
            if (n < 224) {
                if (i + 1 < len) {
                    c[length] = (char)((n & 0x1F) << 6 | b[off + i + 1] & 0x3F);
                    ++length;
                    ++i;
                    continue;
                }
                c[length] = 63;
                ++length;
                continue;
            }
            if (i + 2 < len) {
                c[length] = (char)((n & 0xF) << 12 | (b[off + i + 1] & 0x3F) << 6 | b[off + i + 2] & 0x3F);
                ++length;
                i += 2;
                continue;
            }
            c[length] = 63;
            ++length;
        }
        return new String(c, 0, length);
    }

    public static byte[] add(byte[] b1, int off1, int len1, byte[] b2, int off2, int len2) {
        byte[] b = new byte[len1 + len2];
        System.arraycopy(b1, off1, b, 0, len1);
        System.arraycopy(b2, off2, b, len1, len2);
        return b;
    }

    public static byte[] add(byte[] ... b) {
        int nLen = 0;
        for (int i = 0; i < b.length; ++i) {
            nLen += b[i].length;
        }
        byte[] lp = new byte[nLen];
        nLen = 0;
        for (int i = 0; i < b.length; ++i) {
            byte[] lpi = b[i];
            System.arraycopy(lpi, 0, lp, nLen, lpi.length);
            nLen += lpi.length;
        }
        return lp;
    }

    public static byte[] clone(byte[] b) {
        return Bytes.sub(b, 0, b.length);
    }

    public static byte[] left(byte[] b, int len) {
        return Bytes.sub(b, 0, len);
    }

    public static byte[] right(byte[] b, int len) {
        return Bytes.sub(b, b.length - len, len);
    }

    public static byte[] sub(byte[] b, int off) {
        return Bytes.sub(b, off, b.length - off);
    }

    public static byte[] sub(byte[] b, int off, int len) {
        byte[] result = new byte[len];
        System.arraycopy(b, off, result, 0, len);
        return result;
    }

    public static boolean equals(byte[] b1, int off1, byte[] b2, int off2, int len) {
        if (b1 == b2 && off1 == off2) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (b1[off1 + i] == b2[off2 + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] b1, byte[] b2) {
        return b1.length == b2.length && Bytes.equals(b1, 0, b2, 0, b1.length);
    }

    private static byte[] random(int len, Random random_) {
        byte[] result = new byte[len];
        random_.nextBytes(result);
        return result;
    }

    public static byte[] random(int len) {
        return Bytes.random(len, random);
    }

    public static byte[] secureRandom(int len) {
        return Bytes.random(len, secureRandom);
    }

    private static String dumpLine(byte[] b, int offDiv16, int begin, int end) {
        char[] lpLine = "                                                                             ".toCharArray();
        lpLine[0] = HEX_UPPER_CHAR[offDiv16 >>> 24 & 0xF];
        lpLine[1] = HEX_UPPER_CHAR[offDiv16 >>> 20 & 0xF];
        lpLine[2] = HEX_UPPER_CHAR[offDiv16 >>> 16 & 0xF];
        lpLine[3] = HEX_UPPER_CHAR[offDiv16 >>> 12 & 0xF];
        lpLine[4] = 58;
        lpLine[5] = HEX_UPPER_CHAR[offDiv16 >>> 8 & 0xF];
        lpLine[6] = HEX_UPPER_CHAR[offDiv16 >>> 4 & 0xF];
        lpLine[7] = HEX_UPPER_CHAR[offDiv16 & 0xF];
        lpLine[8] = 48;
        for (int i = 0; i < 16; ++i) {
            if (i < begin || i >= end) continue;
            byte bInt = b[offDiv16 * 16 + i];
            lpLine[i * 3 + 11] = HEX_UPPER_CHAR[(bInt & 0xF0) >> 4];
            lpLine[i * 3 + 12] = HEX_UPPER_CHAR[bInt & 0xF];
            lpLine[61 + i] = bInt >= 32 && bInt < 127 ? (int)bInt : 46;
        }
        if (begin < 8 && end > 8) {
            lpLine[34] = 45;
        }
        return new String(lpLine);
    }

    public static void dump(PrintStream out, byte[] b, int off, int len) {
        int offDiv16 = off / 16;
        int end = off + len;
        int endDiv16 = end / 16;
        if (offDiv16 == endDiv16) {
            out.println(Bytes.dumpLine(b, offDiv16, off % 16, end % 16));
        } else {
            out.println(Bytes.dumpLine(b, offDiv16, off % 16, 16));
            for (int i = offDiv16 + 1; i < endDiv16; ++i) {
                out.println(Bytes.dumpLine(b, i, 0, 16));
            }
            if (end % 16 > 0) {
                out.println(Bytes.dumpLine(b, endDiv16, 0, end % 16));
            }
        }
    }

    public static void dump(PrintStream out, byte[] b) {
        Bytes.dump(out, b, 0, b.length);
    }

    public static void dump(PrintWriter out, byte[] b, int off, int len) {
        int offDiv16 = off / 16;
        int end = off + len;
        int endDiv16 = end / 16;
        if (offDiv16 == endDiv16) {
            out.println(Bytes.dumpLine(b, offDiv16, off % 16, end % 16));
        } else {
            out.println(Bytes.dumpLine(b, offDiv16, off % 16, 16));
            for (int i = offDiv16 + 1; i < endDiv16; ++i) {
                out.println(Bytes.dumpLine(b, i, 0, 16));
            }
            if (end % 16 > 0) {
                out.println(Bytes.dumpLine(b, endDiv16, 0, end % 16));
            }
        }
    }

    public static void dump(PrintWriter out, byte[] b) {
        Bytes.dump(out, b, 0, b.length);
    }

    public static void xor(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            int n = destPos + i;
            dest[n] = (byte)(dest[n] ^ src[srcPos + i]);
        }
    }

    public static void xor(byte[] src1, int src1Pos, byte[] src2, int src2Pos, byte[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            dest[destPos + i] = (byte)(src1[src1Pos + i] ^ src2[src2Pos + i]);
        }
    }
}

