/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.encryption;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class ByteArrayQueue
implements Cloneable {
    private byte[] array;
    private int offset = 0;
    private int length = 0;

    public ByteArrayQueue clone() {
        return new ByteArrayQueue(this.array, this.offset, this.length);
    }

    private ByteArrayQueue(byte[] array, int offset, int length) {
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    public ByteArrayQueue() {
        this(32);
    }

    public ByteArrayQueue(int capacity) {
        this.array = new byte[capacity];
    }

    public byte[] array() {
        return this.array;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public void clear() {
        this.offset = 0;
        this.length = 0;
        if (this.array.length > 1024) {
            this.array = new byte[32];
        }
    }

    public void setCapacity(int capacity) {
        byte[] newArray = new byte[Math.max(capacity, this.length)];
        System.arraycopy(this.array, this.offset, newArray, 0, this.length);
        this.array = newArray;
        this.offset = 0;
    }

    public ByteArrayQueue add(byte[] b) {
        return this.add(b, 0, b.length);
    }

    public ByteArrayQueue add(byte[] b, int off, int len) {
        int newLength = this.length + len;
        if (newLength > this.array.length) {
            this.setCapacity(Math.max(this.array.length << 1, newLength));
        } else if (this.offset + newLength > this.array.length) {
            System.arraycopy(this.array, this.offset, this.array, 0, this.length);
            this.offset = 0;
        }
        System.arraycopy(b, off, this.array, this.offset + this.length, len);
        this.length = newLength;
        return this;
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public void write(byte[] b, int off, int len) {
                ByteArrayQueue.this.add(b, off, len);
            }
        };
    }

    public ByteArrayQueue remove(byte[] b) {
        return this.remove(b, 0, b.length);
    }

    public ByteArrayQueue remove(byte[] b, int off, int len) {
        System.arraycopy(this.array, this.offset, b, off, len);
        return this.remove(len);
    }

    public ByteArrayQueue remove(int len) {
        this.offset += len;
        this.length -= len;
        if (this.length == 0 && this.array.length > 1024) {
            this.array = new byte[32];
            this.offset = 0;
        }
        return this;
    }

    public InputStream getInputStream() {
        return new InputStream(){

            @Override
            public int read() {
                byte[] b = new byte[]{0};
                if (this.read(b, 0, 1) <= 0) {
                    return -1;
                }
                return b[0] & 0xFF;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                if (ByteArrayQueue.this.length() == 0) {
                    return -1;
                }
                int bytesToRead = Math.min(len, ByteArrayQueue.this.length());
                ByteArrayQueue.this.remove(b, off, bytesToRead);
                return bytesToRead;
            }

            @Override
            public int available() {
                return ByteArrayQueue.this.length();
            }
        };
    }

    public String toString() {
        return new String(this.array, this.offset, this.length);
    }

    public String toString(Charset charset) {
        return new String(this.array, this.offset, this.length, charset);
    }

    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.array, this.offset, this.length, charsetName);
    }
}

