/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.encryption;

public class BinaryCoder {
    public static final int BYTE_BYTES = 1;
    public static final int SHORT_BYTES = 2;
    public static final int INT_BYTES = 4;
    public static final int LONG_BYTES = 8;

    public static String transDataToHexString(long b, int size) {
        int i;
        StringBuffer result = new StringBuffer();
        int charSize = size * 2;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < charSize; ++i) {
            long curr = b >> (charSize - i - 1) * 4;
            sb.append(Long.toHexString(curr &= 0xFL).toUpperCase());
        }
        for (i = sb.length(); i < charSize; i += 4) {
            sb.append("0");
        }
        result.append(sb.toString());
        return result.toString();
    }

    public static String transByteStreamToHexString(byte[] byteStream) {
        StringBuilder rtn = new StringBuilder();
        for (byte b : byteStream) {
            rtn.append(BinaryCoder.transDataToHexString(b, 1)).append(" ");
        }
        return rtn.toString();
    }

    public static int encodeBigEndian(byte[] byteStream, int offset, long data, int dataSize) {
        for (int i = 0; i < dataSize; ++i) {
            byteStream[offset++] = (byte)(data >> (dataSize - i - 1) * 8);
        }
        return offset;
    }

    public static long decodeBigEndian(byte[] byteStream, int offset, int dataSize) {
        long data = 0L;
        for (int i = 0; i < dataSize; ++i) {
            data = data << 8 | (long)byteStream[offset + i] & 0xFFL;
        }
        return data;
    }
}

