/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.management.RuntimeErrorException;

public class ShellUtil {
    private StreamHandler outHandler;
    private StreamHandler errHandler;

    public ShellUtil() {
        DefaultStreamHandler s = new DefaultStreamHandler();
        this.outHandler = s;
        this.errHandler = s;
    }

    public ShellUtil(StreamHandler out, StreamHandler err) {
        this.outHandler = out;
        this.errHandler = err;
    }

    public void setStdoutCallback(StreamHandler stdoutCallback) {
        this.outHandler = stdoutCallback;
    }

    public void setStderrCallback(StreamHandler stderrCallback) {
        this.errHandler = stderrCallback;
    }

    private SysExecResult callSystem(String[] script, String[] envp, File dir) throws IOException, InterruptedException {
        SysExecResult result = new SysExecResult();
        Process ps = Runtime.getRuntime().exec(script, envp, dir);
        result.setOut(this.outHandler.trans(ps.getInputStream()));
        result.setErr(this.errHandler.trans(ps.getErrorStream()));
        result.setExitValue(ps.waitFor());
        return result;
    }

    public SysExecResult runBashScript(String script, String[] envp, File dir) throws IOException, InterruptedException {
        return this.callSystem(new String[]{"/bin/bash", "-c", script}, envp, dir);
    }

    public SysExecResult runBashScriptPopWin(String script, String[] envp, File dir, String termParam) throws IOException, InterruptedException {
        termParam = termParam == null ? "xterm -e " : termParam;
        return this.callSystem(new String[]{"/bin/bash", "-c", termParam + script}, envp, dir);
    }

    public SysExecResult runWinCmd(String script, String[] envp, File dir) throws IOException, InterruptedException {
        return this.callSystem(new String[]{"cmd", "/C", script}, envp, dir);
    }

    public SysExecResult runWinCmdPopWin(String script, String[] envp, File dir) throws IOException, InterruptedException {
        return this.callSystem(new String[]{"cmd", "/C", "start " + script}, envp, dir);
    }

    public String transInStream2String(InputStream inStream) throws IOException {
        Charset charset = Charset.forName(System.getProperty("file.encoding"));
        return ShellUtil.transInStream2String(inStream, charset);
    }

    public static String transInStream2String(InputStream stream, Charset charset) throws IOException {
        String line;
        String result = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, charset));
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
        }
        result = sb.toString();
        return result;
    }

    public class SysExecResult {
        private int exitValue = 0;
        private Object out;
        private Object err;

        public int getExitValue() {
            return this.exitValue;
        }

        public void setExitValue(int exitValue) {
            this.exitValue = exitValue;
        }

        public Object getOut() {
            return this.out;
        }

        public void setOut(Object stdout) {
            this.out = stdout;
        }

        public Object getErr() {
            return this.err;
        }

        public void setErr(Object stderr) {
            this.err = stderr;
        }
    }

    public class DefaultStreamHandler
    implements StreamHandler {
        private Charset charset = null;

        public DefaultStreamHandler() {
            this.charset = Charset.forName(System.getProperty("file.encoding"));
        }

        public DefaultStreamHandler(String encoding) {
            this.charset = Charset.forName(encoding);
        }

        @Override
        public Object trans(InputStream stream) throws RuntimeException {
            String result = null;
            try {
                result = ShellUtil.transInStream2String(stream, this.charset);
            }
            catch (IOException e) {
                throw new RuntimeErrorException(new Error(e));
            }
            return result;
        }
    }

    public static interface StreamHandler {
        public Object trans(InputStream var1);
    }
}

