/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.DirectoryWalker;

public class FileOperater {
    public static void writeFile(String path, String fileName, File file) throws IOException {
        File fileDir = new File(path);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        FileOperater.writeToStream(path + fileName, new FileInputStream(file));
    }

    public static void writeFile(String path, String fileName, InputStream inputStream) throws IOException {
        File fileDir = new File(path);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        FileOperater.writeToStream(path + fileName, inputStream);
    }

    private static void writeToStream(String fileName, InputStream inputStream) throws IOException {
        File file = new File(fileName);
        File parentDir = file.getParentFile();
        if (parentDir.exists() && parentDir.isFile()) {
            parentDir.delete();
            parentDir.mkdirs();
        } else if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(file);
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inputStream.read(buffer)) > 0) {
            fos.write(buffer, 0, len);
        }
        fos.close();
        inputStream.close();
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.isFile() && file.exists()) {
            file.delete();
        }
    }

    public void deleteDirectory(String dir) throws IOException {
        File[] files;
        File dirFile;
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if ((dirFile = new File(dir)).exists() && dirFile.isDirectory() && null != (files = dirFile.listFiles())) {
            for (File file : files) {
                if (file.isFile()) {
                    FileOperater.deleteFile(file.getAbsolutePath());
                    continue;
                }
                this.deleteDirectory(file.getAbsolutePath());
            }
        }
    }

    private void startWalker(File rootPath, FileFilter filter, FileProcesser processer) throws IOException {
        MyDirectoryWalker w = new MyDirectoryWalker(filter, processer);
        w.start(rootPath);
    }

    public static void processEachFile(File rootPath, FileFilter filter, FileProcesser processer) throws IOException {
        new FileOperater().startWalker(rootPath, filter, processer);
    }

    public static byte[] readStream(InputStream is) throws IOException {
        byte[] result = null;
        byte[] buffer = new byte[1024];
        int size = is.read(buffer);
        while (size > 0) {
            if (result == null) {
                result = new byte[size];
                System.arraycopy(buffer, 0, result, 0, size);
            } else {
                byte[] tmp = new byte[result.length + size];
                System.arraycopy(result, 0, tmp, 0, result.length);
                System.arraycopy(buffer, 0, tmp, result.length, size);
                result = tmp;
            }
            size = is.read(buffer);
        }
        return result;
    }

    public static byte[] gZip(byte[] data) {
        byte[] b = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            byte[] buf = new byte[1024];
            int num = -1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzipos = new GZIPOutputStream(baos);
            while ((num = bis.read(buf, 0, buf.length)) != -1) {
                gzipos.write(buf, 0, num);
            }
            gzipos.finish();
            gzipos.flush();
            baos.flush();
            b = baos.toByteArray();
            gzipos.close();
            baos.close();
            bis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public static byte[] unGZip(byte[] data) {
        byte[] b = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            GZIPInputStream gzip = new GZIPInputStream(bis);
            byte[] buf = new byte[1024];
            int num = -1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((num = gzip.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, num);
            }
            b = baos.toByteArray();
            baos.flush();
            baos.close();
            gzip.close();
            bis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    private class MyDirectoryWalker
    extends DirectoryWalker<Object> {
        FileFilter filter = null;
        FileProcesser processer = null;

        public MyDirectoryWalker(FileFilter filter, FileProcesser processer) {
            this.filter = filter;
            this.processer = processer;
        }

        protected void handleFile(File file, int depth, Collection<Object> results) throws IOException {
            if (this.filter.accept(file)) {
                this.processer.process(file);
            }
        }

        public void start(File rootPath) throws IOException {
            this.walk(rootPath, null);
        }
    }

    public static interface FileProcesser {
        public void process(File var1) throws IOException;
    }
}

