/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.base;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class BeanUtils {
    public static Object getFieldValue(Object bean, String fieldName) throws Exception {
        String getterName = new StringBuffer("get").append(fieldName.substring(0, 1).toUpperCase()).append(fieldName.substring(1)).toString();
        return bean.getClass().getDeclaredMethod(getterName, new Class[0]).invoke(bean, new Object[0]);
    }

    public static void copyField(Object srcBean, Object tagBean, Class<?> fieldType, String fieldName) throws Exception {
        String getterName = new StringBuffer("get").append(fieldName.substring(0, 1).toUpperCase()).append(fieldName.substring(1)).toString();
        String setterName = new StringBuffer("set").append(fieldName.substring(0, 1).toUpperCase()).append(fieldName.substring(1)).toString();
        Method setter = tagBean.getClass().getDeclaredMethod(setterName, fieldType);
        Method getter = srcBean.getClass().getDeclaredMethod(getterName, new Class[0]);
        setter.invoke(tagBean, getter.invoke(srcBean, new Object[0]));
    }

    public static void copyBean(Object srcBean, Object tagBean) {
        try {
            BeanUtils.copyBean(srcBean, tagBean, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copyBean(Object srcBean, Object tagBean, boolean isSilent) throws Exception {
        Map<String, Method> getterMap = BeanUtils.getPropModifier(srcBean, true);
        Map<String, Method> setterMap = BeanUtils.getPropModifier(tagBean, false);
        BeanUtils.copyProps(srcBean, tagBean, getterMap, setterMap, getterMap.size() < setterMap.size(), isSilent);
    }

    private static void copyProps(Object srcBean, Object tagBean, Map<String, Method> getterMap, Map<String, Method> setterMap, boolean isLoopGetter, boolean isSilent) throws Exception {
        Map<String, Method> lopper = isLoopGetter ? getterMap : setterMap;
        for (Map.Entry<String, Method> t : lopper.entrySet()) {
            Method getter = getterMap.get(t.getKey());
            Method setter = setterMap.get(t.getKey());
            if (null == getter || null == setter) continue;
            try {
                if (null == getter.invoke(srcBean, new Object[0])) continue;
                setter.invoke(tagBean, getter.invoke(srcBean, new Object[0]));
            }
            catch (Exception e) {
                if (isSilent) continue;
                throw e;
            }
        }
    }

    private static Map<String, Method> getPropModifier(Object bean, boolean isGetter) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        for (Method m : bean.getClass().getMethods()) {
            String propLabel = "";
            String methodName = m.getName();
            if (methodName.startsWith(isGetter ? "get" : "set")) {
                propLabel = methodName.substring(3);
            }
            if (!StringUtils.isNotBlank((String)propLabel)) continue;
            result.put(propLabel, m);
        }
        return result;
    }
}

