/*
 * Decompiled with CFR 0.152.
 */
package net.itrixlabs.cache.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.itrixlabs.cache.config.CacheKey;
import net.itrixlabs.cache.config.CacheType;
import net.itrixlabs.cache.config.Key;
import net.itrixlabs.cache.core.ApplicationCache;
import net.itrixlabs.cache.util.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFileSystemCache<V>
implements ApplicationCache<Key, V>,
Serializable {
    private static final long serialVersionUID = 400L;
    private static final Log logger = LogFactory.getLog(AbstractFileSystemCache.class);
    private CacheType type;
    protected Long ttl = Key.DEFAULT_TTL;
    protected TimeUnit ttlUnit = Key.DEFAULT_TTL_TIMEUNIT;
    private String cacheDir;
    private String cacheFile;
    private String cacheLocation;
    protected final ConcurrentMap<Key, V> cache = new ConcurrentHashMap<Key, V>();

    public AbstractFileSystemCache() {
        throw new IllegalStateException("Can't invoke an application cache like this. Atleast type argument is required. Please use an appropriate constructor.");
    }

    public AbstractFileSystemCache(CacheType type) {
        this(type, System.getProperty("user.dir") + File.separatorChar + "temp" + File.separatorChar + "app_cache", type.toString() + ".ser");
    }

    public AbstractFileSystemCache(CacheType type, String cacheDir, String cacheFile) {
        this.type = type;
        this.cacheDir = cacheDir;
        this.cacheFile = cacheFile + ".ser";
        this.cacheLocation = cacheDir + File.separatorChar + cacheFile;
    }

    @Override
    public void initialize() {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.cacheLocation));){
            this.cache.putAll((Map)objectInputStream.readObject());
        }
        catch (FileNotFoundException e) {
            logger.info((Object)(this.type.toString() + " cache doesn't exist! Creating a brand new one."));
            File fileSystemCacheDir = new File(this.cacheDir);
            if (fileSystemCacheDir.exists()) {
                fileSystemCacheDir.setWritable(true);
            } else {
                fileSystemCacheDir.getParentFile().getParentFile().setWritable(true);
                fileSystemCacheDir.getParentFile().mkdirs();
                fileSystemCacheDir.getParentFile().setWritable(true);
                fileSystemCacheDir.mkdirs();
                fileSystemCacheDir.setWritable(true);
            }
            try {
                File file = new File(this.cacheLocation);
                FileOutputStream stream = new FileOutputStream(file);
                stream.write(0);
                stream.flush();
                stream.close();
            }
            catch (IOException ex) {
                logger.fatal((Object)ex.getMessage());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            if (e instanceof IOException) {
                logger.warn((Object)(this.type.toString() + " cache was tampered with!" + " Trust us, this is the last thing you want to do." + " By design, this cannot be done by an attacker." + " So, if it was a clean-up activity or a rougue administrator," + " you have been warned!"));
            }
            logger.error((Object)(this.type.toString() + " cache implementation has changed from last invocation." + " Delete the cache manually and re-create." + " Automatic recovery will be supported in future releases."));
        }
    }

    protected Key generate(Object identifier) {
        CacheKey key = new CacheKey();
        key.setKey(identifier);
        key.setCreationTime(System.currentTimeMillis());
        return key;
    }

    @Override
    public boolean isPresentInCache(Object key) {
        return this.cache.containsKey(this.generate(key));
    }

    @Override
    public void flush() {
        long ttlMillis = this.ttlUnit.toMillis(this.ttl);
        for (Key key : this.cache.keySet()) {
            if (key.getCreationTime() >= System.currentTimeMillis() - ttlMillis) continue;
            this.cache.remove(key);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.assertNotEmpty((Object)this.cacheDir, "A cache directory location is required.");
        Assert.assertNotEmpty((Object)this.cacheFile, "A cache filename is required.");
        Assert.assertNotNull((Object)this.type, "A cache type is required.");
        this.initialize();
    }

    public void destroy() throws Exception {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(new File(this.cacheLocation)));){
            objectOutputStream.writeObject(this.cache);
        }
        catch (IOException | NullPointerException e) {
            logger.info((Object)(this.cache + "Cache storage tampered/unreadable/unavailable!" + " Details weren't persisted to the storage." + " It is advisable to clean the cache directory."));
        }
    }

    public void setTtl(Long ttl, TimeUnit ttlUnit) {
        Assert.assertNotNull((Object)ttl, "Can't accept null as TTL.");
        Assert.assertNotNull((Object)ttlUnit, "Can't accept null as TTL TimeUnit.");
        this.ttl = ttl;
        this.ttlUnit = ttlUnit;
    }

    public void setCacheDir(String cacheDir) {
        Assert.assertNotEmpty((Object)cacheDir, "A cache directory location is required.");
        this.cacheDir = cacheDir;
    }

    public void setCacheFile(String cacheFile) {
        Assert.assertNotEmpty((Object)cacheFile, "A cache filename is required.");
        this.cacheFile = cacheFile;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public TimeUnit getTtlUnit() {
        return this.ttlUnit;
    }
}

