/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.face.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.iriscan.sdk.face.LivenessModelConfiguration;
import net.iriscan.sdk.tf.InterpreterImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0002JP\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f26\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0012H\u0002J(\u0010\u0018\u001a\u00060\nj\u0002`\u000b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0012\u0010\u0019\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\u0012\u0010\u001a\u001a\u00020\u001b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/iriscan/sdk/face/impl/FaceLivenessDetectionInternal;", "", "modelConfig", "Lnet/iriscan/sdk/face/LivenessModelConfiguration;", "(Lnet/iriscan/sdk/face/LivenessModelConfiguration;)V", "interpreter", "Lnet/iriscan/sdk/tf/InterpreterImpl;", "calculateScore", "", "image", "Ljava/awt/image/BufferedImage;", "Lnet/iriscan/sdk/core/image/NativeImage;", "normalize", "", "width", "", "height", "getColor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "x", "y", "Ljava/awt/Color;", "resizeKeepAspectRatio", "score", "validate", "", "biometric-sdk"})
@SourceDebugExtension(value={"SMAP\nFaceLivenessDetectionInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FaceLivenessDetectionInternal.kt\nnet/iriscan/sdk/face/impl/FaceLivenessDetectionInternal\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,75:1\n10242#2:76\n10664#2,5:77\n*S KotlinDebug\n*F\n+ 1 FaceLivenessDetectionInternal.kt\nnet/iriscan/sdk/face/impl/FaceLivenessDetectionInternal\n*L\n72#1:76\n72#1:77,5\n*E\n"})
public final class FaceLivenessDetectionInternal {
    @NotNull
    private final LivenessModelConfiguration modelConfig;
    @NotNull
    private final InterpreterImpl interpreter;

    public FaceLivenessDetectionInternal(@NotNull LivenessModelConfiguration modelConfig) {
        Intrinsics.checkNotNullParameter((Object)modelConfig, (String)"modelConfig");
        this.modelConfig = modelConfig;
        this.interpreter = new InterpreterImpl("liveness.tflite", this.modelConfig.getPath(), this.modelConfig.getModelChecksum(), this.modelConfig.getModelChecksumMethod(), this.modelConfig.getOverrideCacheOnWrongChecksum());
    }

    public final boolean validate(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.calculateScore(image) >= this.modelConfig.getThreshold();
    }

    public final double score(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.calculateScore(image);
    }

    private final double calculateScore(BufferedImage image) {
        BufferedImage resized = this.resizeKeepAspectRatio(image, this.modelConfig.getInputWidth(), this.modelConfig.getInputHeight());
        float[] data2 = this.normalize(resized.getWidth(), resized.getHeight(), (Function2<? super Integer, ? super Integer, ? extends Color>)((Function2)new Function2<Integer, Integer, Color>(resized){
            final /* synthetic */ BufferedImage $resized;
            {
                this.$resized = $resized;
                super(2);
            }

            @NotNull
            public final Color invoke(int x, int y) {
                return new Color(this.$resized.getRGB(x, y));
            }
        }));
        Map modelInputs = MapsKt.mapOf((Pair)TuplesKt.to((Object)0, (Object)data2));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)Float.valueOf(0.0f))};
        Map modelOutputs = MapsKt.mutableMapOf((Pair[])pairArray);
        this.interpreter.invoke(modelInputs, modelOutputs);
        Object v = modelOutputs.get(0);
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Float");
        return ((Float)v).floatValue();
    }

    private final BufferedImage resizeKeepAspectRatio(BufferedImage image, int width, int height) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        double aspectRatio = (double)imageWidth / (double)imageHeight;
        Pair pair = imageWidth > imageHeight ? TuplesKt.to((Object)width, (Object)((int)((double)width / aspectRatio))) : TuplesKt.to((Object)((int)((double)height * aspectRatio)), (Object)height);
        int newWidth = ((Number)pair.component1()).intValue();
        int newHeight = ((Number)pair.component2()).intValue();
        BufferedImage outputImage = new BufferedImage(width, height, 2);
        Graphics2D g = outputImage.createGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, width, height);
        int xPos = (width - newWidth) / 2;
        int yPos = (height - newHeight) / 2;
        g.drawImage(image.getScaledInstance(newWidth, newHeight, 4), xPos, yPos, null);
        g.dispose();
        return outputImage;
    }

    /*
     * WARNING - void declaration
     */
    private final float[] normalize(int width, int height, Function2<? super Integer, ? super Integer, ? extends Color> getColor) {
        void $this$flatMapTo$iv$iv;
        Object color;
        int n = 0;
        int n2 = width * height;
        float[][] fArrayArray = new float[n2][];
        while (n < n2) {
            int n3 = n++;
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
            fArrayArray[n3] = fArray;
        }
        float[][] rgb = fArrayArray;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                color = (Color)getColor.invoke((Object)x, (Object)y);
                int i = y * width + x;
                rgb[i][0] = (float)((Color)color).getRed() / 255.0f;
                rgb[i][1] = (float)((Color)color).getGreen() / 255.0f;
                rgb[i][2] = (float)((Color)color).getBlue() / 255.0f;
            }
        }
        Object[] $this$flatMap$iv = (Object[])rgb;
        boolean $i$f$flatMap = false;
        color = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            float[] it = (float[])element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList((float[])it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toFloatArray((Collection)((List)destination$iv$iv));
    }
}

