/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.tf;

import java.nio.ByteBuffer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.iriscan.sdk.core.io.HashMethod;
import net.iriscan.sdk.io.ResourceIOFactory;
import net.iriscan.sdk.tf.Interpreter;
import net.iriscan.sdk.tf.TfStatusHelperKt;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.tensorflowlite.BuiltinOpResolver;
import org.bytedeco.tensorflowlite.FlatBufferModel;
import org.bytedeco.tensorflowlite.InterpreterBuilder;
import org.bytedeco.tensorflowlite.OpResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ:\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/iriscan/sdk/tf/InterpreterImpl;", "Lnet/iriscan/sdk/tf/Interpreter;", "modelName", "", "modelPath", "modelChecksum", "modelChecksumMethod", "Lnet/iriscan/sdk/core/io/HashMethod;", "overrideCacheOnWrongChecksum", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lnet/iriscan/sdk/core/io/HashMethod;Ljava/lang/Boolean;)V", "model", "Lorg/bytedeco/javacpp/BytePointer;", "modelLen", "", "invoke", "", "inputs", "", "", "", "outputs", "", "traceId", "biometric-sdk"})
@SourceDebugExtension(value={"SMAP\nInterpreterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterpreterImpl.kt\nnet/iriscan/sdk/tf/InterpreterImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1855#2,2:79\n1855#2,2:81\n*S KotlinDebug\n*F\n+ 1 InterpreterImpl.kt\nnet/iriscan/sdk/tf/InterpreterImpl\n*L\n55#1:79,2\n62#1:81,2\n*E\n"})
public final class InterpreterImpl
implements Interpreter {
    @NotNull
    private final BytePointer model;
    private final long modelLen;

    public InterpreterImpl(@NotNull String modelName, @NotNull String modelPath, @Nullable String modelChecksum, @Nullable HashMethod modelChecksumMethod, @Nullable Boolean overrideCacheOnWrongChecksum) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)modelPath, (String)"modelPath");
        byte[] modelBytes = modelChecksum != null && modelChecksumMethod != null && overrideCacheOnWrongChecksum != null ? ResourceIOFactory.INSTANCE.getInstance().readOrCacheLoadData(modelName, modelPath, modelChecksum, modelChecksumMethod, overrideCacheOnWrongChecksum) : ResourceIOFactory.INSTANCE.getInstance().readOrCacheLoadData(modelName, modelPath);
        this.model = new BytePointer(ByteBuffer.wrap(modelBytes));
        this.modelLen = modelBytes.length;
    }

    @Override
    public void invoke(@NotNull Map<Integer, ? extends Object> inputs, @NotNull Map<Integer, Object> outputs, @Nullable String traceId) {
        int it;
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        org.bytedeco.tensorflowlite.Interpreter interpreter = new org.bytedeco.tensorflowlite.Interpreter(null);
        InterpreterBuilder modelBuilder = new InterpreterBuilder(FlatBufferModel.BuildFromBuffer((BytePointer)this.model, (long)this.modelLen), (OpResolver)new BuiltinOpResolver());
        modelBuilder.apply(interpreter, Runtime.getRuntime().availableProcessors());
        modelBuilder.close();
        interpreter.AllocateTensors();
        Iterable $this$forEach$iv = inputs.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = ((Number)element$iv).intValue();
            boolean bl = false;
            Object object = inputs.get(it);
            Intrinsics.checkNotNull((Object)object);
            float[] data2 = (float[])object;
            interpreter.typed_input_tensor_float(it).put(data2, 0, data2.length);
        }
        TfStatusHelperKt.tfIfErrorThrow(interpreter.Invoke(), "Could not invoke model");
        $this$forEach$iv = outputs.keySet();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object out;
            it = ((Number)element$iv).intValue();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)outputs.get(it));
            if (out instanceof Float) {
                Integer n = it;
                outputs.put(n, Float.valueOf(interpreter.typed_output_tensor_float(it).get()));
                continue;
            }
            if (!(out instanceof float[])) continue;
            interpreter.typed_output_tensor_float(it).get((float[])out);
        }
        interpreter.close();
    }
}

