/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.face.impl;

import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.iriscan.sdk.FaceConfig;
import net.iriscan.sdk.core.utils.LogUtilsKt;
import net.iriscan.sdk.face.FaceEncodeProperties;
import net.iriscan.sdk.face.FaceEncoder;
import net.iriscan.sdk.face.FaceExtractProperties;
import net.iriscan.sdk.face.FaceExtractor;
import net.iriscan.sdk.face.FaceLivenessDetection;
import net.iriscan.sdk.face.FaceLivenessDetectionProperties;
import net.iriscan.sdk.face.FaceMatchProperties;
import net.iriscan.sdk.face.FaceMatcher;
import net.iriscan.sdk.face.FaceOperations;
import net.iriscan.sdk.face.impl.FaceEncoderInternal;
import net.iriscan.sdk.face.impl.FaceExtractorInternal;
import net.iriscan.sdk.face.impl.FaceLivenessDetectionInternal;
import net.iriscan.sdk.face.impl.FaceMatcherImplKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/iriscan/sdk/face/impl/FaceOperationsImpl;", "Lnet/iriscan/sdk/face/FaceOperations;", "config", "Lnet/iriscan/sdk/FaceConfig;", "(Lnet/iriscan/sdk/FaceConfig;)V", "getConfig", "()Lnet/iriscan/sdk/FaceConfig;", "encoder", "Lnet/iriscan/sdk/face/FaceEncoder;", "extractor", "Lnet/iriscan/sdk/face/FaceExtractor;", "liveness", "Lnet/iriscan/sdk/face/FaceLivenessDetection;", "matcher", "Lnet/iriscan/sdk/face/FaceMatcher;", "biometric-sdk"})
public final class FaceOperationsImpl
implements FaceOperations {
    @NotNull
    private final FaceConfig config;
    @Nullable
    private final FaceExtractor extractor;
    @Nullable
    private final FaceEncoder encoder;
    @Nullable
    private final FaceMatcher matcher;
    @Nullable
    private final FaceLivenessDetection liveness;

    public FaceOperationsImpl(@NotNull FaceConfig config) {
        FaceLivenessDetection faceLivenessDetection;
        FaceMatcher faceMatcher;
        FaceEncoder faceEncoder;
        Object it;
        FaceExtractor faceExtractor;
        FaceOperationsImpl faceOperationsImpl;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        FaceOperationsImpl faceOperationsImpl2 = this;
        FaceExtractProperties faceExtractProperties = this.config.getExtractor();
        if (faceExtractProperties != null) {
            FaceExtractProperties faceExtractProperties2 = faceExtractProperties;
            faceOperationsImpl = faceOperationsImpl2;
            boolean bl = false;
            FaceExtractorInternal faceExtractorInternal = new FaceExtractorInternal();
            faceExtractor = new FaceExtractor(faceExtractorInternal){
                final /* synthetic */ FaceExtractorInternal $faceExtractorInternal;
                {
                    this.$faceExtractorInternal = $faceExtractorInternal;
                }

                @Nullable
                public BufferedImage extract(@NotNull BufferedImage nativeImage) {
                    Intrinsics.checkNotNullParameter((Object)nativeImage, (String)"nativeImage");
                    return FaceExtractorInternal.extract$default(this.$faceExtractorInternal, nativeImage, true, null, 4, null);
                }
            };
            faceOperationsImpl2 = faceOperationsImpl;
        } else {
            faceExtractor = null;
        }
        faceOperationsImpl2.extractor = faceExtractor;
        FaceOperationsImpl faceOperationsImpl3 = this;
        FaceEncodeProperties faceEncodeProperties = this.config.getEncoder();
        if (faceEncodeProperties != null) {
            it = faceEncodeProperties;
            faceOperationsImpl = faceOperationsImpl3;
            boolean bl = false;
            FaceEncoderInternal faceEncoderInternal = new FaceEncoderInternal(((FaceEncodeProperties)it).getTfModel());
            FaceExtractorInternal faceExtractorInternal = new FaceExtractorInternal();
            faceEncoder = new FaceEncoder(faceEncoderInternal, faceExtractorInternal){
                final /* synthetic */ FaceEncoderInternal $faceEncoderInternal;
                final /* synthetic */ FaceExtractorInternal $faceExtractorInternal;
                {
                    this.$faceEncoderInternal = $faceEncoderInternal;
                    this.$faceExtractorInternal = $faceExtractorInternal;
                }

                @NotNull
                public byte[] encode(@NotNull BufferedImage nativeImage) {
                    Intrinsics.checkNotNullParameter((Object)nativeImage, (String)"nativeImage");
                    return FaceEncoderInternal.encode$default(this.$faceEncoderInternal, nativeImage, null, 2, null);
                }

                @Nullable
                public byte[] extractAndEncode(@NotNull BufferedImage nativeImage) {
                    byte[] byArray;
                    Intrinsics.checkNotNullParameter((Object)nativeImage, (String)"nativeImage");
                    String traceId = LogUtilsKt.generateTraceID();
                    BufferedImage bufferedImage = this.$faceExtractorInternal.extract(nativeImage, true, traceId);
                    if (bufferedImage != null) {
                        BufferedImage bufferedImage2 = bufferedImage;
                        FaceEncoderInternal faceEncoderInternal = this.$faceEncoderInternal;
                        BufferedImage it = bufferedImage2;
                        boolean bl = false;
                        byArray = faceEncoderInternal.encode(it, traceId);
                    } else {
                        byArray = null;
                    }
                    return byArray;
                }
            };
            faceOperationsImpl3 = faceOperationsImpl;
        } else {
            faceEncoder = null;
        }
        faceOperationsImpl3.encoder = faceEncoder;
        FaceOperationsImpl faceOperationsImpl4 = this;
        FaceMatchProperties faceMatchProperties = this.config.getMatcher();
        if (faceMatchProperties != null) {
            it = faceMatchProperties;
            faceOperationsImpl = faceOperationsImpl4;
            boolean bl = false;
            faceMatcher = new FaceMatcher(this){
                final /* synthetic */ FaceOperationsImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean matches(@NotNull byte[] sample1, @NotNull byte[] sample2) {
                    Intrinsics.checkNotNullParameter((Object)sample1, (String)"sample1");
                    Intrinsics.checkNotNullParameter((Object)sample2, (String)"sample2");
                    return (double)FaceMatcherImplKt.matchFaceNetTemplatesInternal$default(sample1, sample2, null, 4, null) <= this.this$0.getConfig().getMatcher().getThreshold();
                }

                public boolean matchesAny(@NotNull byte[] sample1, @NotNull List<byte[]> samples) {
                    Intrinsics.checkNotNullParameter((Object)sample1, (String)"sample1");
                    Intrinsics.checkNotNullParameter(samples, (String)"samples");
                    Iterator<T> iterator = ((Iterable)samples).iterator();
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    byte[] it = (byte[])iterator.next();
                    boolean bl = false;
                    float f = FaceMatcherImplKt.matchFaceNetTemplatesInternal$default(sample1, it, null, 4, null);
                    while (iterator.hasNext()) {
                        byte[] it2 = (byte[])iterator.next();
                        $i$a$-minOf-FaceOperationsImpl$matcher$1$1$matchesAny$minScore$1 = false;
                        float f2 = FaceMatcherImplKt.matchFaceNetTemplatesInternal$default(sample1, it2, null, 4, null);
                        f = Math.min(f, f2);
                    }
                    float minScore = f;
                    return (double)minScore <= this.this$0.getConfig().getMatcher().getThreshold();
                }

                public double matchScore(@NotNull byte[] sample1, @NotNull byte[] sample2) {
                    Intrinsics.checkNotNullParameter((Object)sample1, (String)"sample1");
                    Intrinsics.checkNotNullParameter((Object)sample2, (String)"sample2");
                    return FaceMatcherImplKt.matchFaceNetTemplatesInternal$default(sample1, sample2, null, 4, null);
                }

                public double matchScoreMin(@NotNull byte[] sample1, @NotNull List<byte[]> samples) {
                    Intrinsics.checkNotNullParameter((Object)sample1, (String)"sample1");
                    Intrinsics.checkNotNullParameter(samples, (String)"samples");
                    Iterator<T> iterator = ((Iterable)samples).iterator();
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    byte[] it = (byte[])iterator.next();
                    boolean bl = false;
                    double d = FaceMatcherImplKt.matchFaceNetTemplatesInternal$default(sample1, it, null, 4, null);
                    while (iterator.hasNext()) {
                        byte[] it2 = (byte[])iterator.next();
                        $i$a$-minOf-FaceOperationsImpl$matcher$1$1$matchScoreMin$1 = false;
                        double d2 = FaceMatcherImplKt.matchFaceNetTemplatesInternal$default(sample1, it2, null, 4, null);
                        d = Math.min(d, d2);
                    }
                    return d;
                }
            };
            faceOperationsImpl4 = faceOperationsImpl;
        } else {
            faceMatcher = null;
        }
        faceOperationsImpl4.matcher = faceMatcher;
        FaceOperationsImpl faceOperationsImpl5 = this;
        FaceLivenessDetectionProperties faceLivenessDetectionProperties = this.config.getLiveness();
        if (faceLivenessDetectionProperties != null) {
            it = faceLivenessDetectionProperties;
            faceOperationsImpl = faceOperationsImpl5;
            boolean bl = false;
            FaceLivenessDetectionInternal livenessDetectorInternal = new FaceLivenessDetectionInternal(((FaceLivenessDetectionProperties)it).getTfModel());
            FaceExtractorInternal extractorInternal = new FaceExtractorInternal();
            faceLivenessDetection = new FaceLivenessDetection(livenessDetectorInternal, extractorInternal){
                final /* synthetic */ FaceLivenessDetectionInternal $livenessDetectorInternal;
                final /* synthetic */ FaceExtractorInternal $extractorInternal;
                {
                    this.$livenessDetectorInternal = $livenessDetectorInternal;
                    this.$extractorInternal = $extractorInternal;
                }

                public boolean validate(@NotNull BufferedImage nativeImage) {
                    Intrinsics.checkNotNullParameter((Object)nativeImage, (String)"nativeImage");
                    return FaceLivenessDetectionInternal.validate$default(this.$livenessDetectorInternal, nativeImage, null, 2, null);
                }

                @Nullable
                public Boolean extractAndValidate(@NotNull BufferedImage nativeImage) {
                    Boolean bl;
                    Intrinsics.checkNotNullParameter((Object)nativeImage, (String)"nativeImage");
                    String traceId = LogUtilsKt.generateTraceID();
                    BufferedImage bufferedImage = this.$extractorInternal.extract(nativeImage, false, traceId);
                    if (bufferedImage != null) {
                        BufferedImage bufferedImage2 = bufferedImage;
                        FaceLivenessDetectionInternal faceLivenessDetectionInternal = this.$livenessDetectorInternal;
                        BufferedImage it = bufferedImage2;
                        boolean bl2 = false;
                        bl = faceLivenessDetectionInternal.validate(it, traceId);
                    } else {
                        bl = null;
                    }
                    return bl;
                }

                public double score(@NotNull BufferedImage nativeImage) {
                    Intrinsics.checkNotNullParameter((Object)nativeImage, (String)"nativeImage");
                    return FaceLivenessDetectionInternal.score$default(this.$livenessDetectorInternal, nativeImage, null, 2, null);
                }

                public double extractAndScore(@NotNull BufferedImage nativeImage) {
                    double d;
                    Intrinsics.checkNotNullParameter((Object)nativeImage, (String)"nativeImage");
                    String traceId = LogUtilsKt.generateTraceID();
                    BufferedImage bufferedImage = this.$extractorInternal.extract(nativeImage, false, traceId);
                    if (bufferedImage != null) {
                        BufferedImage bufferedImage2 = bufferedImage;
                        FaceLivenessDetectionInternal faceLivenessDetectionInternal = this.$livenessDetectorInternal;
                        BufferedImage it = bufferedImage2;
                        boolean bl = false;
                        d = faceLivenessDetectionInternal.score(it, traceId);
                    } else {
                        d = -1.0;
                    }
                    return d;
                }
            };
            faceOperationsImpl5 = faceOperationsImpl;
        } else {
            faceLivenessDetection = null;
        }
        faceOperationsImpl5.liveness = faceLivenessDetection;
    }

    @NotNull
    public final FaceConfig getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public FaceExtractor extractor() {
        FaceExtractor faceExtractor = this.extractor;
        if (faceExtractor == null) {
            throw new IllegalStateException("Please initialize SDK with face extractor");
        }
        return faceExtractor;
    }

    @Override
    @NotNull
    public FaceEncoder encoder() {
        FaceEncoder faceEncoder = this.encoder;
        if (faceEncoder == null) {
            throw new IllegalStateException("Please initialize SDK with face encoder");
        }
        return faceEncoder;
    }

    @Override
    @NotNull
    public FaceMatcher matcher() {
        FaceMatcher faceMatcher = this.matcher;
        if (faceMatcher == null) {
            throw new IllegalStateException("Please initialize SDK with face matcher");
        }
        return faceMatcher;
    }

    @Override
    @NotNull
    public FaceLivenessDetection liveness() {
        FaceLivenessDetection faceLivenessDetection = this.liveness;
        if (faceLivenessDetection == null) {
            throw new IllegalStateException("Please initialize SDK with face liveness");
        }
        return faceLivenessDetection;
    }
}

