/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.face.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.iriscan.sdk.core.image.ColorKt;
import net.iriscan.sdk.core.image.Image;
import net.iriscan.sdk.core.image.ImageColorType;
import net.iriscan.sdk.core.utils.ImageUtilsKt;
import net.iriscan.sdk.core.utils.LogUtilsKt;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Point2f;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.RectVector;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_objdetect.CascadeClassifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ.\u0010\u0005\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r2\n\u0010\u0007\u001a\u00060\fj\u0002`\r2\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/iriscan/sdk/face/impl/FaceExtractorInternal;", "", "()V", "classifier", "Lorg/bytedeco/opencv/opencv_objdetect/CascadeClassifier;", "extract", "Lnet/iriscan/sdk/core/image/Image;", "image", "rotateOnWrongOrientation", "", "traceId", "", "Ljava/awt/image/BufferedImage;", "Lnet/iriscan/sdk/core/image/NativeImage;", "extractInternal", "biometric-sdk"})
@SourceDebugExtension(value={"SMAP\nFaceExtractorInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FaceExtractorInternal.kt\nnet/iriscan/sdk/face/impl/FaceExtractorInternal\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,87:1\n10269#2:88\n10697#2,5:89\n*S KotlinDebug\n*F\n+ 1 FaceExtractorInternal.kt\nnet/iriscan/sdk/face/impl/FaceExtractorInternal\n*L\n44#1:88\n44#1:89,5\n*E\n"})
public final class FaceExtractorInternal {
    @NotNull
    private final CascadeClassifier classifier;

    public FaceExtractorInternal() {
        Path classifierFile = new File(System.getProperty("java.io.tmpdir") + "/.biometric-sdk/haarcascade_frontalface_alt.xml").toPath();
        if (!Files.exists(classifierFile, new LinkOption[0])) {
            InputStream inputStream = this.getClass().getResourceAsStream("/haarcascade_frontalface_alt.xml");
            Intrinsics.checkNotNull((Object)inputStream);
            InputStream classifierXml = inputStream;
            Files.createDirectories(classifierFile.getParent(), new FileAttribute[0]);
            Files.copy(classifierXml, classifierFile, new CopyOption[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)classifierFile, (String)"classifierFile");
        this.classifier = new CascadeClassifier(((Object)classifierFile.toAbsolutePath()).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Image extract(@NotNull Image image, boolean rotateOnWrongOrientation, @Nullable String traceId) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        int[] $this$flatMap$iv = image.getColors();
        boolean $i$f$flatMap = false;
        int[] nArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Object[] objectArray = new Integer[]{ColorKt.red((int)it), ColorKt.green((int)it), ColorKt.blue((int)it)};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        int[] data2 = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        bufferedImage.getRaster().setPixels(0, 0, image.getWidth(), image.getHeight(), data2);
        BufferedImage bufferedImage2 = this.extractInternal(bufferedImage, rotateOnWrongOrientation);
        if (bufferedImage2 == null) {
            return null;
        }
        BufferedImage face = bufferedImage2;
        return ImageUtilsKt.createImg(face.getWidth(), face.getHeight(), ImageColorType.RGB, (Function2<? super Integer, ? super Integer, Integer>)((Function2)new Function2<Integer, Integer, Integer>(face){
            final /* synthetic */ BufferedImage $face;
            {
                this.$face = $face;
                super(2);
            }

            @NotNull
            public final Integer invoke(int x, int y) {
                Color rawColor = new Color(this.$face.getRGB(x, y));
                return ColorKt.createColor(rawColor.getRed(), rawColor.getGreen(), rawColor.getBlue());
            }
        }));
    }

    public static /* synthetic */ Image extract$default(FaceExtractorInternal faceExtractorInternal, Image image, boolean bl, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = LogUtilsKt.generateTraceID();
        }
        return faceExtractorInternal.extract(image, bl, string);
    }

    @Nullable
    public final BufferedImage extract(@NotNull BufferedImage image, boolean rotateOnWrongOrientation, @Nullable String traceId) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.extractInternal(image, rotateOnWrongOrientation);
    }

    public static /* synthetic */ BufferedImage extract$default(FaceExtractorInternal faceExtractorInternal, BufferedImage bufferedImage, boolean bl, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = LogUtilsKt.generateTraceID();
        }
        return faceExtractorInternal.extract(bufferedImage, bl, string);
    }

    private final BufferedImage extractInternal(BufferedImage image, boolean rotateOnWrongOrientation) {
        Rect rect;
        Mat input;
        block5: {
            block4: {
                DataBuffer dataBuffer = image.getRaster().getDataBuffer();
                Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferByte");
                byte[] data2 = ((DataBufferByte)dataBuffer).getData();
                input = new Mat(image.getHeight(), image.getWidth(), opencv_core.CV_8UC3, (Pointer)new BytePointer(Arrays.copyOf(data2, data2.length)));
                RectVector result2 = new RectVector();
                this.classifier.detectMultiScale(input, result2);
                Rect[] faces = result2.get();
                Intrinsics.checkNotNullExpressionValue((Object)faces, (String)"faces");
                if (faces.length == 0) {
                    return null;
                }
                rect = faces[0];
                int n = input.cols();
                int n2 = rect.x();
                boolean bl = 1 <= n2 ? n2 < n : false;
                if (!bl) break block4;
                n = input.cols();
                n2 = rect.x() + rect.width();
                boolean bl2 = 1 <= n2 ? n2 < n : false;
                if (!bl2) break block4;
                n = input.rows();
                n2 = rect.y();
                boolean bl3 = 1 <= n2 ? n2 < n : false;
                if (!bl3) break block4;
                n = input.rows();
                n2 = rect.y() + rect.height();
                if (1 <= n2 ? n2 < n : false) break block5;
            }
            return null;
        }
        Point2f center = new Point2f((float)((double)rect.x() + (double)rect.width() / 2.0), (float)((double)rect.y() + (double)rect.height() / 2.0));
        double angle = Math.atan2(rect.y(), rect.x() + rect.width()) * 180.0 / Math.PI;
        Mat rotationMatrix = opencv_imgproc.getRotationMatrix2D((Point2f)center, (double)angle, (double)1.0);
        Mat rotatedImage = new Mat();
        opencv_imgproc.warpAffine((Mat)input, (Mat)rotatedImage, (Mat)rotationMatrix, (Size)input.size());
        BytePointer bytes2 = new BytePointer();
        opencv_imgcodecs.imencode((String)".jpg", (Mat)rotatedImage, (BytePointer)bytes2);
        byte[] byteArray = bytes2.asByteBuffer().array();
        return ImageIO.read(new ByteArrayInputStream(byteArray));
    }
}

