/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.face.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.iriscan.sdk.core.image.ColorKt;
import net.iriscan.sdk.core.utils.ImageUtilsKt;
import net.iriscan.sdk.core.utils.LogUtilsKt;
import net.iriscan.sdk.face.FaceNetModelConfiguration;
import net.iriscan.sdk.tf.Interpreter;
import net.iriscan.sdk.tf.InterpreterImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\"\u0010\u0007\u001a\u00060\bj\u0002`\r2\n\u0010\t\u001a\u00060\u000ej\u0002`\u000f2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JP\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001526\u0010\u0017\u001a2\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001d0\u0018H\u0002J(\u0010\u001e\u001a\u00060\u000ej\u0002`\u000f2\n\u0010\t\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\f\u0010\u001f\u001a\u00020\b*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lnet/iriscan/sdk/face/impl/FaceEncoderInternal;", "", "faceNetModelConfig", "Lnet/iriscan/sdk/face/FaceNetModelConfiguration;", "(Lnet/iriscan/sdk/face/FaceNetModelConfiguration;)V", "interpreter", "Lnet/iriscan/sdk/tf/InterpreterImpl;", "encode", "", "image", "Lnet/iriscan/sdk/core/image/Image;", "traceId", "", "Lnet/iriscan/sdk/core/io/DataBytes;", "Ljava/awt/image/BufferedImage;", "Lnet/iriscan/sdk/core/image/NativeImage;", "encodeInternal", "data", "", "normalize", "width", "", "height", "getColor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "x", "y", "Ljava/awt/Color;", "resizeBillinear", "toByteArray", "biometric-sdk"})
@SourceDebugExtension(value={"SMAP\nFaceEncoderInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FaceEncoderInternal.kt\nnet/iriscan/sdk/face/impl/FaceEncoderInternal\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,90:1\n10242#2:91\n10664#2,5:92\n11385#2:97\n11720#2,3:98\n*S KotlinDebug\n*F\n+ 1 FaceEncoderInternal.kt\nnet/iriscan/sdk/face/impl/FaceEncoderInternal\n*L\n68#1:91\n68#1:92,5\n70#1:97\n70#1:98,3\n*E\n"})
public final class FaceEncoderInternal {
    @NotNull
    private final FaceNetModelConfiguration faceNetModelConfig;
    @NotNull
    private final InterpreterImpl interpreter;

    public FaceEncoderInternal(@NotNull FaceNetModelConfiguration faceNetModelConfig) {
        Intrinsics.checkNotNullParameter((Object)faceNetModelConfig, (String)"faceNetModelConfig");
        this.faceNetModelConfig = faceNetModelConfig;
        this.interpreter = new InterpreterImpl("facenet.tflite", this.faceNetModelConfig.getPath(), this.faceNetModelConfig.getModelChecksum(), this.faceNetModelConfig.getModelChecksumMethod(), this.faceNetModelConfig.getOverrideCacheOnWrongChecksum());
    }

    @NotNull
    public final byte[] encode(@NotNull net.iriscan.sdk.core.image.Image image, @Nullable String traceId) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        net.iriscan.sdk.core.image.Image resized = ImageUtilsKt.resizeImg(image, this.faceNetModelConfig.getInputWidth(), this.faceNetModelConfig.getInputHeight());
        float[] data2 = this.normalize(resized.getWidth(), resized.getHeight(), (Function2<? super Integer, ? super Integer, ? extends Color>)((Function2)new Function2<Integer, Integer, Color>(resized){
            final /* synthetic */ net.iriscan.sdk.core.image.Image $resized;
            {
                this.$resized = $resized;
                super(2);
            }

            @NotNull
            public final Color invoke(int x, int y) {
                int color = this.$resized.get(x, y);
                return new Color(ColorKt.red(color), ColorKt.green(color), ColorKt.blue(color));
            }
        }));
        return this.encodeInternal(data2);
    }

    public static /* synthetic */ byte[] encode$default(FaceEncoderInternal faceEncoderInternal, net.iriscan.sdk.core.image.Image image, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = LogUtilsKt.generateTraceID();
        }
        return faceEncoderInternal.encode(image, string);
    }

    @NotNull
    public final byte[] encode(@NotNull BufferedImage image, @Nullable String traceId) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        BufferedImage resized = this.resizeBillinear(image, this.faceNetModelConfig.getInputWidth(), this.faceNetModelConfig.getInputHeight());
        float[] data2 = this.normalize(resized.getWidth(), resized.getHeight(), (Function2<? super Integer, ? super Integer, ? extends Color>)((Function2)new Function2<Integer, Integer, Color>(resized){
            final /* synthetic */ BufferedImage $resized;
            {
                this.$resized = $resized;
                super(2);
            }

            @NotNull
            public final Color invoke(int x, int y) {
                return new Color(this.$resized.getRGB(x, y));
            }
        }));
        return this.encodeInternal(data2);
    }

    public static /* synthetic */ byte[] encode$default(FaceEncoderInternal faceEncoderInternal, BufferedImage bufferedImage, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = LogUtilsKt.generateTraceID();
        }
        return faceEncoderInternal.encode(bufferedImage, string);
    }

    private final BufferedImage resizeBillinear(BufferedImage image, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = resizedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, width, height, null);
        graphics2D.dispose();
        Image tmp = image.getScaledInstance(width, height, 16);
        graphics2D = resizedImage.createGraphics();
        graphics2D.drawImage(tmp, 0, 0, null);
        graphics2D.dispose();
        return resizedImage;
    }

    /*
     * WARNING - void declaration
     */
    private final float[] normalize(int width, int height, Function2<? super Integer, ? super Integer, ? extends Color> getColor) {
        void $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        int n = 0;
        int n2 = width * height;
        float[][] fArrayArray = new float[n2][];
        while (n < n2) {
            int n3 = n++;
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
            fArrayArray[n3] = fArray;
        }
        float[][] rgb = fArrayArray;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color color = (Color)getColor.invoke((Object)x, (Object)y);
                int i = y * width + x;
                rgb[i][0] = color.getRed();
                rgb[i][1] = color.getGreen();
                rgb[i][2] = color.getBlue();
            }
        }
        Object[] $this$flatMap$iv = (Object[])rgb;
        boolean $i$f$flatMap = false;
        Object[] i = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            float[] it = (float[])element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList((float[])it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        float[] pixels = CollectionsKt.toFloatArray((Collection)((List)destination$iv$iv));
        float mean = (float)ArraysKt.average((float[])pixels);
        float[] $this$map$iv = pixels;
        boolean $i$f$map = false;
        float[] $i$f$flatMapTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n4 = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n4; ++j) {
            void pi;
            void item$iv$iv;
            void var16_29 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(Float.valueOf((float)Math.pow((double)(pi - mean), 2)));
        }
        float std = (float)Math.sqrt(CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv2)) / (float)pixels.length);
        std = Math.max(std, 1.0f / (float)Math.sqrt(pixels.length));
        int n5 = pixels.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            pixels[i2] = (pixels[i2] - mean) / std;
        }
        return pixels;
    }

    private final byte[] encodeInternal(float[] data2) {
        Map faceNetModelInputs = MapsKt.mapOf((Pair)TuplesKt.to((Object)0, (Object)data2));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)new float[this.faceNetModelConfig.getOutputLength()])};
        Map faceNetModelOutputs = MapsKt.mutableMapOf((Pair[])pairArray);
        Interpreter.DefaultImpls.invoke$default(this.interpreter, faceNetModelInputs, faceNetModelOutputs, null, 4, null);
        Object v = faceNetModelOutputs.get(0);
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.FloatArray");
        return this.toByteArray((float[])v);
    }

    private final byte[] toByteArray(float[] $this$toByteArray) {
        ByteBuffer buffer = ByteBuffer.allocate($this$toByteArray.length * 4);
        buffer.asFloatBuffer().put($this$toByteArray);
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.array()");
        return byArray;
    }
}

