/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.face.impl;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.iriscan.sdk.core.image.ColorKt;
import net.iriscan.sdk.core.image.Image;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.RectVector;
import org.bytedeco.opencv.opencv_objdetect.CascadeClassifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u001a\u0010\u0005\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\n\u0010\u0007\u001a\u00060\bj\u0002`\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/iriscan/sdk/face/impl/FaceExtractorInternal;", "", "()V", "classifier", "Lorg/bytedeco/opencv/opencv_objdetect/CascadeClassifier;", "extract", "Lnet/iriscan/sdk/core/image/Image;", "image", "Ljava/awt/image/BufferedImage;", "Lnet/iriscan/sdk/core/image/NativeImage;", "extractInternal", "Lorg/bytedeco/opencv/opencv_core/Rect;", "input", "Lorg/bytedeco/opencv/opencv_core/Mat;", "biometric-sdk"})
@SourceDebugExtension(value={"SMAP\nFaceExtractorInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FaceExtractorInternal.kt\nnet/iriscan/sdk/face/impl/FaceExtractorInternal\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,70:1\n10269#2:71\n10697#2,5:72\n*S KotlinDebug\n*F\n+ 1 FaceExtractorInternal.kt\nnet/iriscan/sdk/face/impl/FaceExtractorInternal\n*L\n36#1:71\n36#1:72,5\n*E\n"})
public final class FaceExtractorInternal {
    @NotNull
    private final CascadeClassifier classifier;

    public FaceExtractorInternal() {
        Path classifierFile = new File(System.getProperty("java.io.tmpdir") + "/.biometric-sdk/haarcascade_frontalface_alt.xml").toPath();
        if (!Files.exists(classifierFile, new LinkOption[0])) {
            InputStream inputStream = this.getClass().getResourceAsStream("/haarcascade_frontalface_alt.xml");
            Intrinsics.checkNotNull((Object)inputStream);
            InputStream classifierXml = inputStream;
            Files.createDirectories(classifierFile.getParent(), new FileAttribute[0]);
            Files.copy(classifierXml, classifierFile, new CopyOption[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)classifierFile, (String)"classifierFile");
        this.classifier = new CascadeClassifier(((Object)classifierFile.toAbsolutePath()).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Image extract(@NotNull Image image) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int[] $this$flatMap$iv = image.getColors();
        boolean $i$f$flatMap = false;
        int[] nArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            byte[] byArray = new byte[]{(byte)ColorKt.blue((int)it), (byte)ColorKt.green((int)it), (byte)ColorKt.red((int)it)};
            byte[] byArray2 = ByteBuffer.allocate(3).put(byArray).array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"allocate(3).put(byteArra\u2026\n                .array()");
            Iterable list$iv$iv = ArraysKt.toList((byte[])byArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        byte[] pixels = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
        Mat mat = new Mat(image.getHeight(), image.getWidth(), opencv_core.CV_8UC3, (Pointer)new BytePointer(Arrays.copyOf(pixels, pixels.length)));
        Rect rect = this.extractInternal(mat);
        if (rect == null) {
            return null;
        }
        Rect faceRect = rect;
        return image.get(new IntRange(faceRect.x(), faceRect.x() + faceRect.width()), new IntRange(faceRect.y(), faceRect.y() + faceRect.height()));
    }

    @Nullable
    public final BufferedImage extract(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        DataBuffer dataBuffer = image.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferByte");
        byte[] data2 = ((DataBufferByte)dataBuffer).getData();
        Mat mat = new Mat(image.getHeight(), image.getWidth(), opencv_core.CV_8UC3, (Pointer)new BytePointer(Arrays.copyOf(data2, data2.length)));
        Rect rect = this.extractInternal(mat);
        if (rect == null) {
            return null;
        }
        Rect faceRect = rect;
        return image.getSubimage(faceRect.x(), faceRect.y(), faceRect.width(), faceRect.height());
    }

    private final Rect extractInternal(Mat input) {
        RectVector result2 = new RectVector();
        this.classifier.detectMultiScale(input, result2);
        Rect[] faces = result2.get();
        Intrinsics.checkNotNullExpressionValue((Object)faces, (String)"faces");
        if (faces.length == 0) {
            return null;
        }
        Rect rect = faces[0];
        int n = input.cols();
        int n2 = rect.x();
        boolean bl = 1 <= n2 ? n2 < n : false;
        if (bl) {
            n = input.cols();
            n2 = rect.x() + rect.width();
            boolean bl2 = 1 <= n2 ? n2 < n : false;
            if (bl2) {
                n = input.rows();
                n2 = rect.y();
                boolean bl3 = 1 <= n2 ? n2 < n : false;
                if (bl3) {
                    n = input.rows();
                    n2 = rect.y() + rect.height();
                    boolean bl4 = 1 <= n2 ? n2 < n : false;
                    if (bl4) {
                        return rect;
                    }
                }
            }
        }
        return null;
    }
}

