/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.iris.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.iriscan.sdk.core.image.Circle;
import net.iriscan.sdk.core.image.Image;
import net.iriscan.sdk.core.image.ImageColorType;
import net.iriscan.sdk.core.image.Point;
import net.iriscan.sdk.core.utils.ArrayUtilsKt;
import net.iriscan.sdk.core.utils.ImageUtilsKt;
import net.iriscan.sdk.core.utils.Math;
import net.iriscan.sdk.iris.IrisExtractProperties;
import net.iriscan.sdk.iris.impl.IrisExtractOperationsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u001a#\u0010\u0000\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0085\u0001\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0011j\u0004\u0018\u0001`\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0014\u0010\u001a\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0014\u0010\u001b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u0001H\u0002\u00a2\u0006\u0002\u0010\u001e\u001a\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002*$\b\u0002\u0010!\"\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\u00112\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\u0011\u00a8\u0006\""}, d2={"createCircleModels", "", "", "Lnet/iriscan/sdk/core/image/Point;", "size", "", "(I)[Ljava/lang/Iterable;", "cutTextureFromSample", "Lnet/iriscan/sdk/core/image/Image;", "sample", "iris", "Lnet/iriscan/sdk/core/image/Circle;", "pupil", "extractInternal", "props", "Lnet/iriscan/sdk/iris/IrisExtractProperties;", "getMostIntenseCircle", "Lkotlin/Pair;", "Lnet/iriscan/sdk/iris/impl/CircleIntensity;", "image", "centerX", "centerY", "radiusMin", "radiusMax", "radiusStep", "calculationSteps", "circleModels", "circleAngles", "Lkotlin/ranges/ClosedRange;", "", "(Lnet/iriscan/sdk/core/image/Image;IIIIII[Ljava/lang/Iterable;[Lkotlin/ranges/ClosedRange;)Lkotlin/Pair;", "getMostIntenseRegions", "", "CircleIntensity", "biometric-sdk"})
@SourceDebugExtension(value={"SMAP\nIrisExtractOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrisExtractOperations.kt\nnet/iriscan/sdk/iris/impl/IrisExtractOperationsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,190:1\n1963#2,14:191\n766#2:206\n857#2:207\n858#2:210\n1855#2,2:211\n1963#2,14:213\n1#3:205\n12744#4,2:208\n3819#4:227\n4337#4,2:228\n3819#4:230\n4337#4,2:231\n*S KotlinDebug\n*F\n+ 1 IrisExtractOperations.kt\nnet/iriscan/sdk/iris/impl/IrisExtractOperationsKt\n*L\n50#1:191,14\n128#1:206\n128#1:207\n128#1:210\n135#1:211,2\n145#1:213,14\n133#1:208,2\n171#1:227\n171#1:228,2\n175#1:230\n175#1:231,2\n*E\n"})
public final class IrisExtractOperationsKt {
    @Nullable
    public static final Image extractInternal(@NotNull Image sample, @NotNull IrisExtractProperties props) {
        Circle circle;
        Object object;
        Object v2;
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Image original = sample.clone();
        ImageUtilsKt.grayscaleImg(sample);
        ImageUtilsKt.fillImg(sample, 200, 12, 4);
        ImageUtilsKt.gaussianFilterImg$default(sample, null, 0, 6, null);
        Iterable<Point>[] circleModels = IrisExtractOperationsKt.createCircleModels(java.lang.Math.min(sample.getWidth(), sample.getHeight()));
        List<Circle> intenseRegions = IrisExtractOperationsKt.getMostIntenseRegions(sample, props);
        Integer n = props.getMinPupilRadius();
        int minPupilRadius = n != null ? n : (int)(0.05 * (double)java.lang.Math.min(sample.getWidth(), sample.getHeight()));
        Integer n2 = props.getMaxPupilRadius();
        int approximateMaxPupilRadius = n2 != null ? n2 : 5 * minPupilRadius;
        List possibleIntensities = new ArrayList();
        block0: for (Circle region : intenseRegions) {
            int maxOffset = (int)((double)region.getR() * 0.7071);
            int n3 = region.getX() - maxOffset;
            int n4 = region.getX() + maxOffset;
            int n5 = props.getCenterOffsetStep();
            if (n5 <= 0) {
                throw new IllegalArgumentException("Step must be positive, was: " + n5 + ".");
            }
            int cx = n3;
            int n6 = ProgressionUtilKt.getProgressionLastElement((int)n3, (int)n4, (int)n5);
            int n7 = n5;
            if (cx > n6) continue;
            while (true) {
                int n8 = region.getY() - maxOffset;
                int n9 = region.getY() + maxOffset;
                int n10 = props.getCenterOffsetStep();
                if (n10 <= 0) {
                    throw new IllegalArgumentException("Step must be positive, was: " + n10 + ".");
                }
                int cy = n8;
                int n11 = ProgressionUtilKt.getProgressionLastElement((int)n8, (int)n9, (int)n10);
                int n12 = n10;
                if (cy <= n11) {
                    while (true) {
                        int maxPupilRadius;
                        if (IrisExtractOperationsKt.getMostIntenseCircle(sample, cx, cy, minPupilRadius, maxPupilRadius = java.lang.Math.min(approximateMaxPupilRadius, java.lang.Math.min(java.lang.Math.min(cx, cy), java.lang.Math.min(sample.getWidth() - cx, sample.getHeight() - cy))) - props.getPupilRadiusCalculationSteps(), props.getPupilRadiusStep(), props.getPupilRadiusCalculationSteps(), circleModels, props.getPupilAnglesToSearch()) != null) {
                            Pair<Circle, Integer> operatorRes;
                            ((Collection)possibleIntensities).add(operatorRes);
                        }
                        if (cy == n11) break;
                        cy += n12;
                    }
                }
                if (cx == n6) continue block0;
                cx += n7;
            }
        }
        Iterable $this$maxByOrNull$iv = possibleIntensities;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                Pair it = (Pair)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = ((Number)it.getSecond()).intValue();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair it2 = (Pair)e$iv;
                    $i$a$-maxByOrNull-IrisExtractOperationsKt$extractInternal$pupil$1 = false;
                    int v$iv = ((Number)it2.getSecond()).intValue();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        if ((object = (Pair)v2) == null || (object = (Circle)object.getFirst()) == null) {
            return null;
        }
        Object pupil = object;
        Integer n13 = props.getMinIrisRadius();
        int approximateMinIrisRadius = n13 != null ? n13 : (int)(1.3 * (double)((Circle)pupil).getR());
        Integer n14 = props.getMaxIrisRadius();
        int approximateMaxIrisRadius = n14 != null ? n14 : 10 * ((Circle)pupil).getR();
        int maxIirisRadius = java.lang.Math.min(approximateMaxIrisRadius, java.lang.Math.min(java.lang.Math.min(((Circle)pupil).getX(), ((Circle)pupil).getY()), java.lang.Math.min(sample.getWidth() - ((Circle)pupil).getX(), sample.getHeight() - ((Circle)pupil).getY()))) - props.getIrisRadiusCalculationSteps();
        Pair<Circle, Integer> pair = IrisExtractOperationsKt.getMostIntenseCircle(sample, ((Circle)pupil).getX(), ((Circle)pupil).getY(), approximateMinIrisRadius, maxIirisRadius, props.getIrisRadiusStep(), props.getIrisRadiusCalculationSteps(), circleModels, props.getIrisAnglesToSearch());
        if (pair == null || (circle = (Circle)pair.getFirst()) == null) {
            return null;
        }
        Circle iris = circle;
        return IrisExtractOperationsKt.cutTextureFromSample(original, iris, (Circle)pupil);
    }

    private static final Image cutTextureFromSample(Image sample, Circle iris, Circle pupil) {
        Image image = sample.clone();
        ImageUtilsKt.normalizeHistogramImg$default(image, null, 2, null);
        int width = (int)(java.lang.Math.PI * 2 * (double)iris.getR());
        int height = iris.getR() - pupil.getR();
        Image result2 = ImageUtilsKt.createImg(width, height, ImageColorType.GRAY, (Function2<? super Integer, ? super Integer, Integer>)((Function2)cutTextureFromSample.result.1.INSTANCE));
        double angleStep = java.lang.Math.PI * 2 / (double)width;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int r = pupil.getR() + y;
                double angle = (double)x * angleStep;
                int xr = pupil.getX() + (int)java.lang.Math.rint(java.lang.Math.cos(angle) * (double)r);
                int yr = pupil.getY() + (int)java.lang.Math.rint(java.lang.Math.sin(angle) * (double)r);
                result2.set(x, y, image.get(xr, yr));
            }
        }
        return result2;
    }

    private static final Iterable<Point>[] createCircleModels(int size) {
        int n = 0;
        Set[] setArray = new Set[size];
        while (n < size) {
            int n2 = n++;
            setArray[n2] = new LinkedHashSet();
        }
        Set[] circleModels = setArray;
        int x = -size;
        if (x <= size) {
            while (true) {
                int y;
                if ((y = -size) <= size) {
                    while (true) {
                        int n3;
                        double rt;
                        int r;
                        if ((r = (int)(rt = java.lang.Math.sqrt((double)(x * x) + (double)(y * y)))) <= (n3 = (int)java.lang.Math.rint(rt))) {
                            while (true) {
                                if (r < size) {
                                    circleModels[r].add(new Point(x, y));
                                }
                                if (r == n3) break;
                                ++r;
                            }
                        }
                        if (y == size) break;
                        ++y;
                    }
                }
                if (x == size) break;
                ++x;
            }
        }
        return circleModels;
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<Circle, Integer> getMostIntenseCircle(Image image, int centerX, int centerY, int radiusMin, int radiusMax, int radiusStep, int calculationSteps, Iterable<Point>[] circleModels, ClosedRange<Double>[] circleAngles) {
        Object v1;
        void it;
        List radiusList = CollectionsKt.toList((Iterable)((Iterable)RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)radiusMin, (int)radiusMax)), (int)radiusStep)));
        int[] intensities = new int[radiusList.size()];
        Object object = circleAngles;
        double d = 0.0;
        int n = ((ClosedRange<Double>[])object).length;
        for (int i = 0; i < n; ++i) {
            ClosedRange<Double> closedRange;
            ClosedRange<Double> closedRange2 = closedRange = object[i];
            double d2 = d;
            boolean bl = false;
            double d3 = ((Number)((Object)it.getEndInclusive())).doubleValue() - ((Number)((Object)it.getStart())).doubleValue();
            d = d2 + d3;
        }
        double anglesSum = d;
        object = radiusList.iterator();
        int n2 = 0;
        while (object.hasNext()) {
            void $this$forEach$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            int radiusIndex = n2++;
            int radius = ((Number)object.next()).intValue();
            Iterable iterable = CollectionsKt.flatten((Iterable)ArraysKt.slice((Object[])circleModels, (IntRange)new IntRange(radius, radius + calculationSteps)));
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                Object element$iv$iv;
                block12: {
                    element$iv$iv = iterator.next();
                    Point it2 = (Point)element$iv$iv;
                    boolean bl2 = false;
                    double angle = 0.0;
                    angle = Math.INSTANCE.toDegrees$biometric_sdk(java.lang.Math.atan2(it2.getY(), it2.getX()) + 1.5707963267948966);
                    if (angle < 0.0) {
                        angle += (double)360;
                    }
                    ClosedRange<Double>[] $this$any$iv = circleAngles;
                    boolean $i$f$any = false;
                    int n3 = $this$any$iv.length;
                    for (int i = 0; i < n3; ++i) {
                        ClosedRange<Double> element$iv;
                        ClosedRange<Double> an = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        if (!an.contains((Comparable)Double.valueOf(angle))) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterTo$iv$iv.next();
                Point it3 = (Point)element$iv;
                boolean bl = false;
                intensities[radiusIndex] = intensities[radiusIndex] + (255 - image.get(centerX + it3.getX(), centerY + it3.getY()));
            }
            int divisor = (int)(anglesSum / 360.0 * (double)2 * java.lang.Math.PI * (double)radius) * calculationSteps;
            if (divisor == 0) continue;
            intensities[radiusIndex] = intensities[radiusIndex] / divisor;
        }
        int[] intensityDiff = ArrayUtilsKt.minus(ArrayUtilsKt.get(intensities, RangesKt.until((int)1, (int)intensities.length)), ArrayUtilsKt.get(intensities, RangesKt.until((int)0, (int)(intensities.length - 1))));
        Iterable $this$maxByOrNull$iv = (Iterable)ArraysKt.getIndices((int[])intensityDiff);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                int it4 = ((Number)maxElem$iv).intValue();
                boolean bl = false;
                int maxValue$iv = intensityDiff[it4];
                do {
                    Object e$iv = iterator$iv.next();
                    int it5 = ((Number)e$iv).intValue();
                    $i$a$-maxByOrNull-IrisExtractOperationsKt$getMostIntenseCircle$maxIntensityIdx$1 = false;
                    int v$iv = intensityDiff[it5];
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        Integer n4 = v1;
        if (n4 == null) {
            return null;
        }
        int maxIntensityIdx = n4;
        int radius = radiusMin + maxIntensityIdx * radiusStep;
        return TuplesKt.to((Object)new Circle(centerX, centerY, radius), (Object)intensityDiff[maxIntensityIdx]);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Circle> getMostIntenseRegions(Image sample, IrisExtractProperties props) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        int element$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        Image image = sample.clone();
        ImageUtilsKt.normalizeHistogramImg(image, null);
        int[] verticalProjection = new int[image.getWidth()];
        int[] horizontalProjection = new int[image.getHeight()];
        Integer n = props.getVerticalOffsetStart();
        int verticalOffStart = n != null ? n : image.getWidth() / 5;
        Integer n2 = props.getVerticalOffsetEnd();
        int verticalOffEnd = n2 != null ? n2 : image.getWidth() / 5;
        Integer n3 = props.getHorizontalOffsetStart();
        int horizontalOffStart = n3 != null ? n3 : image.getHeight() / 5;
        Integer n4 = props.getHorizontalOffsetEnd();
        int horizontalOffEnd = n4 != null ? n4 : image.getHeight() / 5;
        int n5 = image.getWidth() - verticalOffEnd;
        for (int x = verticalOffStart; x < n5; ++x) {
            int n6 = image.getHeight() - horizontalOffEnd;
            for (int y = horizontalOffStart; y < n6; ++y) {
                if (image.get(x, y) > 64) continue;
                int[] nArray = verticalProjection;
                int n7 = x;
                nArray[n7] = nArray[n7] + 1;
                nArray = horizontalProjection;
                n7 = y;
                nArray[n7] = nArray[n7] + 1;
            }
        }
        verticalProjection = ArrayUtilsKt.smooth(verticalProjection, 4);
        horizontalProjection = ArrayUtilsKt.smooth(horizontalProjection, 4);
        int[] nArray = ArraysKt.sliceArray((int[])verticalProjection, (IntRange)RangesKt.until((int)verticalOffStart, (int)(image.getWidth() - verticalOffEnd)));
        boolean $i$f$filter22 = false;
        void var12_16 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n8 = ((void)$this$filterTo$iv$iv2).length;
        for (int i = 0; i < n8; ++i) {
            element$iv$iv = $this$filterTo$iv$iv2[i];
            void it = element$iv$iv;
            boolean bl = false;
            if (!(it > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int verticalDrop = ArrayUtilsKt.median(CollectionsKt.toIntArray((Collection)((List)destination$iv$iv)));
        int[] $i$f$filter22 = ArraysKt.sliceArray((int[])horizontalProjection, (IntRange)RangesKt.until((int)horizontalOffStart, (int)(image.getHeight() - horizontalOffEnd)));
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        element$iv$iv = ((void)$this$filterTo$iv$iv).length;
        for (n8 = 0; n8 < element$iv$iv; ++n8) {
            void element$iv$iv2;
            void it = element$iv$iv2 = $this$filterTo$iv$iv[n8];
            boolean bl = false;
            if (!(it > 0)) continue;
            destination$iv$iv2.add((int)element$iv$iv2);
        }
        int horizontalDrop = ArrayUtilsKt.median(CollectionsKt.toIntArray((Collection)((List)destination$iv$iv2)));
        List regions = new ArrayList();
        List<IntRange> vSegments = ArrayUtilsKt.findSegmentsGte(verticalProjection, verticalDrop);
        List<IntRange> hSegments = ArrayUtilsKt.findSegmentsGte(horizontalProjection, horizontalDrop);
        for (IntRange vs : vSegments) {
            for (IntRange hs : hSegments) {
                int x = (vs.getFirst() + vs.getLast()) / 2;
                int y = (hs.getFirst() + hs.getLast()) / 2;
                int r = java.lang.Math.min(CollectionsKt.count((Iterable)((Iterable)vs)), CollectionsKt.count((Iterable)((Iterable)hs)));
                ((Collection)regions).add(new Circle(x, y, r));
            }
        }
        return regions;
    }
}

