/*
 * Decompiled with CFR 0.152.
 */
package net.iriscan.sdk.io.image.impl;

import java.awt.image.BufferedImage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.iriscan.sdk.core.image.Image;
import net.iriscan.sdk.core.image.NativeImageKt;
import net.iriscan.sdk.io.InputOutputImageOperations;
import net.iriscan.sdk.io.exception.UnknownFormatException;
import net.iriscan.sdk.io.image.ImageFormat;
import net.iriscan.sdk.io.image.ImageSerializer;
import net.iriscan.sdk.io.image.serializers.BMP;
import net.iriscan.sdk.io.image.serializers.PNG;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00060\u000bj\u0002`\f2\n\u0010\b\u001a\u00060\tj\u0002`\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00060\tj\u0002`\r2\n\u0010\u000f\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/iriscan/sdk/io/image/impl/InputOutputImageOperationsImpl;", "Lnet/iriscan/sdk/io/InputOutputImageOperations;", "()V", "serializers", "", "Lnet/iriscan/sdk/io/image/ImageSerializer;", "readImage", "Lnet/iriscan/sdk/core/image/Image;", "data", "", "readNativeImage", "Ljava/awt/image/BufferedImage;", "Lnet/iriscan/sdk/core/image/NativeImage;", "Lnet/iriscan/sdk/core/io/DataBytes;", "writeImage", "image", "format", "Lnet/iriscan/sdk/io/image/ImageFormat;", "writeNativeImage", "biometric-sdk"})
@SourceDebugExtension(value={"SMAP\nInputOutputImageOperationsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputOutputImageOperationsImpl.kt\nnet/iriscan/sdk/io/image/impl/InputOutputImageOperationsImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n288#2,2:39\n288#2,2:41\n*S KotlinDebug\n*F\n+ 1 InputOutputImageOperationsImpl.kt\nnet/iriscan/sdk/io/image/impl/InputOutputImageOperationsImpl\n*L\n22#1:39,2\n31#1:41,2\n*E\n"})
public final class InputOutputImageOperationsImpl
implements InputOutputImageOperations {
    @NotNull
    private final List<ImageSerializer> serializers;

    public InputOutputImageOperationsImpl() {
        Object[] objectArray = new ImageSerializer[]{BMP.INSTANCE, PNG.INSTANCE};
        this.serializers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Image readImage(@NotNull byte[] data2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Iterable $this$firstOrNull$iv = this.serializers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ImageSerializer it = (ImageSerializer)element$iv;
                boolean bl = false;
                if (!it.canRead(data2)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ImageSerializer imageSerializer = v0;
        if (imageSerializer == null) {
            throw new UnknownFormatException("Unknown image format");
        }
        ImageSerializer serializer = imageSerializer;
        return serializer.read(data2);
    }

    @Override
    @NotNull
    public BufferedImage readNativeImage(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return NativeImageKt.internalReadNativeImage(data2);
    }

    @Override
    @NotNull
    public byte[] writeImage(@NotNull Image image, @NotNull ImageFormat format) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            Iterable $this$firstOrNull$iv = this.serializers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ImageSerializer it = (ImageSerializer)element$iv;
                boolean bl = false;
                if (!(it.getFormat() == format)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ImageSerializer imageSerializer = v0;
        if (imageSerializer == null) {
            throw new UnknownFormatException("Unsupported image format");
        }
        ImageSerializer serializer = imageSerializer;
        return serializer.write(image);
    }

    @Override
    @NotNull
    public byte[] writeNativeImage(@NotNull BufferedImage image, @NotNull ImageFormat format) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        return NativeImageKt.internalWriteNativeImage(image, format);
    }
}

